/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.manageacademictreasurysettings;

import java.util.stream.Collectors;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.ProductGroup;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageAcademicTreasurySettings", accessGroup="treasuryManagers")
@RequestMapping(value={"/academictreasury/manageacademictreasurysettings/academictreasurysettings"})
public class AcademicTreasurySettingsController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/manageacademictreasurysettings/academictreasurysettings";
    private static final String JSP_PATH = "academicTreasury/manageacademictreasurysettings/academictreasurysettings";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/academictreasury/manageacademictreasurysettings/academictreasurysettings/read/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/academictreasury/manageacademictreasurysettings/academictreasurysettings/update/";
    private static final String _ADDACADEMICALACTBLOCKINGPRODUCT_URI = "/addacademicalactblockingproduct/";
    public static final String ADDACADEMICALACTBLOCKINGPRODUCT_URL = "/academictreasury/manageacademictreasurysettings/academictreasurysettings/addacademicalactblockingproduct/";
    private static final String _REMOVEACADEMICALACTBLOCKINGPRODUCT_URI = "/removeacademicalactblockingproduct/";
    public static final String REMOVEACADEMICALACTBLOCKINGPRODUCT_URL = "/academictreasury/manageacademictreasurysettings/academictreasurysettings/removeacademicalactblockingproduct/";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/manageacademictreasurysettings/academictreasurysettings/read/";
    }

    @RequestMapping(value={"/read/"})
    public String read(Model model) {
        model.addAttribute("products", Product.findAll().sorted(Product.COMPARE_BY_NAME).collect(Collectors.toList()));
        model.addAttribute("academicTreasurySettings", (Object)AcademicTreasurySettings.getInstance());
        return this.jspPage("read");
    }

    @RequestMapping(value={"/update/"}, method={RequestMethod.GET})
    public String update(Model model) {
        model.addAttribute("AcademicTreasurySettings_emolumentsProductGroup_options", (Object)ProductGroup.readAll());
        model.addAttribute("AcademicTreasurySettings_tuitionProductGroup_options", (Object)ProductGroup.readAll());
        model.addAttribute("AcademicTreasurySettings_improvementAcademicTax_options", AcademicTax.findAll().sorted(AcademicTax.COMPARE_BY_PRODUCT_NAME).collect(Collectors.toList()));
        model.addAttribute("academicTreasurySettings", (Object)AcademicTreasurySettings.getInstance());
        return this.jspPage("update");
    }

    @RequestMapping(value={"/update/"}, method={RequestMethod.POST})
    public String update(@RequestParam(value="emolumentsproductgroup", required=false) ProductGroup emolumentsProductGroup, @RequestParam(value="tuitionproductgroup", required=false) ProductGroup tuitionProductGroup, @RequestParam(value="improvementacademictax", required=false) AcademicTax improvementAcademicTax, @RequestParam(value="closeservicerequestemolumentswithdebitnote", required=false) boolean closeServiceRequestEmolumentsWithDebitNote, @RequestParam(value="runacademicdebtgenerationruleonnormalenrolment", required=false) boolean runAcademicDebtGenerationRuleOnNormalEnrolment, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicTreasurySettings.getInstance().edit(emolumentsProductGroup, tuitionProductGroup, improvementAcademicTax, closeServiceRequestEmolumentsWithDebitNote, runAcademicDebtGenerationRuleOnNormalEnrolment);
            return this.redirect(READ_URL, model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.update(model);
        }
    }

    @RequestMapping(value={"/addacademicalactblockingproduct/{productId}"}, method={RequestMethod.GET})
    public String addAcademicalActBlockingProduct(@PathVariable(value="productId") Product product, Model model) {
        try {
            AcademicTreasurySettings.getInstance().addAcademicalActBlockingProduct(product);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.read(model);
    }

    @RequestMapping(value={"/removeacademicalactblockingproduct/{productId}"}, method={RequestMethod.GET})
    public String removeAcademicalActBlockingProduct(@PathVariable(value="productId") Product product, Model model) {
        try {
            AcademicTreasurySettings.getInstance().removeAcademicalActBlockingProduct(product);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.read(model);
    }

    private String jspPage(String page) {
        return "academicTreasury/manageacademictreasurysettings/academictreasurysettings/" + page;
    }
}

