/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.integration.tuitioninfo;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academictreasury.domain.integration.ERPTuitionInfoExportOperation;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/academictreasury/erptuitioninfoexportoperation"})
@SpringFunctionality(app=AcademicTreasuryController.class, title="label.ERPTuitionInfoExportOperation.title", accessGroup="#managers")
public class ERPTuitionInfoExportOperationController
extends AcademicTreasuryBaseController {
    private static final int MAX_SEARCH_RESULT_SIZE = 3000;
    public static final String CONTROLLER_URL = "/academictreasury/erptuitioninfoexportoperation";
    private static final String JSP_PATH = "academicTreasury/erptuitioninfoexportoperation";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academictreasury/erptuitioninfoexportoperation/search";
    private static final String _READ_URI = "/read";
    public static final String READ_URL = "/academictreasury/erptuitioninfoexportoperation/read";
    private static final String _DOWNLOAD_URI = "/download";
    public static final String DOWNLOAD_URL = "/academictreasury/erptuitioninfoexportoperation/download";
    private static final String _RETRY_URI = "/retry";
    public static final String RETRY_URL = "/academictreasury/erptuitioninfoexportoperation/retry";
    private static final String _SOAPOUTBOUNDMESSAGE_URI = "/soapoutboundmessage";
    public static final String SOAPOUTBOUNDMESSAGE_URL = "/academictreasury/erptuitioninfoexportoperation/soapoutboundmessage";
    private static final String _SOAPINBOUNDMESSAGE_URI = "/soapinboundmessage";
    public static final String SOAPINBOUNDMESSAGE_URL = "/academictreasury/erptuitioninfoexportoperation/soapinboundmessage";

    @RequestMapping
    public String home() {
        return "redirect:/academictreasury/erptuitioninfoexportoperation/search";
    }

    @RequestMapping(value={"/search"})
    public String search(@RequestParam(value="fromDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate fromDate, @RequestParam(value="toDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate toDate, @RequestParam(value="erpTuitionInfoDocumentNumber", required=false) String erpTuitionInfoDocumentNumber, @RequestParam(value="success", required=false) Boolean success, Model model) {
        List<ERPTuitionInfoExportOperation> result = this.filter(fromDate, toDate, erpTuitionInfoDocumentNumber, success);
        if (result.size() > 3000) {
            model.addAttribute("result_totalCount", (Object)result.size());
            result = result.subList(0, 3000);
            model.addAttribute("limit_exceeded", (Object)true);
        }
        model.addAttribute("result", result);
        return this.jspPage(_SEARCH_URI);
    }

    private List<ERPTuitionInfoExportOperation> filter(LocalDate fromDate, LocalDate toDate, String erpTuitionInfoDocumentNumber, Boolean success) {
        Optional<ERPTuitionInfo> info;
        Stream<ERPTuitionInfoExportOperation> base = null;
        if (!Strings.isNullOrEmpty((String)erpTuitionInfoDocumentNumber) && (info = ERPTuitionInfo.findUniqueByDocumentNumber(erpTuitionInfoDocumentNumber)).isPresent()) {
            base = info.get().getErpTuitionInfoExportOperationsSet().stream();
        }
        if (base == null) {
            base = ERPTuitionInfoExportOperation.findAll();
        }
        if (fromDate != null) {
            base = base.filter(e -> !e.getExecutionDate().isBefore((ReadableInstant)fromDate.toDateTimeAtStartOfDay()));
        }
        if (toDate != null) {
            base = base.filter(e -> !e.getExecutionDate().isAfter((ReadableInstant)toDate.plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1)));
        }
        if (success != null) {
            base = base.filter(e -> e.getSuccess() == success.booleanValue());
        }
        return base.sorted(ERPTuitionInfoExportOperation.COMPARE_BY_EXECUTION_DATE.reversed()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/read/{operationId}"}, method={RequestMethod.GET})
    public String read(@PathVariable(value="operationId") ERPTuitionInfoExportOperation erpTuitionInfoExportOperation, Model model) {
        model.addAttribute("operation", (Object)erpTuitionInfoExportOperation);
        return this.jspPage(_READ_URI);
    }

    @RequestMapping(value={"/download/{operationId}"})
    public String download(@PathVariable(value="operationId") ERPTuitionInfoExportOperation operation, HttpServletResponse response, Model model) {
        String filename = operation.getFile().getFilename();
        response.setContentType(operation.getFile().getContentType());
        response.setHeader("Content-disposition", "attachment; filename=" + filename);
        try {
            response.getOutputStream().write(operation.getFile().getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @RequestMapping(value={"/soapoutboundmessage/{operationId}"})
    public String soapoutboundmessage(@PathVariable(value="operationId") ERPTuitionInfoExportOperation operation, HttpServletResponse response, Model model) {
        response.setContentType(MediaType.XML_UTF_8.toString());
        response.setHeader("Content-disposition", String.format("attachment; filename=SOAP_Outbound_Message_%s.xml", operation.getExternalId()));
        try {
            response.getWriter().write(operation.getSoapOutboundMessage() != null ? operation.getSoapOutboundMessage() : "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @RequestMapping(value={"/soapinboundmessage/{operationId}"})
    public String soapinboundmessage(@PathVariable(value="operationId") ERPTuitionInfoExportOperation operation, HttpServletResponse response, Model model) {
        response.setContentType(MediaType.XML_UTF_8.toString());
        response.setHeader("Content-disposition", String.format("attachment; filename=SOAP_Inbound_Message_%s.xml", operation.getExternalId()));
        try {
            response.getWriter().write(operation.getSoapInboundMessage() != null ? operation.getSoapInboundMessage() : "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private String jspPage(String page) {
        return JSP_PATH + page;
    }
}

