/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.debtReports;

import java.util.stream.Stream;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AcademicActBlockingSuspensionReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.DebtAccountReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.DebtReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.PaymentReferenceCodeEntryBean;
import org.fenixedu.academictreasury.dto.reports.PaymentReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.ProductReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.ReimbursementReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.SettlementReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.SibsTransactionDetailEntryBean;
import org.fenixedu.academictreasury.dto.reports.TreasuryExemptionReportEntryBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;

public class DebtReportService {
    public static Stream<DebtReportEntryBean> debitEntriesReport(DebtReportRequest request, ErrorsLog log) {
        return DebitEntry.findAll().filter(i -> AcademicTreasuryConstants.isDateBetween(request.getBeginDate(), request.getEndDate(), TreasuryPlataformDependentServicesFactory.implementation().versioningCreationDate(i))).filter(i -> request.isIncludeAnnuledEntries() || !i.isAnnulled()).filter(i -> request.getDegreeType() == null || request.getDegreeType() == DebtReportService.degreeType(i)).filter(i -> request.getExecutionYear() == null || request.getExecutionYear() == DebtReportService.executionYear(i)).map(i -> new DebtReportEntryBean((InvoiceEntry)i, request, log));
    }

    public static Stream<DebtReportEntryBean> creditEntriesReport(DebtReportRequest request, ErrorsLog log) {
        return CreditEntry.findAll().filter(i -> AcademicTreasuryConstants.isDateBetween(request.getBeginDate(), request.getEndDate(), TreasuryPlataformDependentServicesFactory.implementation().versioningCreationDate(i))).filter(i -> request.isIncludeAnnuledEntries() || !i.isAnnulled()).filter(i -> request.getDegreeType() == null || request.getDegreeType() == DebtReportService.degreeType(i)).filter(i -> request.getExecutionYear() == null || request.getExecutionYear() == DebtReportService.executionYear(i)).map(i -> new DebtReportEntryBean((InvoiceEntry)i, request, log));
    }

    public static Stream<SettlementReportEntryBean> settlementEntriesReport(DebtReportRequest request, ErrorsLog log) {
        return SettlementEntry.findAll().filter(i -> AcademicTreasuryConstants.isDateBetween(request.getBeginDate(), request.getEndDate(), i.getFinantialDocument().getDocumentDate())).filter(i -> request.isIncludeAnnuledEntries() || !i.isAnnulled()).map(i -> new SettlementReportEntryBean((SettlementEntry)i, request, log));
    }

    public static Stream<PaymentReportEntryBean> paymentEntriesReport(DebtReportRequest request, ErrorsLog log) {
        return PaymentEntry.findAll().filter(i -> AcademicTreasuryConstants.isDateBetween(request.getBeginDate(), request.getEndDate(), i.getSettlementNote().getDocumentDate())).filter(i -> request.isIncludeAnnuledEntries() || !i.getSettlementNote().isAnnulled()).map(i -> new PaymentReportEntryBean((PaymentEntry)i, request, log));
    }

    public static Stream<ReimbursementReportEntryBean> reimbursementEntriesReport(DebtReportRequest request, ErrorsLog log) {
        return ReimbursementEntry.findAll().filter(i -> AcademicTreasuryConstants.isDateBetween(request.getBeginDate(), request.getEndDate(), i.getSettlementNote().getDocumentDate())).filter(i -> request.isIncludeAnnuledEntries() || !i.getSettlementNote().isAnnulled()).map(i -> new ReimbursementReportEntryBean((ReimbursementEntry)i, request, log));
    }

    public static Stream<DebtAccountReportEntryBean> debtAccountEntriesReport(DebtReportRequest request, ErrorsLog log) {
        return DebtAccount.findAll().map(i -> new DebtAccountReportEntryBean((DebtAccount)i, request, log));
    }

    public static Stream<AcademicActBlockingSuspensionReportEntryBean> academicActBlockingSuspensionReport(DebtReportRequest request, ErrorsLog log) {
        return AcademicActBlockingSuspension.findAll().map(i -> new AcademicActBlockingSuspensionReportEntryBean((AcademicActBlockingSuspension)((Object)i), log));
    }

    public static Stream<PaymentReferenceCodeEntryBean> paymentReferenceCodeReport(DebtReportRequest request, ErrorsLog log) {
        return PaymentReferenceCode.findAll().filter(i -> request.isIncludeAnnuledEntries() || !i.isAnnulled()).map(i -> new PaymentReferenceCodeEntryBean((PaymentReferenceCode)i, request, log));
    }

    public static Stream<SibsTransactionDetailEntryBean> sibsTransactionDetailReport(DebtReportRequest request, ErrorsLog log) {
        return SibsTransactionDetail.findAll().map(i -> new SibsTransactionDetailEntryBean((SibsTransactionDetail)i, request, log));
    }

    public static Stream<TreasuryExemptionReportEntryBean> treasuryExemptionReport(DebtReportRequest request, ErrorsLog log) {
        return TreasuryExemption.findAll().filter(i -> i.getDebitEntry() != null && AcademicTreasuryConstants.isDateBetween(request.getBeginDate(), request.getEndDate(), i.getDebitEntry().getEntryDateTime())).filter(i -> request.getDegreeType() == null || request.getDegreeType() == DebtReportService.degreeType(i)).filter(i -> request.getExecutionYear() == null || request.getExecutionYear() == DebtReportService.executionYear(i)).map(i -> new TreasuryExemptionReportEntryBean((TreasuryExemption)i, request, log));
    }

    public static Stream<ProductReportEntryBean> productReport(DebtReportRequest request, ErrorsLog log) {
        return Product.findAll().map(i -> new ProductReportEntryBean((Product)i, request, log));
    }

    private static ExecutionYear executionYear(DebitEntry debitEntry) {
        if (debitEntry.getTreasuryEvent() == null) {
            return null;
        }
        if (!(debitEntry.getTreasuryEvent() instanceof AcademicTreasuryEvent)) {
            return null;
        }
        return ((AcademicTreasuryEvent)debitEntry.getTreasuryEvent()).getExecutionYear();
    }

    private static DegreeType degreeType(DebitEntry debitEntry) {
        if (debitEntry.getTreasuryEvent() == null) {
            return null;
        }
        if (!(debitEntry.getTreasuryEvent() instanceof AcademicTreasuryEvent)) {
            return null;
        }
        if (((AcademicTreasuryEvent)debitEntry.getTreasuryEvent()).getRegistration() == null) {
            return null;
        }
        return ((AcademicTreasuryEvent)debitEntry.getTreasuryEvent()).getRegistration().getDegreeType();
    }

    private static ExecutionYear executionYear(CreditEntry creditEntry) {
        if (creditEntry.getDebitEntry() == null) {
            return null;
        }
        return DebtReportService.executionYear(creditEntry.getDebitEntry());
    }

    private static DegreeType degreeType(CreditEntry creditEntry) {
        if (creditEntry.getDebitEntry() == null) {
            return null;
        }
        return DebtReportService.degreeType(creditEntry.getDebitEntry());
    }

    private static ExecutionYear executionYear(TreasuryExemption exemption) {
        return DebtReportService.executionYear(exemption.getDebitEntry());
    }

    private static DegreeType degreeType(TreasuryExemption exemption) {
        return DebtReportService.degreeType(exemption.getDebitEntry());
    }
}

