/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AbstractReportEntryBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.joda.time.DateTime;

public class SibsTransactionDetailEntryBean
extends AbstractReportEntryBean {
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.whenProcessed", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.whenRegistered", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.amountPayed", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.sibsEntityReferenceCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.sibsPaymentReferenceCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.sibsTransactionId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.businessIdentification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.fiscalNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.customerName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.settlementDocumentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.SibsTransactionDetailEntryBean.header.comments", new String[0])};
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private DateTime whenProcessed;
    private DateTime whenRegistered;
    private String amountPayed;
    private String sibsEntityReferenceCode;
    private String sibsPaymentReferenceCode;
    private String sibsTransactionId;
    private String debtAccountId;
    private String customerId;
    private String businessIdentification;
    private String fiscalNumber;
    private String customerName;
    private String settlementDocumentNumber;
    private String comments;
    private SibsTransactionDetail sibsTransactionDetail;
    boolean completed = false;

    public SibsTransactionDetailEntryBean(SibsTransactionDetail detail, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        String decimalSeparator = request.getDecimalSeparator();
        try {
            this.sibsTransactionDetail = detail;
            this.identification = detail.getExternalId();
            this.versioningCreator = treasuryServices.versioningCreatorUsername((Object)detail);
            this.creationDate = treasuryServices.versioningCreationDate((Object)detail);
            this.whenProcessed = detail.getWhenProcessed();
            this.whenRegistered = detail.getWhenRegistered();
            this.amountPayed = detail.getAmountPayed() != null ? detail.getAmountPayed().toString() : "";
            this.sibsEntityReferenceCode = detail.getSibsEntityReferenceCode();
            this.sibsPaymentReferenceCode = detail.getSibsPaymentReferenceCode();
            this.sibsTransactionId = detail.getSibsTransactionId();
            this.debtAccountId = detail.getDebtAccountId();
            this.customerId = detail.getCustomerId();
            this.businessIdentification = detail.getBusinessIdentification();
            this.fiscalNumber = detail.getFiscalNumber();
            this.customerName = detail.getCustomerName();
            this.settlementDocumentNumber = detail.getSettlementDocumentNumber();
            this.comments = detail.getComments();
            if (",".equals(decimalSeparator)) {
                this.amountPayed = this.amountPayed.replace(".", ",");
            }
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.sibsTransactionDetail, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.versioningCreator));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.whenProcessed));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.whenRegistered));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.amountPayed));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.sibsEntityReferenceCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.sibsPaymentReferenceCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.sibsTransactionId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.debtAccountId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.customerId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.businessIdentification));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.fiscalNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.customerName));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementDocumentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.comments));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.sibsTransactionDetail, e);
        }
    }
}

