/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import java.math.BigDecimal;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AbstractReportEntryBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.joda.time.DateTime;

public class PaymentReferenceCodeEntryBean
extends AbstractReportEntryBean {
    private static final String TARGET_TYPE_FINANTIAL_DOCUMENT = "F";
    private static final String TARGET_TYPE_MULTIPLE_ENTRIES = "M";
    private static final String TARGET_TYPE_NOT_DEFINED = "N";
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.name", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.identificationType", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.identificationNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.vatNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.email", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.address", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.addressCountryCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.studentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.entityCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.referenceCode", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.finantialDocumentNumber", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.payableAmount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.description", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.target.type", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.state", new String[0])};
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private String customerId;
    private String debtAccountId;
    private String name;
    private String identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String email;
    private String address;
    private String addressCountryCode;
    private Integer studentNumber;
    private String entityCode;
    private String referenceCode;
    private String finantialDocumentNumber;
    private BigDecimal payableAmount;
    private String description;
    private String targetType;
    private String state;
    private PaymentReferenceCode paymentReferenceCode;
    boolean completed = false;
    private String decimalSeparator;

    public PaymentReferenceCodeEntryBean(PaymentReferenceCode paymentReferenceCode, DebtReportRequest request, ErrorsLog errorsLog) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        this.decimalSeparator = request != null ? request.getDecimalSeparator() : ".";
        Currency currency = paymentReferenceCode.getPaymentCodePool().getFinantialInstitution().getCurrency();
        try {
            this.paymentReferenceCode = paymentReferenceCode;
            this.identification = paymentReferenceCode.getExternalId();
            this.versioningCreator = treasuryServices.versioningCreatorUsername((Object)paymentReferenceCode);
            this.creationDate = treasuryServices.versioningCreationDate((Object)paymentReferenceCode);
            if (paymentReferenceCode.getTargetPayment() != null) {
                DebtAccount referenceDebtAccount = paymentReferenceCode.getTargetPayment().getDebtAccount();
                this.customerId = referenceDebtAccount.getCustomer().getExternalId();
                this.debtAccountId = referenceDebtAccount.getExternalId();
                this.name = referenceDebtAccount.getCustomer().getName();
                if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson() != null && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getIdDocumentType() != null) {
                    this.identificationType = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getIdDocumentType().getLocalizedName();
                } else if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getIdDocumentType() != null) {
                    this.identificationType = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getIdDocumentType().getLocalizedName();
                }
                this.identificationNumber = referenceDebtAccount.getCustomer().getIdentificationNumber();
                this.vatNumber = referenceDebtAccount.getCustomer().getUiFiscalNumber();
                if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson() != null) {
                    this.email = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getInstitutionalOrDefaultEmailAddressValue();
                } else if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null) {
                    this.email = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getInstitutionalOrDefaultEmailAddressValue();
                }
                this.address = referenceDebtAccount.getCustomer().getAddress();
                this.addressCountryCode = referenceDebtAccount.getCustomer().getAddressCountryCode();
                if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson() != null && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getStudent() != null) {
                    this.studentNumber = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getStudent().getNumber();
                } else if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getStudent() != null) {
                    this.studentNumber = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getStudent().getNumber();
                }
            }
            this.entityCode = paymentReferenceCode.getPaymentCodePool().getEntityReferenceCode();
            this.referenceCode = paymentReferenceCode.getReferenceCode();
            if (paymentReferenceCode.getTargetPayment() != null && paymentReferenceCode.getTargetPayment().isFinantialDocumentPaymentCode()) {
                this.finantialDocumentNumber = ((FinantialDocumentPaymentCode)paymentReferenceCode.getTargetPayment()).getFinantialDocument().getUiDocumentNumber();
            } else if (paymentReferenceCode.getTargetPayment() != null && paymentReferenceCode.getTargetPayment().isMultipleEntriesPaymentCode()) {
                MultipleEntriesPaymentCode multipleEntriesPaymentCode = (MultipleEntriesPaymentCode)paymentReferenceCode.getTargetPayment();
                this.finantialDocumentNumber = String.join((CharSequence)", ", multipleEntriesPaymentCode.getInvoiceEntriesSet().stream().filter(i -> i.getFinantialDocument() != null).map(i -> i.getFinantialDocument().getUiDocumentNumber()).collect(Collectors.toList()));
            }
            if (paymentReferenceCode.getPayableAmount() != null) {
                this.payableAmount = currency.getValueWithScale(paymentReferenceCode.getPayableAmount());
            }
            if (paymentReferenceCode.getTargetPayment() != null) {
                this.description = paymentReferenceCode.getTargetPayment().getDescription();
            }
            if (paymentReferenceCode.getTargetPayment() != null && paymentReferenceCode.getTargetPayment().isFinantialDocumentPaymentCode()) {
                this.targetType = TARGET_TYPE_FINANTIAL_DOCUMENT;
            } else if (paymentReferenceCode.getTargetPayment() != null && paymentReferenceCode.getTargetPayment().isMultipleEntriesPaymentCode()) {
                this.targetType = TARGET_TYPE_MULTIPLE_ENTRIES;
            } else if (paymentReferenceCode.getTargetPayment() == null) {
                this.targetType = TARGET_TYPE_NOT_DEFINED;
            }
            if (paymentReferenceCode.getState() != null) {
                this.state = paymentReferenceCode.getState().getDescriptionI18N().getContent();
            }
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(paymentReferenceCode, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            String value;
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.versioningCreator);
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.customerId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.debtAccountId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.name));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.email));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.addressCountryCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.entityCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.referenceCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.finantialDocumentNumber));
            String string = value = this.payableAmount != null ? this.payableAmount.toString() : "";
            if (",".equals(this.decimalSeparator)) {
                value = value.replace(".", ",");
            }
            row.createCell(i++).setCellValue(this.valueOrEmpty(value));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.description));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.targetType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.state));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.paymentReferenceCode, e);
        }
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public String getVersioningCreator() {
        return this.versioningCreator;
    }

    public void setVersioningCreator(String versioningCreator) {
        this.versioningCreator = versioningCreator;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(DateTime creationDate) {
        this.creationDate = creationDate;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getDebtAccountId() {
        return this.debtAccountId;
    }

    public void setDebtAccountId(String debtAccountId) {
        this.debtAccountId = debtAccountId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdentificationType() {
        return this.identificationType;
    }

    public void setIdentificationType(String identificationType) {
        this.identificationType = identificationType;
    }

    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddressCountryCode() {
        return this.addressCountryCode;
    }

    public void setAddressCountryCode(String addressCountryCode) {
        this.addressCountryCode = addressCountryCode;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public String getReferenceCode() {
        return this.referenceCode;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public String getFinantialDocumentNumber() {
        return this.finantialDocumentNumber;
    }

    public void setFinantialDocumentNumber(String finantialDocumentNumber) {
        this.finantialDocumentNumber = finantialDocumentNumber;
    }

    public BigDecimal getPayableAmount() {
        return this.payableAmount;
    }

    public void setPayableAmount(BigDecimal payableAmount) {
        this.payableAmount = payableAmount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public PaymentReferenceCode getPaymentReferenceCode() {
        return this.paymentReferenceCode;
    }

    public void setPaymentReferenceCode(PaymentReferenceCode paymentReferenceCode) {
        this.paymentReferenceCode = paymentReferenceCode;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }
}

