/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.debtGeneration;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleType;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicTaxDueDateAlignmentType;
import org.fenixedu.academictreasury.domain.debtGeneration.DebtGenerationRuleRestriction;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool_Base;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;

public class AcademicDebtGenerationRuleBean
implements Serializable,
ITreasuryBean {
    private static final long serialVersionUID = 1L;
    private AcademicDebtGenerationRuleType type;
    private ExecutionYear executionYear;
    private boolean aggregateOnDebitNote;
    private boolean aggregateAllOrNothing;
    private boolean eventDebitEntriesMustEqualRuleProducts;
    private AcademicTaxDueDateAlignmentType academicTaxDueDateAlignmentType;
    private DebtGenerationRuleRestriction debtGenerationRuleRestriction;
    private List<ProductEntry> entries = Lists.newArrayList();
    private DegreeType degreeType;
    private List<DegreeCurricularPlan> degreeCurricularPlans = Lists.newArrayList();
    private List<DegreeCurricularPlan> degreeCurricularPlansToAdd = Lists.newArrayList();
    private Product product;
    private boolean createDebt;
    private boolean toCreateAfterLastRegistrationStateDate;
    private boolean forceCreation;
    private boolean limitToRegisteredOnExecutionYear;
    private PaymentCodePool paymentCodePool;
    private int numberOfDaysToDueDate = 0;
    private List<TreasuryTupleDataSourceBean> executionYearDataSource = Lists.newArrayList();
    private List<TreasuryTupleDataSourceBean> productDataSource = Lists.newArrayList();
    private List<TreasuryTupleDataSourceBean> paymentCodePoolDataSource = Lists.newArrayList();
    private List<TreasuryTupleDataSourceBean> degreeTypeDataSource = Lists.newArrayList();
    private List<TreasuryTupleDataSourceBean> degreeCurricularPlanDataSource = Lists.newArrayList();
    private List<TreasuryTupleDataSourceBean> academicTaxDueDateAlignmentTypeDataSource = Lists.newArrayList();
    private List<TreasuryTupleDataSourceBean> debtGenerationRuleRestrictionDataSource = Lists.newArrayList();
    private boolean toAggregateDebitEntries;
    private boolean toCloseDebitNote;
    private boolean toCreatePaymentReferenceCodes;
    private boolean toCreateDebitEntries;
    private boolean toAlignAcademicTaxesDueDate;
    private boolean appliedMinimumAmountForPaymentCode;
    private BigDecimal minimumAmountForPaymentCode;

    public AcademicDebtGenerationRuleBean(AcademicDebtGenerationRuleType type, ExecutionYear executionYear) {
        this.type = type;
        this.executionYear = executionYear;
        this.executionYearDataSource = ExecutionYear.readNotClosedExecutionYears().stream().sorted(Collections.reverseOrder(ExecutionYear.COMPARATOR_BY_BEGIN_DATE)).map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getQualifiedName())).collect(Collectors.toList());
        ArrayList availableProducts = Lists.newArrayList();
        IAcademicDebtGenerationRuleStrategy strategyImplementation = this.getType().strategyImplementation();
        if (strategyImplementation.isAppliedOnAcademicTaxDebitEntries()) {
            availableProducts.addAll(AcademicTax.findAll().filter(AcademicTax::isAppliedAutomatically).map(l -> l.getProduct()).collect(Collectors.toList()));
        }
        if (strategyImplementation.isAppliedOnTuitionDebitEntries()) {
            availableProducts.addAll(AcademicTreasurySettings.getInstance().getTuitionProductGroup().getProductsSet());
        }
        if (strategyImplementation.isAppliedOnOtherDebitEntries()) {
            availableProducts.add(TreasurySettings.getInstance().getInterestProduct());
        }
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        this.productDataSource = availableProducts.stream().sorted(Product.COMPARE_BY_NAME).map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), String.format("%s [%s]", l.getName().getContent(), l.getCode()))).collect(Collectors.toList());
        this.paymentCodePoolDataSource = PaymentCodePool.findAll().filter(PaymentCodePool_Base::getActive).map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getName())).collect(Collectors.toList());
        this.degreeTypeDataSource = DegreeType.all().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), academicTreasuryServices.localizedNameOfDegreeType((DegreeType)l))).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        this.academicTaxDueDateAlignmentTypeDataSource = Lists.newArrayList((Object[])AcademicTaxDueDateAlignmentType.values()).stream().map(l -> new TreasuryTupleDataSourceBean(l.name(), l.getDescriptionI18N().getContent())).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        this.academicTaxDueDateAlignmentTypeDataSource.add(0, AcademicTreasuryConstants.SELECT_OPTION);
        this.aggregateOnDebitNote = true;
        this.aggregateAllOrNothing = true;
        this.eventDebitEntriesMustEqualRuleProducts = false;
        this.toAggregateDebitEntries = type.strategyImplementation().isToAggregateDebitEntries();
        this.toCloseDebitNote = type.strategyImplementation().isToCloseDebitNote();
        this.toCreatePaymentReferenceCodes = type.strategyImplementation().isToCreatePaymentReferenceCodes();
        this.toCreateDebitEntries = type.strategyImplementation().isToCreateDebitEntries();
        this.toAlignAcademicTaxesDueDate = type.strategyImplementation().isToAlignAcademicTaxesDueDate();
        this.debtGenerationRuleRestrictionDataSource = DebtGenerationRuleRestriction.findAll().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getName())).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        this.debtGenerationRuleRestrictionDataSource.add(0, AcademicTreasuryConstants.SELECT_OPTION);
        this.appliedMinimumAmountForPaymentCode = false;
        this.minimumAmountForPaymentCode = null;
    }

    public AcademicDebtGenerationRuleBean(AcademicDebtGenerationRule rule) {
        this.type = rule.getAcademicDebtGenerationRuleType();
        this.executionYear = rule.getExecutionYear();
        this.executionYearDataSource = ExecutionYear.readNotClosedExecutionYears().stream().sorted(Collections.reverseOrder(ExecutionYear.COMPARATOR_BY_BEGIN_DATE)).map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getQualifiedName())).collect(Collectors.toList());
        this.degreeTypeDataSource = DegreeType.all().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getName().getContent())).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        this.aggregateOnDebitNote = rule.isAggregateOnDebitNote();
        this.aggregateAllOrNothing = rule.isAggregateAllOrNothing();
        this.eventDebitEntriesMustEqualRuleProducts = rule.isEventDebitEntriesMustEqualRuleProducts();
        this.degreeCurricularPlans.addAll(rule.getDegreeCurricularPlansSet());
        Collections.sort(this.degreeCurricularPlans, DegreeCurricularPlan.DEGREE_CURRICULAR_PLAN_COMPARATOR_BY_DEGREE_TYPE_AND_EXECUTION_DEGREE_AND_DEGREE_CODE);
        this.appliedMinimumAmountForPaymentCode = rule.isAppliedMinimumAmountForPaymentCode();
        this.minimumAmountForPaymentCode = rule.getMinimumAmountForPaymentCode();
    }

    public void chooseDegreeType() {
        if (this.getExecutionYear() == null) {
            this.degreeCurricularPlanDataSource = Collections.emptyList();
            return;
        }
        if (this.getDegreeType() == null) {
            this.degreeCurricularPlanDataSource = Collections.emptyList();
            return;
        }
        List result = ExecutionDegree.getAllByExecutionYearAndDegreeType((ExecutionYear)this.getExecutionYear(), (DegreeType[])new DegreeType[]{this.getDegreeType()}).stream().map(e -> e.getDegreeCurricularPlan()).map(dcp -> new TreasuryTupleDataSourceBean(dcp.getExternalId(), "[" + dcp.getDegree().getCode() + "] " + dcp.getPresentationName(this.getExecutionYear()))).collect(Collectors.toList());
        this.degreeCurricularPlanDataSource = result.stream().sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
    }

    public void addEntry() {
        if (this.product == null) {
            return;
        }
        if (this.entries.stream().filter(l -> l.getProduct() == this.product).count() > 0L) {
            return;
        }
        this.entries.add(new ProductEntry(this.product, this.isToCreateDebitEntries() && this.createDebt, this.isToCreateDebitEntries() && this.toCreateAfterLastRegistrationStateDate, this.isToCreateDebitEntries() && this.forceCreation, this.isToCreateDebitEntries() && this.limitToRegisteredOnExecutionYear));
        this.product = null;
        this.createDebt = false;
        this.forceCreation = false;
        this.limitToRegisteredOnExecutionYear = false;
    }

    public void removEntry(int index) {
        this.entries.remove(index);
    }

    public void addDegreeCurricularPlans() {
        this.degreeCurricularPlans.addAll(this.degreeCurricularPlansToAdd);
        this.degreeCurricularPlansToAdd = Lists.newArrayList();
    }

    public void removeDegreeCurricularPlan(int entryIndex) {
        this.degreeCurricularPlans.remove(entryIndex);
    }

    public AcademicDebtGenerationRuleType getType() {
        return this.type;
    }

    public void setType(AcademicDebtGenerationRuleType type) {
        this.type = type;
    }

    public boolean isToAggregateDebitEntries() {
        return this.toAggregateDebitEntries;
    }

    public boolean isToCloseDebitNote() {
        return this.toCloseDebitNote;
    }

    public boolean isToCreatePaymentReferenceCodes() {
        return this.toCreatePaymentReferenceCodes;
    }

    public boolean isToCreateDebitEntries() {
        return this.toCreateDebitEntries;
    }

    public boolean isToAlignAcademicTaxesDueDate() {
        return this.toAlignAcademicTaxesDueDate;
    }

    public boolean isAggregateOnDebitNote() {
        return this.isToAggregateDebitEntries() && this.aggregateOnDebitNote;
    }

    public void setAggregateOnDebitNote(boolean aggregateOnDebitNote) {
        this.aggregateOnDebitNote = aggregateOnDebitNote;
    }

    public AcademicTaxDueDateAlignmentType getAcademicTaxDueDateAlignmentType() {
        return this.academicTaxDueDateAlignmentType;
    }

    public void setAcademicTaxDueDateAlignmentType(AcademicTaxDueDateAlignmentType academicTaxDueDateAlignmentType) {
        this.academicTaxDueDateAlignmentType = academicTaxDueDateAlignmentType;
    }

    public List<ProductEntry> getEntries() {
        return this.entries;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public boolean isCreateDebt() {
        return this.isToCreateDebitEntries() && this.createDebt;
    }

    public void setCreateDebt(boolean createDebt) {
        this.createDebt = createDebt;
    }

    public boolean isToCreateAfterLastRegistrationStateDate() {
        return this.isToCreateDebitEntries() && this.toCreateAfterLastRegistrationStateDate;
    }

    public void setToCreateAfterLastRegistrationStateDate(boolean toCreateAfterLastRegistrationStateDate) {
        this.toCreateAfterLastRegistrationStateDate = toCreateAfterLastRegistrationStateDate;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public DegreeType getDegreeType() {
        return this.degreeType;
    }

    public void setDegreeType(DegreeType degreeType) {
        this.degreeType = degreeType;
    }

    public boolean isAggregateAllOrNothing() {
        return this.isToAggregateDebitEntries() && this.aggregateAllOrNothing;
    }

    public void setAggregateAllOrNothing(boolean aggregateAllOrNothing) {
        this.aggregateAllOrNothing = aggregateAllOrNothing;
    }

    public boolean isEventDebitEntriesMustEqualRuleProducts() {
        return this.eventDebitEntriesMustEqualRuleProducts;
    }

    public void setEventDebitEntriesMustEqualRuleProducts(boolean eventDebitEntriesMustEqualRuleProducts) {
        this.eventDebitEntriesMustEqualRuleProducts = eventDebitEntriesMustEqualRuleProducts;
    }

    public PaymentCodePool getPaymentCodePool() {
        return this.paymentCodePool;
    }

    public void setPaymentCodePool(PaymentCodePool paymentCodePool) {
        this.paymentCodePool = paymentCodePool;
    }

    public List<DegreeCurricularPlan> getDegreeCurricularPlans() {
        return this.degreeCurricularPlans;
    }

    public List<TreasuryTupleDataSourceBean> getExecutionYearDataSource() {
        return this.executionYearDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getProductDataSource() {
        return this.productDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getPaymentCodePoolDataSource() {
        return this.paymentCodePoolDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getDegreeTypeDataSource() {
        return this.degreeTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getDegreeCurricularPlanDataSource() {
        return this.degreeCurricularPlanDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getAcademicTaxDueDateAlignmentTypeDataSource() {
        return this.academicTaxDueDateAlignmentTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getDebtGenerationRuleRestrictionDataSource() {
        return this.debtGenerationRuleRestrictionDataSource;
    }

    public void setDebtGenerationRuleRestrictionDataSource(List<TreasuryTupleDataSourceBean> debtGenerationRuleRestrictionDataSource) {
        this.debtGenerationRuleRestrictionDataSource = debtGenerationRuleRestrictionDataSource;
    }

    public boolean isForceCreation() {
        return this.isToCreateDebitEntries() && this.forceCreation;
    }

    public void setForceCreation(boolean forceCreation) {
        this.forceCreation = forceCreation;
    }

    public boolean isLimitToRegisteredOnExecutionYear() {
        return this.isToCreateDebitEntries() && this.limitToRegisteredOnExecutionYear;
    }

    public void setLimitToRegisteredOnExecutionYear(boolean limitToRegisteredOnExecutionYear) {
        this.limitToRegisteredOnExecutionYear = limitToRegisteredOnExecutionYear;
    }

    public int getNumberOfDaysToDueDate() {
        return this.numberOfDaysToDueDate;
    }

    public void setNumberOfDaysToDueDate(int numberOfDaysToDueDate) {
        this.numberOfDaysToDueDate = numberOfDaysToDueDate;
    }

    public DebtGenerationRuleRestriction getDebtGenerationRuleRestriction() {
        return this.debtGenerationRuleRestriction;
    }

    public void setDebtGenerationRuleRestriction(DebtGenerationRuleRestriction debtGenerationRuleRestriction) {
        this.debtGenerationRuleRestriction = debtGenerationRuleRestriction;
    }

    public boolean isAppliedMinimumAmountForPaymentCode() {
        return this.appliedMinimumAmountForPaymentCode;
    }

    public void setAppliedMinimumAmountForPaymentCode(boolean appliedMinimumAmountForPaymentCode) {
        this.appliedMinimumAmountForPaymentCode = appliedMinimumAmountForPaymentCode;
    }

    public BigDecimal getMinimumAmountForPaymentCode() {
        return this.minimumAmountForPaymentCode;
    }

    public void setMinimumAmountForPaymentCode(BigDecimal minimumAmountForPaymentCode) {
        this.minimumAmountForPaymentCode = minimumAmountForPaymentCode;
    }

    public static class ProductEntry
    implements ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Product product;
        private boolean createDebt;
        private boolean toCreateAfterLastRegistrationStateDate;
        private boolean forceCreation;
        private boolean limitToRegisteredOnExecutionYear;

        public ProductEntry(Product product, boolean createDebt, boolean toCreateAfterLastRegistrationStateDate, boolean forceCreation, boolean limitToRegisteredOnExecutionYear) {
            this.product = product;
            this.createDebt = createDebt;
            this.toCreateAfterLastRegistrationStateDate = toCreateAfterLastRegistrationStateDate;
            this.forceCreation = forceCreation;
            this.limitToRegisteredOnExecutionYear = limitToRegisteredOnExecutionYear;
        }

        public Product getProduct() {
            return this.product;
        }

        public boolean isCreateDebt() {
            return this.createDebt;
        }

        public boolean isToCreateAfterLastRegistrationStateDate() {
            return this.toCreateAfterLastRegistrationStateDate;
        }

        public boolean isForceCreation() {
            return this.forceCreation;
        }

        public boolean isLimitToRegisteredOnExecutionYear() {
            return this.limitToRegisteredOnExecutionYear;
        }
    }
}

