/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.tariff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff$callable$create;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff$callable$delete;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff$callable$edit;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff_Base;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicTariff
extends AcademicTariff_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected AcademicTariff(FinantialEntity finantialEntity, Product product, AcademicTariffBean bean) {
        this.init(finantialEntity, product, bean);
    }

    protected void init(FinantialEntity finantialEntity, Product product, DateTime beginDate, DateTime endDate, DueDateCalculationType dueDateCalculationType, LocalDate fixedDueDate, int numberOfDaysAfterCreationForDueDate, boolean applyInterests, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, int maximumMonthsToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        throw new RuntimeException("wrong call");
    }

    protected void init(FinantialEntity finantialEntity, Product product, AcademicTariffBean bean) {
        super.init(finantialEntity, product, bean.getBeginDate().toDateTimeAtStartOfDay(), bean.getEndDate() != null ? bean.getEndDate().toDateTimeAtStartOfDay() : null, bean.getDueDateCalculationType(), bean.getFixedDueDate() != null ? bean.getFixedDueDate() : null, bean.getNumberOfDaysAfterCreationForDueDate(), bean.isApplyInterests(), bean.getInterestType(), bean.getNumberOfDaysAfterDueDate(), bean.isApplyInFirstWorkday(), bean.getMaximumDaysToApplyPenalty(), bean.getMaximumMonthsToApplyPenalty(), bean.getInterestFixedAmount(), bean.getRate());
        this.setBaseAmount(bean.getBaseAmount());
        this.setUnitsForBase(bean.getUnitsForBase());
        this.setUnitAmount(bean.getUnitAmount());
        this.setPageAmount(bean.getPageAmount());
        this.setMaximumAmount(bean.getMaximumAmount());
        this.setUrgencyRate(bean.getUrgencyRate());
        this.setLanguageTranslationRate(bean.getLanguageTranslationRate());
        this.setAdministrativeOffice(bean.getAdministrativeOffice());
        this.setDegreeType(bean.getDegreeType());
        this.setDegree(bean.getDegree());
        this.setCycleType(bean.getCycleType());
        this.checkRules();
    }

    public boolean isApplyUnitsAmount() {
        return this.isPositive(this.getUnitAmount());
    }

    public boolean isApplyPagesAmount() {
        return this.isPositive(this.getPageAmount());
    }

    public boolean isApplyMaximumAmount() {
        return this.isPositive(this.getMaximumAmount());
    }

    public boolean isApplyUrgencyRate() {
        return this.isPositive(this.getUrgencyRate());
    }

    public boolean isApplyLanguageTranslationRate() {
        return this.isPositive(this.getLanguageTranslationRate());
    }

    public boolean isApplyBaseAmount() {
        return this.isPositive(this.getBaseAmount());
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getCycleType() != null && this.getDegree() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.degree.required", new String[0]);
        }
        if (this.getDegree() != null && this.getDegreeType() != this.getDegree().getDegreeType()) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.degreeType.required", new String[0]);
        }
        if (this.getCycleType() != null && !this.getDegreeType().getCycleTypes().contains(this.getCycleType())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.cycleType.does.not.belong.degree.type", new String[0]);
        }
        if (this.getBaseAmount() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.baseAmount.required", new String[0]);
        }
        if (this.isNegative(this.getBaseAmount())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.baseAmount.negative", new String[0]);
        }
        if (this.getUnitsForBase() < 0) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.unitsForBase.negative", new String[0]);
        }
        if (this.getUnitAmount() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.unitAmount.required", new String[0]);
        }
        if (this.isNegative(this.getUnitAmount())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.unitAmount.negative", new String[0]);
        }
        if (this.getPageAmount() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.pageAmount.required", new String[0]);
        }
        if (this.isNegative(this.getPageAmount())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.pageAmount.negative", new String[0]);
        }
        if (this.getUrgencyRate() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.urgencyRate.required", new String[0]);
        }
        if (this.isNegative(this.getUrgencyRate())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.urgencyRate.negative", new String[0]);
        }
        if (AcademicTreasuryConstants.HUNDRED_PERCENT.compareTo(this.getUrgencyRate()) < 0) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.urgencyRate.greater.than.hundred", new String[0]);
        }
        if (this.getLanguageTranslationRate() == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.languageTranslationRate.required", new String[0]);
        }
        if (this.isNegative(this.getLanguageTranslationRate())) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.languageTranslationRate.negative", new String[0]);
        }
        if (AcademicTreasuryConstants.HUNDRED_PERCENT.compareTo(this.getLanguageTranslationRate()) < 0) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.languageTranslationRate.greater.than.hundred", new String[0]);
        }
        if (this.getCycleType() != null ? AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getAdministrativeOffice(), this.getDegreeType(), this.getDegree(), this.getCycleType(), this.getInterval()).count() > 1L : (this.getDegree() != null ? AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getAdministrativeOffice(), this.getDegreeType(), this.getDegree(), this.getInterval()).filter(t -> t.getCycleType() == null).count() > 1L : (this.getDegreeType() != null ? AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getAdministrativeOffice(), this.getDegreeType(), this.getInterval()).filter(t -> t.getDegree() == null).count() > 1L : (this.getAdministrativeOffice() != null ? AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getAdministrativeOffice(), this.getInterval()).filter(t -> t.getDegreeType() == null).count() > 1L : AcademicTariff.findInInterval(this.getFinantialEntity(), this.getProduct(), this.getInterval()).filter(t -> t.getAdministrativeOffice() == null).count() > 1L)))) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.overlaps.with.other", this.getProduct().getName().getContent());
        }
    }

    public void edit(AcademicTariffBean academicTariffBean) {
        Object object = advice$edit.perform((Callable)new AcademicTariff$callable$edit(this, academicTariffBean));
    }

    static /* synthetic */ void advised$edit(AcademicTariff this_, AcademicTariffBean bean) {
        super.edit(bean.getBeginDate().toDateTimeAtStartOfDay(), bean.getEndDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1));
        if (bean.isApplyInterests() && this_.getInterestRate() == null) {
            InterestRate.createForTariff((Tariff)this_, (InterestType)bean.getInterestType(), (int)bean.getNumberOfDaysAfterDueDate(), (boolean)bean.isApplyInFirstWorkday(), (int)bean.getMaximumDaysToApplyPenalty(), (int)bean.getMaximumMonthsToApplyPenalty(), (BigDecimal)bean.getInterestFixedAmount(), (BigDecimal)bean.getRate());
        } else if (bean.isApplyInterests()) {
            this_.getInterestRate().edit(bean.getInterestType(), bean.getNumberOfDaysAfterDueDate(), bean.isApplyInFirstWorkday(), bean.getMaximumDaysToApplyPenalty(), bean.getMaximumMonthsToApplyPenalty(), bean.getInterestFixedAmount(), bean.getRate());
        }
        super.setApplyInterests(bean.isApplyInterests());
        this_.checkRules();
    }

    public boolean isDeletable() {
        return super.isDeletable();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AcademicTariff$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AcademicTariff this_) {
        this_.setAdministrativeOffice(null);
        this_.setDegreeType(null);
        this_.setDegree(null);
        super.delete();
    }

    public BigDecimal amountToPay(AcademicTreasuryEvent academicTreasuryEvent) {
        int numberOfUnits = academicTreasuryEvent.getNumberOfUnits();
        int numberOfPages = academicTreasuryEvent.getNumberOfPages();
        Locale language = academicTreasuryEvent.getLanguage();
        boolean urgentRequest = academicTreasuryEvent.isUrgentRequest();
        return this.amountToPay(numberOfUnits, numberOfPages, language, urgentRequest);
    }

    public BigDecimal amountToPay(int numberOfUnits, int numberOfPages, Locale language, boolean urgentRequest) {
        BigDecimal amount = this.amountWithLanguageRate(numberOfUnits, numberOfPages, language);
        if (this.isApplyUrgencyRate() && urgentRequest) {
            amount = amount.add(this.amountForUrgencyRate(numberOfUnits, numberOfPages, language));
        }
        return amount;
    }

    public BigDecimal amountForUrgencyRate(int numberOfUnits, int numberOfPages, Locale language) {
        BigDecimal amount = this.amountWithLanguageRate(numberOfUnits, numberOfPages, language);
        return amount.multiply(this.getUrgencyRate().setScale(20, RoundingMode.HALF_EVEN).divide(AcademicTreasuryConstants.HUNDRED_PERCENT).setScale(2, RoundingMode.HALF_EVEN));
    }

    public BigDecimal amountForLanguageTranslationRate(int numberOfUnits, int numberOfPages) {
        BigDecimal amount = this.amountToPayWithoutRates(numberOfUnits, numberOfPages);
        BigDecimal result = amount.multiply(this.getLanguageTranslationRate().setScale(20, RoundingMode.HALF_EVEN).divide(AcademicTreasuryConstants.HUNDRED_PERCENT).setScale(2, RoundingMode.HALF_EVEN));
        return this.isPositive(result) ? result : BigDecimal.ZERO;
    }

    public BigDecimal amountToPay(int numberOfUnits, int numberOfPages) {
        BigDecimal amount = this.getBaseAmount();
        if (this.isApplyUnitsAmount()) {
            int remainingUnits;
            int n = remainingUnits = numberOfUnits - this.getUnitsForBase() >= 0 ? numberOfUnits - this.getUnitsForBase() : 0;
            if (remainingUnits > 0) {
                amount = amount.add(this.getUnitAmount().multiply(new BigDecimal(remainingUnits)));
            }
        }
        if (this.isApplyPagesAmount()) {
            amount = amount.add(this.getPageAmount().multiply(new BigDecimal(numberOfPages)));
        }
        if (this.isApplyMaximumAmount() && this.isGreaterThan(amount, this.getMaximumAmount())) {
            amount = this.getMaximumAmount();
        }
        return amount;
    }

    public BigDecimal amountToPayWithoutRates(int numberOfUnits, int numberOfPages) {
        int remainingUnits;
        BigDecimal amount = this.getBaseAmount();
        if (this.isApplyUnitsAmount() && (remainingUnits = this.numberOfAdditionalUnits(numberOfUnits)) > 0) {
            amount = amount.add(this.amountForAdditionalUnits(numberOfUnits));
        }
        if (this.isApplyPagesAmount()) {
            amount = amount.add(this.amountForPages(numberOfPages));
        }
        if (this.isApplyMaximumAmount() && this.isGreaterThan(amount, this.getMaximumAmount())) {
            amount = this.getMaximumAmount();
        }
        return amount;
    }

    public BigDecimal amountForPages(int numberOfPages) {
        BigDecimal result = this.getPageAmount().multiply(new BigDecimal(numberOfPages));
        return this.isPositive(result) ? result : BigDecimal.ZERO;
    }

    public BigDecimal amountForAdditionalUnits(int numberOfUnits) {
        int remainingUnits = this.numberOfAdditionalUnits(numberOfUnits);
        BigDecimal result = this.getUnitAmount().multiply(new BigDecimal(remainingUnits));
        return this.isPositive(result) ? result : BigDecimal.ZERO;
    }

    public int numberOfAdditionalUnits(int numberOfUnits) {
        int result = numberOfUnits - this.getUnitsForBase();
        return result >= 0 ? result : 0;
    }

    public BigDecimal amountToPay(AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation enrolmentEvaluation) {
        return this.getBaseAmount();
    }

    public Vat vat(LocalDate when) {
        return (Vat)Vat.findActiveUnique((VatType)this.getProduct().getVatType(), (FinantialInstitution)this.getFinantialEntity().getFinantialInstitution(), (DateTime)when.toDateTimeAtStartOfDay()).get();
    }

    public LocalizedString academicServiceRequestDebitEntryName(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return AcademicTreasuryEvent.nameForAcademicServiceRequest(this.getProduct(), iTreasuryServiceRequest);
    }

    public LocalizedString academicTaxDebitEntryName(AcademicTreasuryEvent academicTreasuryEvent) {
        if (!academicTreasuryEvent.isForAcademicTax()) {
            throw new RuntimeException("wrong call");
        }
        return academicTreasuryEvent.getDescription();
    }

    public static LocalizedString improvementDebitEntryName(AcademicTax improvementAcademicTax, EnrolmentEvaluation enrolmentEvaluation) {
        ITreasuryPlatformDependentServices treasuryServices = TreasuryPlataformDependentServicesFactory.implementation();
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        Registration registration = enrolmentEvaluation.getEnrolment().getRegistration();
        ExecutionYear executionYear = enrolmentEvaluation.getExecutionPeriod().getExecutionYear();
        LocalizedString result = new LocalizedString();
        for (Locale locale : treasuryServices.availableLocales()) {
            String enrolmentName = academicTreasuryServices.localizedNameOfEnrolment(enrolmentEvaluation.getEnrolment(), locale);
            String executionIntervalName = enrolmentEvaluation.getExecutionPeriod().getQualifiedName();
            String academicTreasuryEventDescription = AcademicTreasuryEvent.nameForAcademicTax(improvementAcademicTax, registration, executionYear).getContent(locale);
            result = result.with(locale, academicTreasuryEventDescription + String.format(" (%s - %s)", enrolmentName, executionIntervalName));
        }
        return result;
    }

    public DebitEntry createDebitEntryForAcademicServiceRequest(DebtAccount debtAccoubt, AcademicTreasuryEvent academicTreasuryEvent) {
        LocalDate when = academicTreasuryEvent.getRequestDate();
        return this.createDebitEntryForAcademicServiceRequest(debtAccoubt, academicTreasuryEvent, when);
    }

    public DebitEntry createDebitEntryForAcademicServiceRequest(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        if (!academicTreasuryEvent.isForAcademicServiceRequest()) {
            throw new RuntimeException("wrong call");
        }
        BigDecimal amount = this.amountToPay(academicTreasuryEvent);
        LocalDate dueDate = this.dueDate(when);
        LocalizedString debitEntryName = this.academicServiceRequestDebitEntryName(academicTreasuryEvent.getITreasuryServiceRequest());
        Vat vat = this.vat(when);
        this.updatePriceValuesInEvent(academicTreasuryEvent);
        Map<String, String> fillPriceProperties = this.fillPriceCommonPropertiesForAcademicServiceRequest(debtAccount, academicTreasuryEvent, when);
        return DebitEntry.create(Optional.empty(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay());
    }

    public DebitEntry createDebitEntryForAcademicTax(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent) {
        LocalDate when = academicTreasuryEvent.getRequestDate();
        return this.createDebitEntryForAcademicTax(debtAccount, academicTreasuryEvent, when);
    }

    public DebitEntry createDebitEntryForAcademicTax(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        if (!academicTreasuryEvent.isForAcademicTax() || academicTreasuryEvent.isImprovementTax()) {
            throw new RuntimeException("wrong call");
        }
        LocalDate dueDate = this.dueDate(when);
        LocalizedString debitEntryName = this.academicTaxDebitEntryName(academicTreasuryEvent);
        Vat vat = this.vat(when);
        BigDecimal amount = this.amountToPay(academicTreasuryEvent);
        this.updatePriceValuesInEvent(academicTreasuryEvent);
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForAcademicTax(debtAccount, academicTreasuryEvent, when);
        return DebitEntry.create(Optional.empty(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay());
    }

    public DebitEntry createDebitEntryForCustomAcademicDebt(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        if (!academicTreasuryEvent.isForCustomAcademicDebt()) {
            throw new RuntimeException("wrong call");
        }
        LocalDate dueDate = this.dueDate(when);
        LocalizedString debitEntryName = AcademicTreasuryEvent.nameForCustomAcademicDebt(academicTreasuryEvent.getProduct(), academicTreasuryEvent.getRegistration(), academicTreasuryEvent.getExecutionYear());
        Vat vat = this.vat(when);
        BigDecimal amount = this.amountToPay(academicTreasuryEvent);
        Map<String, String> fillPriceProperties = this.fillPricePropertiesForAcademicTax(debtAccount, academicTreasuryEvent, when);
        return DebitEntry.create(Optional.empty(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(), (BigDecimal)TreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay());
    }

    public DebitEntry createDebitEntryForImprovement(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation enrolmentEvaluation) {
        return this.createDebitEntryForImprovement(debtAccount, academicTreasuryEvent, enrolmentEvaluation, enrolmentEvaluation.getWhenDateTime().toLocalDate());
    }

    public DebitEntry createDebitEntryForImprovement(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation enrolmentEvaluation, LocalDate when) {
        if (!academicTreasuryEvent.isForImprovementTax()) {
            throw new RuntimeException("wrong call");
        }
        LocalizedString debitEntryName = AcademicTariff.improvementDebitEntryName(academicTreasuryEvent.getAcademicTax(), enrolmentEvaluation);
        LocalDate dueDate = this.dueDate(when);
        Vat vat = this.vat(when);
        BigDecimal amount = this.amountToPay(academicTreasuryEvent, enrolmentEvaluation);
        this.updatePriceValuesInEvent(academicTreasuryEvent, enrolmentEvaluation);
        Map<String, String> fillPriceProperties = this.fillPriceProperties(academicTreasuryEvent, enrolmentEvaluation);
        DebitEntry debitEntry = DebitEntry.create(Optional.empty(), (DebtAccount)debtAccount, (TreasuryEvent)academicTreasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, fillPriceProperties, (Product)this.getProduct(), (String)debitEntryName.getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)AcademicTreasuryConstants.DEFAULT_QUANTITY, (InterestRate)this.getInterestRate(), (DateTime)new DateTime());
        academicTreasuryEvent.associateEnrolmentEvaluation(debitEntry, enrolmentEvaluation);
        if (debitEntry != null) {
            DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)debtAccount.getFinantialInstitution()).get()), (DateTime)new DateTime());
            debitNote.addDebitNoteEntries((List)Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
            if (AcademicTreasurySettings.getInstance().isCloseServiceRequestEmolumentsWithDebitNote()) {
                debitNote.closeDocument();
            }
        }
        return debitEntry;
    }

    private void updatePriceValuesInEvent(AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation enrolmentEvaluation) {
        BigDecimal baseAmount = this.getBaseAmount();
        academicTreasuryEvent.updatePricingFields(baseAmount, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private void updatePriceValuesInEvent(AcademicTreasuryEvent academicTreasuryEvent) {
        BigDecimal baseAmount = this.getBaseAmount();
        BigDecimal amountForAdditionalUnits = this.amountForAdditionalUnits(academicTreasuryEvent.getNumberOfUnits());
        BigDecimal amountForPages = this.amountForPages(academicTreasuryEvent.getNumberOfPages());
        BigDecimal maximumAmount = this.getMaximumAmount();
        BigDecimal amountForLanguageTranslationRate = this.amountForLanguageTranslationRate(academicTreasuryEvent.getNumberOfUnits(), academicTreasuryEvent.getNumberOfPages());
        BigDecimal amountForUrgencyRate = this.amountForUrgencyRate(academicTreasuryEvent.getNumberOfUnits(), academicTreasuryEvent.getNumberOfPages(), academicTreasuryEvent.getLanguage());
        academicTreasuryEvent.updatePricingFields(baseAmount, amountForAdditionalUnits, amountForPages, maximumAmount, amountForLanguageTranslationRate, amountForUrgencyRate);
    }

    private Map<String, String> fillPriceCommonPropertiesForAcademicServiceRequest(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.putAll(this.fillPriceCommonProperties(debtAccount, academicTreasuryEvent, when));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), academicTreasuryEvent.getITreasuryServiceRequest().getRegistration().getDegree().getPresentationNameI18N(academicTreasuryEvent.getITreasuryServiceRequest().getExecutionYear()).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), academicTreasuryEvent.getITreasuryServiceRequest().getRegistration().getDegree().getCode());
        if (academicTreasuryEvent.getITreasuryServiceRequest().hasExecutionYear()) {
            propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent(), academicTreasuryEvent.getITreasuryServiceRequest().getExecutionYear().getQualifiedName());
        }
        return propertiesMap;
    }

    private Map<String, String> fillPricePropertiesForAcademicTax(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.putAll(this.fillPriceCommonProperties(debtAccount, academicTreasuryEvent, when));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent(), academicTreasuryEvent.getExecutionYear().getQualifiedName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), academicTreasuryEvent.getRegistration().getDegree().getPresentationNameI18N(academicTreasuryEvent.getExecutionYear()).getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), academicTreasuryEvent.getRegistration().getDegreeCurricularPlanName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent(), academicTreasuryEvent.getRegistration().getDegree().getCode());
        return propertiesMap;
    }

    private Map<String, String> fillPriceCommonProperties(DebtAccount debtAccount, AcademicTreasuryEvent academicTreasuryEvent, LocalDate when) {
        HashMap propertiesMap = Maps.newHashMap();
        Currency currency = debtAccount.getFinantialInstitution().getCurrency();
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.BASE_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.getBaseAmount()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.UNITS_FOR_BASE.getDescriptionI18N().getContent(), String.valueOf(this.getUnitsForBase()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.UNIT_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.getUnitAmount()).toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ADDITIONAL_UNITS.getDescriptionI18N().getContent(), String.valueOf(this.numberOfAdditionalUnits(academicTreasuryEvent.getNumberOfUnits())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_UNITS_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.amountForAdditionalUnits(academicTreasuryEvent.getNumberOfUnits())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.PAGE_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.getPageAmount()).toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.NUMBER_OF_PAGES.getDescriptionI18N().getContent(), String.valueOf(academicTreasuryEvent.getNumberOfPages()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_PAGES_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.amountForPages(academicTreasuryEvent.getNumberOfPages())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.MAXIMUM_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.getMaximumAmount()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FOREIGN_LANGUAGE_RATE.getDescriptionI18N().getContent(), this.getLanguageTranslationRate().toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_FOREIGN_LANGUAGE_RATE.getDescriptionI18N().getContent(), currency.getValueFor(this.amountForLanguageTranslationRate(academicTreasuryEvent.getNumberOfUnits(), academicTreasuryEvent.getNumberOfPages())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.URGENT_PERCENTAGE.getDescriptionI18N().getContent(), this.getUrgencyRate().toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.CALCULATED_URGENT_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.amountForUrgencyRate(academicTreasuryEvent.getNumberOfUnits(), academicTreasuryEvent.getNumberOfPages(), academicTreasuryEvent.getLanguage())));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), currency.getValueFor(this.amountToPay(academicTreasuryEvent)));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.USED_DATE.getDescriptionI18N().getContent(), when.toString("dd/MM/yyyy"));
        return propertiesMap;
    }

    private Map<String, String> fillPriceProperties(AcademicTreasuryEvent academicTreasuryEvent, EnrolmentEvaluation improvementEnrolmentEvaluation) {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        HashMap propertiesMap = Maps.newHashMap();
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.BASE_AMOUNT.getDescriptionI18N().getContent(), this.getBaseAmount().toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.FINAL_AMOUNT.getDescriptionI18N().getContent(), this.amountToPay(academicTreasuryEvent).toString());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.ENROLMENT.getDescriptionI18N().getContent(), academicTreasuryServices.localizedNameOfEnrolment(improvementEnrolmentEvaluation.getEnrolment()));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE_CURRICULAR_PLAN.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getDegreeCurricularPlan().getName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.DEGREE.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getDegreeCurricularPlan().getDegree().getPresentationNameI18N().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.EXECUTION_SEMESTER.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getExecutionPeriod().getQualifiedName());
        propertiesMap.put(AcademicTreasuryEvent.AcademicTreasuryEventKeys.EVALUATION_SEASON.getDescriptionI18N().getContent(), improvementEnrolmentEvaluation.getEvaluationSeason().getName().getContent(AcademicTreasuryConstants.DEFAULT_LANGUAGE));
        return propertiesMap;
    }

    private BigDecimal amountWithLanguageRate(int numberOfUnits, int numberOfPages, Locale language) {
        BigDecimal amount = this.amountToPayWithoutRates(numberOfUnits, numberOfPages);
        if (this.isApplyLanguageTranslationRate() && AcademicTreasuryConstants.isForeignLanguage(language)) {
            amount = amount.add(this.amountForLanguageTranslationRate(numberOfUnits, numberOfPages));
        }
        return amount;
    }

    public static AcademicTariff create(FinantialEntity finantialEntity, Product product, AcademicTariffBean academicTariffBean) {
        return (AcademicTariff)((Object)advice$create.perform((Callable)new AcademicTariff$callable$create(finantialEntity, product, academicTariffBean)));
    }

    static /* synthetic */ AcademicTariff advised$create(FinantialEntity finantialEntity, Product product, AcademicTariffBean bean) {
        return new AcademicTariff(finantialEntity, product, bean);
    }

    public static Stream<? extends AcademicTariff> findAll() {
        return Tariff.findAll().filter(t -> t instanceof AcademicTariff).map(AcademicTariff.class::cast);
    }

    public static Stream<? extends AcademicTariff> find(Product product) {
        return product.getTariffSet().stream().filter(t -> t instanceof AcademicTariff).map(AcademicTariff.class::cast);
    }

    public static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity) {
        return finantialEntity.getTariffSet().stream().filter(t -> t instanceof AcademicTariff).map(AcademicTariff.class::cast);
    }

    public static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product) {
        return AcademicTariff.find(product).filter(t -> t.getFinantialEntity() == finantialEntity);
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice) {
        return AcademicTariff.find(finantialEntity, product).filter(i -> administrativeOffice == i.getAdministrativeOffice());
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType) {
        if (degreeType == null) {
            throw new RuntimeException("degree type is null. wrong find call");
        }
        return AcademicTariff.find(finantialEntity, product, administrativeOffice).filter(i -> degreeType == i.getDegreeType());
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, Degree degree) {
        if (degree == null) {
            throw new RuntimeException("degree is null. wrong find call");
        }
        return AcademicTariff.find(finantialEntity, product, administrativeOffice, degreeType).filter(t -> t.getDegree() == degree);
    }

    private static Stream<? extends AcademicTariff> find(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, Degree degree, CycleType cycleType) {
        if (cycleType == null) {
            throw new RuntimeException("cycle is null. wrong find call");
        }
        return AcademicTariff.find(finantialEntity, product, administrativeOffice, degreeType, degree).filter(t -> t.getCycleType() == cycleType);
    }

    public static Stream<? extends AcademicTariff> findActive(DateTime when) {
        return AcademicTariff.findAll().filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, DateTime when) {
        return AcademicTariff.find(finantialEntity).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, DateTime when) {
        return AcademicTariff.find(finantialEntity, product).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, administrativeOffice).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, administrativeOffice, degreeType).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, Degree degree, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, administrativeOffice, degreeType, degree).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findActive(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, Degree degree, CycleType cycleType, DateTime when) {
        return AcademicTariff.find(finantialEntity, product, administrativeOffice, degreeType, degree, cycleType).filter(t -> t.isActive(when));
    }

    public static Stream<? extends AcademicTariff> findInInterval(Interval interval) {
        return AcademicTariff.findAll().filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Interval interval) {
        return AcademicTariff.find(finantialEntity).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, Interval interval) {
        return AcademicTariff.find(finantialEntity, product).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, Interval interval) {
        return AcademicTariff.find(finantialEntity, product, administrativeOffice).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, Interval interval) {
        return AcademicTariff.find(finantialEntity, product, administrativeOffice, degreeType).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, Degree degree, Interval interval) {
        return AcademicTariff.find(finantialEntity, product, administrativeOffice, degreeType, degree).filter(t -> t.isActive(interval));
    }

    public static Stream<? extends AcademicTariff> findInInterval(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, Degree degree, CycleType cycleType, Interval interval) {
        return AcademicTariff.find(finantialEntity, product, administrativeOffice, degreeType, degree, cycleType).filter(t -> t.isActive(interval));
    }

    protected static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, DateTime when) {
        if (product == null) {
            throw new RuntimeException("product is null. wrong findMatch call");
        }
        if (finantialEntity == null) {
            throw new RuntimeException("finantial entity is null. wrong findMatch call");
        }
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, when).filter(e -> e.getAdministrativeOffice() == null).filter(e -> e.getDegreeType() == null).filter(e -> e.getDegree() == null).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (!activeTariffs.isEmpty()) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return null;
    }

    public static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DateTime when) {
        if (administrativeOffice == null) {
            throw new RuntimeException("administrative office is null. wrong findMatch call");
        }
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, administrativeOffice, when).filter(e -> e.getDegreeType() == null).filter(e -> e.getDegree() == null).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return AcademicTariff.findMatch(finantialEntity, product, when);
    }

    protected static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, AdministrativeOffice administrativeOffice, DegreeType degreeType, DateTime when) {
        if (administrativeOffice == null) {
            throw new RuntimeException("administrative office is null. wrong findMatch call");
        }
        if (degreeType == null) {
            throw new RuntimeException("degreeType is null. wrong findMatch call");
        }
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, administrativeOffice, degreeType, when).filter(e -> e.getDegree() == null).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return AcademicTariff.findMatch(finantialEntity, product, administrativeOffice, when);
    }

    public static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, Degree degree, DateTime when) {
        DegreeType degreeType;
        if (degree == null) {
            throw new RuntimeException("degree is null. wrong findMatch call");
        }
        AdministrativeOffice administrativeOffice = degree.getAdministrativeOffice();
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, administrativeOffice, degreeType = degree.getDegreeType(), degree, when).filter(e -> e.getCycleType() == null).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return AcademicTariff.findMatch(finantialEntity, product, administrativeOffice, degreeType, when);
    }

    public static AcademicTariff findMatch(FinantialEntity finantialEntity, Product product, Degree degree, CycleType cycleType, DateTime when) {
        DegreeType degreeType;
        if (degree == null || cycleType == null) {
            throw new RuntimeException("degree or cycle type is null. wrong findMatch call");
        }
        AdministrativeOffice administrativeOffice = degree.getAdministrativeOffice();
        Set activeTariffs = AcademicTariff.findActive(finantialEntity, product, administrativeOffice, degreeType = degree.getDegreeType(), degree, cycleType, when).collect(Collectors.toSet());
        if (activeTariffs.size() > 1) {
            throw new AcademicTreasuryDomainException("error.AcademicTariff.findActive.more.than.one", new String[0]);
        }
        if (activeTariffs.size() == 1) {
            return (AcademicTariff)((Object)activeTariffs.iterator().next());
        }
        return AcademicTariff.findMatch(finantialEntity, product, degree, when);
    }
}

