/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.tuitiondebtcreation;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tuition.TuitionDebtCreationBean;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/academictreasury/tuitiondebtcreation/tuitiondebtcreationbean"})
public class TuitionDebtCreationBeanController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/tuitiondebtcreation/tuitiondebtcreationbean";
    private static final String JSP_PATH = "academicTreasury/tuitiondebtcreation/tuitiondebtcreationbean";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/tuitiondebtcreation/tuitiondebtcreationbean/create";
    private static final String _BACKTOCREATE_URI = "/backtocreate";
    public static final String BACKTOCREATE_URL = "/academictreasury/tuitiondebtcreation/tuitiondebtcreationbean/backtocreate";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/tuitiondebtcreation/tuitiondebtcreationbean/createpostback";
    private static final String _CONFIRMTUITIONDEBTCREATION_URI = "/confirmtuitiondebtcreation";
    public static final String CONFIRMTUITIONDEBTCREATION_URL = "/academictreasury/tuitiondebtcreation/tuitiondebtcreationbean/confirmtuitiondebtcreation";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/tuitiondebtcreation/tuitiondebtcreationbean/create/";
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        TuitionDebtCreationBean bean = new TuitionDebtCreationBean(debtAccount, TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get());
        return this._createFirstPage(debtAccount, bean, model);
    }

    @RequestMapping(value={"/backtocreate/{debtAccountId}"}, method={RequestMethod.POST})
    public String backTocreate(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) TuitionDebtCreationBean bean, Model model) {
        return this._createFirstPage(debtAccount, bean, model);
    }

    public String _createFirstPage(DebtAccount debtAccount, TuitionDebtCreationBean bean, Model model) {
        model.addAttribute("TuitionDebtCreationBean_executionYear_options", (Object)ExecutionYear.readNotClosedExecutionYears());
        model.addAttribute("TuitionDebtCreationBean_registration_options", (Object)((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent().getRegistrationsSet());
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("tuitionDebtCreationBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/createpostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) TuitionDebtCreationBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) TuitionDebtCreationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            model.addAttribute("debtAccount", (Object)debtAccount);
            model.addAttribute("bean", (Object)bean);
            model.addAttribute("tuitionDebtCreationBeanJson", (Object)this.getBeanJson(bean));
            model.addAttribute("tuitionPaymentPlan", (Object)TuitionServices.usedPaymentPlan(bean.getRegistration(), bean.getExecutionYear(), bean.getDebtDate(), bean.getTuitionPaymentPlan()));
            model.addAttribute("installments", TuitionServices.calculateInstallmentDebitEntryBeans(bean.getRegistration(), bean.getExecutionYear(), bean.getDebtDate(), bean.getTuitionPaymentPlan(), true));
            return this.jspPage("confirmtuitiondebtcreation");
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createFirstPage(debtAccount, bean, model);
        }
    }

    @RequestMapping(value={"/confirmtuitiondebtcreation/{debtAccountId}"}, method={RequestMethod.POST})
    public String confirmtuitiondebtcreation(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) TuitionDebtCreationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            TuitionServices.createTuitionForRegistration(bean.getRegistration(), bean.getExecutionYear(), bean.getDebtDate(), false, bean.getTuitionPaymentPlan(), true);
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionPaymentPlan.tuition.installments.debit.entries.created.success", new String[0]), model);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read//" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.create(debtAccount, bean, model, redirectAttributes);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/tuitiondebtcreation/tuitiondebtcreationbean/" + page;
    }
}

