/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managetuitionpaymentplangroup;

import java.util.stream.Collectors;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Product;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageTuitionPaymentPlanGroup", accessGroup="treasuryManagers")
@RequestMapping(value={"/academictreasury/managetuitionpaymentplangroup/tuitionpaymentplangroup"})
public class TuitionPaymentPlanGroupController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER = "/academictreasury/managetuitionpaymentplangroup/tuitionpaymentplangroup";
    public static final String JSP_PATH = "academicTreasury/managetuitionpaymentplangroup/tuitionpaymentplangroup";

    @RequestMapping
    public String home(Model model) {
        return String.format("forward:%s/", CONTROLLER);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("searchtuitionpaymentplangroupResultsDataSet", TuitionPaymentPlanGroup.findAll().collect(Collectors.toSet()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/search/view/{tuitionPaymentPlanGroupId}"})
    public String processSearchToViewAction(@PathVariable(value="tuitionPaymentPlanGroupId") TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(this.route("/read", tuitionPaymentPlanGroup.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/search/delete/{tuitionPaymentPlanGroupid}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="tuitionPaymentPlanGroupid") TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Model model, RedirectAttributes redirectAttributes) {
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup, model);
        try {
            tuitionPaymentPlanGroup.delete();
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionPaymentPlanGroup.delete.sucess", new String[0]), model);
            return this.redirect(this.route("/", new String[0]), model, redirectAttributes);
        }
        catch (AcademicTreasuryDomainException tde) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.error.delete", new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.error.delete", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.jspPage("search");
    }

    @RequestMapping(value={"/read/{tuitionPaymentPlanGroupId}"})
    public String read(@PathVariable(value="tuitionPaymentPlanGroupId") TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Model model) {
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup, model);
        return this.jspPage("read");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("products", (Object)AcademicTreasurySettings.getInstance().getTuitionProductGroup().getProductsSet());
        return this.jspPage("create");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="forRegistration", required=false) boolean forRegistration, @RequestParam(value="forStandalone", required=false) boolean forStandalone, @RequestParam(value="forExtracurricular", required=false) boolean forExtracurricular, @RequestParam(value="currentProduct", required=false) Product currentProduct, Model model, RedirectAttributes redirectAttributes) {
        try {
            TuitionPaymentPlanGroup group = TuitionPaymentPlanGroup.create(code, name, forRegistration, forStandalone, forExtracurricular, currentProduct);
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionPaymentPlanGroup.creation.success", new String[0]), model);
            return this.redirect(this.route("/read", group.getExternalId()), model, redirectAttributes);
        }
        catch (AcademicTreasuryDomainException tde) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.error.create", new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.error.create", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    @RequestMapping(value={"/update/{tuitionPaymentPlanGroupId}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="tuitionPaymentPlanGroupId") TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Model model) {
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup, model);
        model.addAttribute("products", (Object)AcademicTreasurySettings.getInstance().getTuitionProductGroup().getProductsSet());
        return this.jspPage("/update");
    }

    @RequestMapping(value={"/update/{tuitionPaymentPlanGroupId}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="tuitionPaymentPlanGroupId") TuitionPaymentPlanGroup tuitionPaymentPlanGroup, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="forRegistration", required=false) boolean forRegistration, @RequestParam(value="forStandalone", required=false) boolean forStandalone, @RequestParam(value="forExtracurricular", required=false) boolean forExtracurricular, @RequestParam(value="currentProduct", required=false) Product currentProduct, Model model, RedirectAttributes redirectAttributes) {
        this.setTuitionPaymentPlanGroup(tuitionPaymentPlanGroup, model);
        try {
            tuitionPaymentPlanGroup.edit(code, name, forRegistration, forStandalone, forExtracurricular, currentProduct);
            return this.redirect(this.route("/read", tuitionPaymentPlanGroup.getExternalId()), model, redirectAttributes);
        }
        catch (AcademicTreasuryDomainException tde) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.error.update", new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.error.update", new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(tuitionPaymentPlanGroup, model);
    }

    private String jspPage(String page) {
        return "academicTreasury/managetuitionpaymentplangroup/tuitionpaymentplangroup/" + page;
    }

    private String route(String action, String ... ids) {
        StringBuilder sb = new StringBuilder(CONTROLLER);
        sb.append(action).append("/");
        for (String id : ids) {
            sb.append(id).append("/");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    private void setTuitionPaymentPlanGroup(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, Model model) {
        model.addAttribute("tuitionPaymentPlanGroup", (Object)tuitionPaymentPlanGroup);
    }
}

