/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.manageproductsblockacademicalacts;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.Product;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.academictreasury.ManageProductsForBlockAcademicalActs", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/academicTreasury/manageproductsblockacademicalacts/"})
public class ManageProductsForBlockAcademicalActsController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academicTreasury/manageproductsblockacademicalacts/";
    public static final String JSP_PATH = "academicTreasury/manageproductsblockacademicalacts/";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academicTreasury/manageproductsblockacademicalacts//search";
    private static final String _ADD_PRODUCTS_FOR_BLOCKING_URI = "/addproductsforblocking";
    public static final String ADD_PRODUCTS_BLOCKING_URL = "/academicTreasury/manageproductsblockacademicalacts//addproductsforblocking";
    private static final String _REMOVE_PRODUCTS_FOR_BLOCKING_URI = "/removeproductsforblocking";
    public static final String REMOVE_PRODUCTS_FOR_BLOCKING_URL = "/academicTreasury/manageproductsblockacademicalacts//removeproductsforblocking";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academicTreasury/manageproductsblockacademicalacts//search";
    }

    @RequestMapping(value={"/search"})
    public String search(Model model) {
        AcademicTreasurySettings academicTreasurySettings = AcademicTreasurySettings.getInstance();
        model.addAttribute("academicTreasurySettings", (Object)academicTreasurySettings);
        model.addAttribute("blockingproducts", Product.findAll().filter(p -> academicTreasurySettings.isAcademicalActBlocking((Product)p)).collect(Collectors.toSet()));
        model.addAttribute("nonblockingproducts", Product.findAll().filter(p -> !academicTreasurySettings.isAcademicalActBlocking((Product)p)).collect(Collectors.toSet()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/addproductsforblocking"}, method={RequestMethod.GET})
    public String addproductsforblocking(Model model) {
        AcademicTreasurySettings academicTreasurySettings = AcademicTreasurySettings.getInstance();
        model.addAttribute("nonblockingproducts", Product.findAll().filter(p -> !academicTreasurySettings.isAcademicalActBlocking((Product)p)).collect(Collectors.toSet()));
        return this.jspPage("addproductsforblocking");
    }

    @RequestMapping(value={"/addproductsforblocking"}, method={RequestMethod.POST})
    public String addproductsforblocking(@RequestParam(value="products") List<Product> products, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicTreasurySettings.getInstance().addProductsForAcademicalActBlocking(Sets.newHashSet(products));
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.jspPage("addproductsforblocking");
        }
    }

    @RequestMapping(value={"/removeproductsforblocking"}, method={RequestMethod.GET})
    public String removeproductsforblocking(Model model) {
        AcademicTreasurySettings academicTreasurySettings = AcademicTreasurySettings.getInstance();
        model.addAttribute("blockingproducts", Product.findAll().filter(p -> academicTreasurySettings.isAcademicalActBlocking((Product)p)).collect(Collectors.toSet()));
        return this.jspPage("removeproductsforblocking");
    }

    @RequestMapping(value={"/removeproductsforblocking"}, method={RequestMethod.POST})
    public String removeproductsforblocking(@RequestParam(value="products") List<Product> products, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicTreasurySettings.getInstance().removeProductsForAcademicalActBlocking(Sets.newHashSet(products));
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.jspPage("removeproductsforblocking");
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/manageproductsblockacademicalacts//" + page;
    }
}

