/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managecoursefunctioncost;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.coursefunctioncost.CourseFunctionCost;
import org.fenixedu.academictreasury.dto.coursefunctioncost.CourseFunctionCostBean;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageCourseFunctionCost", accessGroup="logged")
@RequestMapping(value={"/academictreasury/managecoursefunctioncost/coursefunctioncost"})
public class CourseFunctionCostController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/managecoursefunctioncost/coursefunctioncost";
    private static final String JSP_PATH = "academicTreasury/managecoursefunctioncost/coursefunctioncost/";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/academictreasury/managecoursefunctioncost/coursefunctioncost/";
    private static final String _SEARCH_TO_DELETE_ACTION_URI = "/search/delete/";
    public static final String SEARCH_TO_DELETE_ACTION_URL = "/academictreasury/managecoursefunctioncost/coursefunctioncost/search/delete/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/managecoursefunctioncost/coursefunctioncost/create";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/managecoursefunctioncost/coursefunctioncost/createpostback";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/managecoursefunctioncost/coursefunctioncost/";
    }

    private CourseFunctionCost getCourseFunctionCost(Model model) {
        return (CourseFunctionCost)((Object)model.asMap().get("courseFunctionCost"));
    }

    private void setCourseFunctionCost(CourseFunctionCost courseFunctionCost, Model model) {
        model.addAttribute("courseFunctionCost", (Object)courseFunctionCost);
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="executionyear", required=false) ExecutionYear executionYear, @RequestParam(value="degreecurricularplan", required=false) DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="competencecourses", required=false) CompetenceCourse competenceCourses, Model model) {
        List<CourseFunctionCost> searchcoursefunctioncostResultsDataSet = this.filterSearchCourseFunctionCost(executionYear, degreeCurricularPlan, competenceCourses);
        model.addAttribute("searchcoursefunctioncostResultsDataSet", searchcoursefunctioncostResultsDataSet);
        model.addAttribute("CourseFunctionCost_executionYear_options", ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList()));
        model.addAttribute("CourseFunctionCost_degreeCurricularPlan_options", DegreeCurricularPlan.readNotEmptyDegreeCurricularPlans().stream().sorted(DegreeCurricularPlan.COMPARATOR_BY_PRESENTATION_NAME).collect(Collectors.toList()));
        model.addAttribute("CourseFunctionCost_competenceCourses_options", CompetenceCourse.readBolonhaCompetenceCourses().stream().sorted(CompetenceCourse.COMPETENCE_COURSE_COMPARATOR_BY_NAME).collect(Collectors.toList()));
        return this.jspPage("search");
    }

    private Stream<CourseFunctionCost> getSearchUniverseSearchCourseFunctionCostDataSet() {
        return CourseFunctionCost.findAll();
    }

    private List<CourseFunctionCost> filterSearchCourseFunctionCost(ExecutionYear executionYear, DegreeCurricularPlan degreeCurricularPlan, CompetenceCourse competenceCourses) {
        return this.getSearchUniverseSearchCourseFunctionCostDataSet().filter(courseFunctionCost -> executionYear == null || executionYear == courseFunctionCost.getExecutionYear()).filter(courseFunctionCost -> degreeCurricularPlan == null || degreeCurricularPlan == courseFunctionCost.getDegreeCurricularPlan()).filter(courseFunctionCost -> competenceCourses == null || competenceCourses == courseFunctionCost.getCompetenceCourses()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/delete/{oid}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="oid") CourseFunctionCost courseFunctionCost, Model model, RedirectAttributes redirectAttributes) {
        this.setCourseFunctionCost(courseFunctionCost, model);
        try {
            courseFunctionCost.delete();
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.CourseFunctionCost.delete.success", new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.jspPage("search");
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        CourseFunctionCostBean bean = new CourseFunctionCostBean();
        model.addAttribute("courseFunctionCostBean", (Object)bean);
        model.addAttribute("courseFunctionCostBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpostback(@RequestParam(value="bean", required=false) CourseFunctionCostBean bean, Model model) {
        bean.updateData();
        return this.getBeanJson(bean);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=false) CourseFunctionCostBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            CourseFunctionCost courseFunctionCost = CourseFunctionCost.create(bean);
            model.addAttribute("courseFunctionCost", (Object)courseFunctionCost);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.create(model);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/managecoursefunctioncost/coursefunctioncost//" + page;
    }
}

