/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.manageacademicdebtgenerationrule;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleType;
import org.fenixedu.academictreasury.dto.debtGeneration.AcademicDebtGenerationRuleBean;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.fenixframework.FenixFramework;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageacademicdebtgenerationrule", accessGroup="treasuryManagers")
@RequestMapping(value={"/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule"})
public class AcademicDebtGenerationRuleController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule";
    private static final String JSP_PATH = "academicTreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule";
    private static final String _CHOOSE_TYPE_URI = "/choosetype";
    public static final String CHOOSE_TYPE_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/choosetype";
    private static final String _CHOOSE_EXECUTION_YEAR_URI = "/chooseexecutionyear";
    public static final String CHOOSE_EXECUTION_YEAR_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/chooseexecutionyear";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/search";
    private static final String _SEARCH_TO_DELETE_ACTION_URI = "/search/delete/";
    public static final String SEARCH_TO_DELETE_ACTION_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/search/delete/";
    private static final String _SEARCH_TO_INACTIVATE_ACTION_URI = "/search/inactivate/";
    public static final String SEARCH_TO_INACTIVATE_ACTION_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/search/inactivate/";
    private static final String _SEARCH_TO_ACTIVATE_ACTION_URI = "/search/activate/";
    public static final String SEARCH_TO_ACTIVATE_ACTION_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/search/activate/";
    private static final String _SEARCH_TO_READ_LOG_ACTION_URI = "/readlog/";
    public static final String SEARCH_TO_READ_LOG_ACTION_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/readlog/";
    private static final String _PROCESS_ACTION_URI = "/search/process/";
    public static final String PROCESS_ACTION_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/search/process/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/create";
    private static final String _ADDPRODUCT_URI = "/addproduct";
    public static final String ADDPRODUCT_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/addproduct";
    private static final String _CHOOSEEXECUTIONYEARPOSTBACK_URI = "/chooseexecutionyearpostback";
    public static final String CHOOSEEXECUTIONYEARPOSTBACK_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/chooseexecutionyearpostback";
    private static final String _CHOOSEDEGREETYPEPOSTBACK_URI = "/choosedegreetypepostback";
    public static final String CHOOSEDEGREETYPEPOSTBACK_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/choosedegreetypepostback";
    private static final String _ADDDEGREECURRICULARPLANS_URI = "/adddegreecurricularplans";
    public static final String ADDDEGREECURRICULARPLANS_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/adddegreecurricularplans";
    private static final String _REMOVEDEGREECURRICULARPLAN_URI = "/removedegreecurricularplan";
    public static final String REMOVEDEGREECURRICULARPLAN_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/removedegreecurricularplan";
    private static final String _REMOVEPRODUCT_URI = "/removeproduct";
    public static final String REMOVEPRODUCT_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/removeproduct";
    private static final String _TOGGLE_BACKGROUND_EXECUTION_URI = "/togglebackgroundexecution";
    public static final String TOGGLE_BACKGROUND_EXECUTION_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/togglebackgroundexecution";
    private static final String _ORDER_UP_URI = "/orderup";
    public static final String ORDER_UP_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/orderup";
    private static final String _ORDER_DOWN_URI = "/orderdown";
    public static final String ORDER_DOWN_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/orderdown";
    private static final String _EDIT_DEGREECURRICULARPLANS_URI = "/editdegreecurricularplans";
    public static final String EDIT_DEGREECURRICULARPLANS_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/editdegreecurricularplans";
    private static final String _EDIT_DCP_ADDDEGREECURRICULARPLANS_URI = "/editdcpadddegreecurricularplans";
    public static final String EDIT_DCP_ADDDEGREECURRICULARPLANS_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/editdcpadddegreecurricularplans";
    private static final String _EDIT_DCP_CHOOSEDEGREETYPEPOSTBACK_URI = "/editdcpchoosedegreetypepostback";
    public static final String EDIT_DCP_CHOOSEDEGREETYPEPOSTBACK_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/editdcpchoosedegreetypepostback";
    private static final String _EDIT_DCP_REMOVEDEGREECURRICULARPLAN_URI = "/editdcpremovedegreecurricularplan";
    public static final String EDIT_DCP_REMOVEDEGREECURRICULARPLAN_URL = "/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/editdcpremovedegreecurricularplan";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/choosetype";
    }

    @RequestMapping(value={"/choosetype"})
    public String choosetype(Model model) {
        model.addAttribute("academicDebtGenerationRuleTypesSet", (Object)FenixFramework.getDomainRoot().getAcademicDebtGenerationRuleTypesSet());
        return this.jspPage("choosetype");
    }

    @RequestMapping(value={"/chooseexecutionyear/{typeId}"})
    public String chooseexecutionyear(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        TreeSet executionYearsSet = Sets.newTreeSet(Collections.reverseOrder(ExecutionYear.COMPARATOR_BY_YEAR));
        executionYearsSet.addAll(ExecutionYear.readNotClosedExecutionYears());
        model.addAttribute("executionYearsSet", (Object)executionYearsSet);
        return this.jspPage("chooseexecutionyear");
    }

    @RequestMapping(value={"/search/{typeId}/{executionYearId}"})
    public String search(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("searchacademicdebtgenerationruleResultsDataSet", AcademicDebtGenerationRule.find(type, executionYear).sorted(AcademicDebtGenerationRule.COMPARE_BY_ORDER_NUMBER).collect(Collectors.toList()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/search/delete//{typeId}/{executionYearId}/{oid}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("academicDebtGenerationRule", (Object)academicDebtGenerationRule);
        try {
            academicDebtGenerationRule.delete();
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicDebtGenerationRule.delete.success", new String[0]), model);
            return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.search(type, executionYear, model);
        }
    }

    @RequestMapping(value={"/search/inactivate//{typeId}/{executionYearId}/{oid}"})
    public String processSearchToInactivateAction(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        academicDebtGenerationRule.inactivate();
        return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/search/activate//{typeId}/{executionYearId}/{oid}"})
    public String processSearchToActivateAction(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        academicDebtGenerationRule.activate();
        return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/readlog//{typeId}/{executionYearId}/{oid}"})
    public String processSearchToReadLogAction(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        return this.redirect("/treasury/administration/base/managetreasuryoperationlog/treasuryoperationlog/read/" + academicDebtGenerationRule.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/search/process//{typeId}/{executionYearId}/{oid}"})
    public String processProcessAction(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        AcademicDebtGenerationRule.runAcademicDebtGenerationRule(academicDebtGenerationRule);
        return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/create/{typeId}/{executionYearId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, Model model) {
        AcademicDebtGenerationRuleBean bean = new AcademicDebtGenerationRuleBean(type, executionYear);
        return this._create(bean, type, executionYear, model);
    }

    private String _create(AcademicDebtGenerationRuleBean bean, AcademicDebtGenerationRuleType type, ExecutionYear executionYear, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("academicDebtGenerationRuleBean", (Object)bean);
        model.addAttribute("academicDebtGenerationRuleBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/addproduct/{typeId}/{executionYearId}"}, method={RequestMethod.POST})
    public String addproduct(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        bean.addEntry();
        model.addAttribute("academicDebtGenerationRuleBean", (Object)bean);
        model.addAttribute("academicDebtGenerationRuleBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/chooseexecutionyearpostback/{typeId}/{executionYearId}"}, method={RequestMethod.POST})
    public String chooseExecutionYearPostback(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("academicDebtGenerationRuleBean", (Object)bean);
        model.addAttribute("academicDebtGenerationRuleBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/choosedegreetypepostback/{typeId}/{executionYearId}"}, method={RequestMethod.POST})
    public String chooseDegreeTypePostback(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        bean.chooseDegreeType();
        model.addAttribute("academicDebtGenerationRuleBean", (Object)bean);
        model.addAttribute("academicDebtGenerationRuleBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/adddegreecurricularplans/{typeId}/{executionYearId}"}, method={RequestMethod.POST})
    public String adddegreeCurricularPlans(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        bean.addDegreeCurricularPlans();
        model.addAttribute("academicDebtGenerationRuleBean", (Object)bean);
        model.addAttribute("academicDebtGenerationRuleBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/removedegreecurricularplan/{typeId}/{executionYearId}/{entryIndex}"}, method={RequestMethod.POST})
    public String removeDegreeCurricularPlan(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="entryIndex") int entryIndex, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        bean.removeDegreeCurricularPlan(entryIndex);
        model.addAttribute("academicDebtGenerationRuleBean", (Object)bean);
        model.addAttribute("academicDebtGenerationRuleBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/removeproduct/{typeId}/{executionYearId}/{entryIndex}"}, method={RequestMethod.POST})
    public String removeproduct(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="entryIndex") int entryIndex, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        bean.removEntry(entryIndex);
        model.addAttribute("academicDebtGenerationRuleBean", (Object)bean);
        model.addAttribute("academicDebtGenerationRuleBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/create/{typeId}/{executionYearId}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            AcademicDebtGenerationRule academicDebtGenerationRule = AcademicDebtGenerationRule.create(bean);
            model.addAttribute("academicDebtGenerationRule", (Object)academicDebtGenerationRule);
            return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this._create(bean, type, executionYear, model);
        }
    }

    @RequestMapping(value={"/togglebackgroundexecution/{typeId}/{executionYearId}/{oid}"})
    public String toggleBackgroundExecution(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model, RedirectAttributes redirectAttributes) {
        academicDebtGenerationRule.toggleBackgroundExecution();
        return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/orderup/{typeId}/{executionYearId}/{oid}"})
    public String orderup(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model, RedirectAttributes redirectAttributes) {
        academicDebtGenerationRule.orderUp();
        return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/orderdown/{typeId}/{executionYearId}/{oid}"})
    public String orderdown(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model, RedirectAttributes redirectAttributes) {
        academicDebtGenerationRule.orderDown();
        return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/editdegreecurricularplans/{typeId}/{executionYearId}/{oid}"}, method={RequestMethod.GET})
    public String editdegreecurricularplans(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, Model model) {
        AcademicDebtGenerationRuleBean bean = new AcademicDebtGenerationRuleBean(academicDebtGenerationRule);
        return this._editdegreecurricularplans(type, executionYear, academicDebtGenerationRule, bean, model);
    }

    private String _editdegreecurricularplans(AcademicDebtGenerationRuleType type, ExecutionYear executionYear, AcademicDebtGenerationRule academicDebtGenerationRule, AcademicDebtGenerationRuleBean bean, Model model) {
        model.addAttribute("academicDebtGenerationRuleType", (Object)type);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("academicDebtGenerationRule", (Object)academicDebtGenerationRule);
        model.addAttribute("academicDebtGenerationRuleBean", (Object)bean);
        model.addAttribute("academicDebtGenerationRuleBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("editdegreecurricularplans");
    }

    @RequestMapping(value={"/editdegreecurricularplans/{typeId}/{executionYearId}/{oid}"}, method={RequestMethod.POST})
    public String editdegreecurricularplans(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            academicDebtGenerationRule.editDegreeCurricularPlans(Sets.newHashSet(bean.getDegreeCurricularPlans()));
            return this.redirect(String.format("%s/%s/%s", SEARCH_URL, type.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this._editdegreecurricularplans(type, executionYear, academicDebtGenerationRule, bean, model);
        }
    }

    @RequestMapping(value={"/editdcpadddegreecurricularplans/{typeId}/{executionYearId}/{oid}"}, method={RequestMethod.POST})
    public String editdcpadddegreecurricularplans(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        bean.addDegreeCurricularPlans();
        return this._editdegreecurricularplans(type, executionYear, academicDebtGenerationRule, bean, model);
    }

    @RequestMapping(value={"/editdcpchoosedegreetypepostback/{typeId}/{executionYearId}/{oid}"}, method={RequestMethod.POST})
    public String chooseDegreeTypePostback(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        bean.chooseDegreeType();
        return this._editdegreecurricularplans(type, executionYear, academicDebtGenerationRule, bean, model);
    }

    @RequestMapping(value={"/editdcpremovedegreecurricularplan/{typeId}/{executionYearId}/{oid}/{entryIndex}"}, method={RequestMethod.POST})
    public String editdcpremovedegreecurricularplan(@PathVariable(value="typeId") AcademicDebtGenerationRuleType type, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="oid") AcademicDebtGenerationRule academicDebtGenerationRule, @PathVariable(value="entryIndex") int entryIndex, @RequestParam(value="bean", required=false) AcademicDebtGenerationRuleBean bean, Model model) {
        bean.removeDegreeCurricularPlan(entryIndex);
        return this._editdegreecurricularplans(type, executionYear, academicDebtGenerationRule, bean, model);
    }

    private String jspPage(String page) {
        return "academicTreasury/manageacademicdebtgenerationrule/academicdebtgenerationrule/" + page;
    }
}

