/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.integration.tuitioninfo;

import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoProduct;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.ERPTuitionInfoProduct.title", accessGroup="#managers")
@RequestMapping(value={"/academictreasury/erptuitioninfoproduct"})
public class ERPTuitionInfoProductController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/erptuitioninfoproduct";
    public static final String JSP_PATH = "academicTreasury/erptuitioninfoproduct";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/academictreasury/erptuitioninfoproduct/search";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/erptuitioninfoproduct/create";
    private static final String _UPDATE_URI = "/update";
    public static final String UPDATE_URL = "/academictreasury/erptuitioninfoproduct/update";
    private static final String _DELETE_URI = "/delete";
    public static final String DELETE_URL = "/academictreasury/erptuitioninfoproduct/delete";

    @RequestMapping
    public String home() {
        return "redirect:/academictreasury/erptuitioninfoproduct/search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(Model model) {
        Set erpTuitionInfoProductsSet = ERPTuitionInfoProduct.findAll().collect(Collectors.toSet());
        model.addAttribute("result", erpTuitionInfoProductsSet);
        return this.jspPage(_SEARCH_URI);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return this.jspPage(_CREATE_URI);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(Model model, @RequestParam(value="code") String code, @RequestParam(value="name") String name) {
        try {
            ERPTuitionInfoProduct.create(code, name);
            return "redirect:/academictreasury/erptuitioninfoproduct/search";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.jspPage(_CREATE_URI);
        }
    }

    @RequestMapping(value={"/update/{erpTuitionInfoProductId}"}, method={RequestMethod.GET})
    public String update(Model model, @PathVariable(value="erpTuitionInfoProductId") ERPTuitionInfoProduct erpTuitionInfoProduct) {
        model.addAttribute("erpTuitionInfoProduct", (Object)erpTuitionInfoProduct);
        return this.jspPage(_UPDATE_URI);
    }

    @RequestMapping(value={"/update/{erpTuitionInfoProductId}"}, method={RequestMethod.POST})
    public String update(Model model, @PathVariable(value="erpTuitionInfoProductId") ERPTuitionInfoProduct erpTuitionInfoProduct, @RequestParam(value="name") String name) {
        try {
            erpTuitionInfoProduct.update(name);
            return "redirect:/academictreasury/erptuitioninfoproduct/search";
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.jspPage(_UPDATE_URI);
        }
    }

    @RequestMapping(value={"/delete/{erpTuitionInfoProductId}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="erpTuitionInfoProductId") ERPTuitionInfoProduct erpTuitionInfoProduct, Model model, RedirectAttributes redirectAttributes) {
        try {
            erpTuitionInfoProduct.delete();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.redirect(SEARCH_URL, model, redirectAttributes);
    }

    private String jspPage(String page) {
        return JSP_PATH + page;
    }
}

