/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.dto.academictax.AcademicTaxDebitEntryBean;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$calculateAcademicTax;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$calculateImprovementTax;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$createAcademicTax;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$createAcademicTax$1;
import org.fenixedu.academictreasury.services.AcademicTaxServices$callable$createImprovementTax;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AcademicTaxServices {
    public static final Advice advice$calculateAcademicTax = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicTax = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicTax$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$calculateImprovementTax = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createImprovementTax = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static List<IAcademicTreasuryEvent> findAllTreasuryEventsForAcademicTaxes(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findAllForAcademicTax(registration, executionYear).collect(Collectors.toList());
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEvent(Registration registration, ExecutionYear executionYear, AcademicTax academicTax) {
        return AcademicTreasuryEvent.findUniqueForAcademicTax(registration, executionYear, academicTax).orElse(null);
    }

    public static AcademicTariff findAcademicTariff(AcademicTax academicTax, Registration registration, LocalDate debtDate) {
        return AcademicTariff.findMatch(academicTax.getProduct(), registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
    }

    public static AcademicTaxDebitEntryBean calculateAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate localDate, boolean bl) {
        return (AcademicTaxDebitEntryBean)advice$calculateAcademicTax.perform((Callable)new AcademicTaxServices$callable$calculateAcademicTax(registration, executionYear, academicTax, localDate, bl));
    }

    static /* synthetic */ AcademicTaxDebitEntryBean advised$calculateAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate debtDate, boolean forceCreation) {
        if (!forceCreation && TuitionServices.normalEnrolments(registration, executionYear).isEmpty()) {
            return null;
        }
        if (!AcademicTaxServices.isAppliableOnRegistration(academicTax, registration, executionYear)) {
            return null;
        }
        if (AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax) == null) {
            PersonCustomer personCustomer;
            Person person = registration.getPerson();
            String fiscalCountryCode = PersonCustomer.countryCode(person);
            String fiscalNumber = PersonCustomer.fiscalNumber(person);
            if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
            }
            if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
                PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
            }
            if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
            }
            AcademicTariff academicTariff = AcademicTaxServices.findAcademicTariff(academicTax, registration, debtDate);
            if (academicTariff == null) {
                return null;
            }
            AcademicTreasuryEvent.createForAcademicTax(academicTax, registration, executionYear);
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax);
        AcademicTariff academicTariff = AcademicTariff.findMatch(academicTax.getProduct(), registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
        LocalizedString debitEntryName = academicTariff.academicTaxDebitEntryName(academicTreasuryEvent);
        LocalDate dueDate = academicTariff.dueDate(debtDate);
        Vat vat = academicTariff.vat(debtDate);
        BigDecimal amount = academicTariff.amountToPay(academicTreasuryEvent);
        return new AcademicTaxDebitEntryBean(debitEntryName, dueDate, vat.getTaxRate(), amount);
    }

    public static boolean isAcademicTaxCharged(Registration registration, ExecutionYear executionYear, AcademicTax academicTax) {
        if (AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax);
        return academicTreasuryEvent.isCharged();
    }

    public static boolean createAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, boolean bl) {
        return (Boolean)advice$createAcademicTax.perform((Callable)new AcademicTaxServices$callable$createAcademicTax(registration, executionYear, academicTax, bl));
    }

    static /* synthetic */ boolean advised$createAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, boolean forceCreation) {
        return AcademicTaxServices.createAcademicTax(registration, executionYear, academicTax, new LocalDate(), forceCreation);
    }

    public static boolean createAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createAcademicTax$1.perform((Callable)new AcademicTaxServices$callable$createAcademicTax$1(registration, executionYear, academicTax, localDate, bl));
    }

    static /* synthetic */ boolean advised$createAcademicTax(Registration registration, ExecutionYear executionYear, AcademicTax academicTax, LocalDate when, boolean forceCreation) {
        AcademicTreasuryEvent academicTreasuryEvent;
        AcademicTariff academicTariff;
        if (!forceCreation && TuitionServices.normalEnrolments(registration, executionYear).isEmpty()) {
            return false;
        }
        if (!AcademicTaxServices.isAppliableOnRegistration(academicTax, registration, executionYear)) {
            return false;
        }
        Person person = registration.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax) == null) {
            PersonCustomer personCustomer;
            if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
            }
            if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
                PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
            }
            if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
            }
            academicTariff = AcademicTaxServices.findAcademicTariff(academicTax, registration, when);
            if (academicTariff == null) {
                return false;
            }
            if (!DebtAccount.findUnique((FinantialInstitution)academicTariff.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
                DebtAccount.create((FinantialInstitution)academicTariff.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
            }
            AcademicTreasuryEvent.createForAcademicTax(academicTax, registration, executionYear);
        }
        if ((academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax)).isChargedWithDebitEntry()) {
            return false;
        }
        academicTariff = AcademicTariff.findMatch(academicTax.getProduct(), registration.getDegree(), when.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            return false;
        }
        PersonCustomer personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get();
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)academicTariff.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).get();
        academicTariff.createDebitEntryForAcademicTax(debtAccount, academicTreasuryEvent, when);
        return true;
    }

    public static boolean isRegistrationFirstYear(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationYear() == executionYear;
    }

    public static boolean isRegistrationSubsequentYear(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationYear().isBefore(executionYear);
    }

    public static boolean isAppliableOnRegistration(AcademicTax academicTax, Registration registration, ExecutionYear executionYear) {
        return AcademicTaxServices.isRegistrationFirstYear(registration, executionYear) && academicTax.isAppliedOnRegistrationFirstYear() || AcademicTaxServices.isRegistrationSubsequentYear(registration, executionYear) && academicTax.isAppliedOnRegistrationSubsequentYears();
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEventForImprovementTax(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findUniqueForImprovementTuition(registration, executionYear).orElse(null);
    }

    public static AcademicTariff findAcademicTariff(EnrolmentEvaluation enrolmentEvaluation, LocalDate debtDate) {
        Registration registration = enrolmentEvaluation.getRegistration();
        return AcademicTariff.findMatch(AcademicTreasurySettings.getInstance().getImprovementAcademicTax().getProduct(), registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
    }

    public static boolean isImprovementAcademicTaxCharged(Registration registration, ExecutionYear executionYear, EnrolmentEvaluation enrolmentEvaluation) {
        if (AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear);
        return academicTreasuryEvent.isChargedWithDebitEntry(enrolmentEvaluation);
    }

    public static AcademicTaxDebitEntryBean calculateImprovementTax(EnrolmentEvaluation enrolmentEvaluation, LocalDate localDate) {
        return (AcademicTaxDebitEntryBean)advice$calculateImprovementTax.perform((Callable)new AcademicTaxServices$callable$calculateImprovementTax(enrolmentEvaluation, localDate));
    }

    static /* synthetic */ AcademicTaxDebitEntryBean advised$calculateImprovementTax(EnrolmentEvaluation enrolmentEvaluation, LocalDate debtDate) {
        AcademicTreasuryEvent academicTreasuryEvent;
        ExecutionYear executionYear;
        if (!enrolmentEvaluation.getEvaluationSeason().isImprovement()) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxServices.enrolmentEvaluation.is.not.improvement", new String[0]);
        }
        AcademicTax improvementAcademicTax = AcademicTreasurySettings.getInstance().getImprovementAcademicTax();
        if (improvementAcademicTax == null) {
            return null;
        }
        Registration registration = enrolmentEvaluation.getRegistration();
        if (AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear = enrolmentEvaluation.getExecutionPeriod().getExecutionYear()) == null) {
            PersonCustomer personCustomer;
            Person person = registration.getPerson();
            String fiscalCountryCode = PersonCustomer.countryCode(person);
            String fiscalNumber = PersonCustomer.fiscalNumber(person);
            if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
            }
            if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
                PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
            }
            if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
            }
            AcademicTariff academicTariff = AcademicTaxServices.findAcademicTariff(enrolmentEvaluation, debtDate);
            if (academicTariff == null) {
                return null;
            }
            AcademicTreasuryEvent.createForImprovementTuition(registration, executionYear);
        }
        if ((academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear)).isChargedWithDebitEntry(enrolmentEvaluation)) {
            return null;
        }
        AcademicTariff academicTariff = AcademicTariff.findMatch(improvementAcademicTax.getProduct(), registration.getDegree(), debtDate.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            return null;
        }
        LocalizedString debitEntryName = academicTariff.improvementDebitEntryName(academicTreasuryEvent, enrolmentEvaluation);
        LocalDate dueDate = academicTariff.dueDate(debtDate);
        Vat vat = academicTariff.vat(debtDate);
        BigDecimal amount = academicTariff.amountToPay(academicTreasuryEvent, enrolmentEvaluation);
        return new AcademicTaxDebitEntryBean(debitEntryName, dueDate, vat.getTaxRate(), amount);
    }

    public static boolean createImprovementTax(EnrolmentEvaluation enrolmentEvaluation, LocalDate localDate) {
        return (Boolean)advice$createImprovementTax.perform((Callable)new AcademicTaxServices$callable$createImprovementTax(enrolmentEvaluation, localDate));
    }

    static /* synthetic */ boolean advised$createImprovementTax(EnrolmentEvaluation enrolmentEvaluation, LocalDate when) {
        AcademicTreasuryEvent academicTreasuryEvent;
        AcademicTariff academicTariff;
        if (!enrolmentEvaluation.getEvaluationSeason().isImprovement()) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxServices.enrolmentEvaluation.is.not.improvement", new String[0]);
        }
        Registration registration = enrolmentEvaluation.getRegistration();
        ExecutionYear executionYear = enrolmentEvaluation.getExecutionPeriod().getExecutionYear();
        AcademicTreasurySettings instance = AcademicTreasurySettings.getInstance();
        if (instance == null) {
            return false;
        }
        AcademicTax improvementAcademicTax = instance.getImprovementAcademicTax();
        if (improvementAcademicTax == null) {
            return false;
        }
        Person person = registration.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear) == null) {
            PersonCustomer personCustomer;
            if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
            }
            if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
                PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
            }
            if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
            }
            academicTariff = AcademicTariff.findMatch(improvementAcademicTax.getProduct(), registration.getDegree(), when.toDateTimeAtStartOfDay());
            if (academicTariff == null) {
                throw new AcademicTreasuryDomainException("error.AcademicTaxDebtCreation.tariff.not.found", new String[0]);
            }
            AcademicTreasuryEvent.createForImprovementTuition(registration, executionYear);
        }
        if ((academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear)).isChargedWithDebitEntry(enrolmentEvaluation)) {
            return false;
        }
        academicTariff = AcademicTariff.findMatch(improvementAcademicTax.getProduct(), registration.getDegree(), when.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.AcademicTaxDebtCreation.tariff.not.found", new String[0]);
        }
        PersonCustomer personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get();
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)academicTariff.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).get();
        DebitEntry debitEntry = academicTariff.createDebitEntryForImprovement(debtAccount, academicTreasuryEvent, enrolmentEvaluation);
        return debitEntry != null;
    }

    public static boolean removeDebitEntryForImprovement(EnrolmentEvaluation improvementEnrolmentEvaluation) {
        ExecutionYear executionYear;
        Registration registration = improvementEnrolmentEvaluation.getRegistration();
        if (AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear = improvementEnrolmentEvaluation.getExecutionPeriod().getExecutionYear()) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear);
        if (!academicTreasuryEvent.isChargedWithDebitEntry(improvementEnrolmentEvaluation)) {
            return false;
        }
        DebitEntry debitEntry = academicTreasuryEvent.findActiveEnrolmentEvaluationDebitEntry(improvementEnrolmentEvaluation).get();
        DebitNote debitNote = (DebitNote)debitEntry.getFinantialDocument();
        if (!debitEntry.isProcessedInDebitNote()) {
            debitEntry.annulDebitEntry(AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTaxServices.removeDebitEntryForImprovement.reason", new String[0]));
            return true;
        }
        if (debitEntry.getCreditEntriesSet().isEmpty()) {
            debitNote.anullDebitNoteWithCreditNote(AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTaxServices.removeDebitEntryForImprovement.reason", new String[0]), false);
            return true;
        }
        return false;
    }
}

