/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.schoolsbootstrapscript;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.fenixedu.treasury.domain.document.FinantialDocument;

public class MoveTemporaryDocumentOriginNumberToDocumentObservations
extends CustomTask {
    public void runTask() throws Exception {
        int count = 0;
        for (FinantialDocument finantialDocument : FinantialDocument.findAll().collect(Collectors.toSet())) {
            if (Strings.isNullOrEmpty((String)finantialDocument.getOriginDocumentNumber()) || !finantialDocument.getOriginDocumentNumber().contains("_")) continue;
            this.getLogger().info(String.format("Change %s ", finantialDocument.getOriginDocumentNumber()));
            finantialDocument.setDocumentObservations(finantialDocument.getOriginDocumentNumber());
            finantialDocument.setOriginDocumentNumber("");
            ++count;
        }
        this.getLogger().info(String.format("Changed %d/%d", count, FinantialDocument.findAll().count()));
    }
}

