/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.schoolsbootstrapscript;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academictreasury.schoolsbootstrapscript.CreateAdvancePaymentReferenceCodes$callable$create;
import org.fenixedu.bennu.scheduler.custom.CustomTask;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateAdvancePaymentReferenceCodes
extends CustomTask {
    private static final String CODE_FILLER = "0";
    private static final int NUM_CONTROL_DIGITS = 2;
    private static final int NUM_SEQUENTIAL_NUMBERS = 7;
    private static final int LENGTH_REFERENCE_CODE = 9;
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public void runTask() throws Exception {
        FinantialInstitution finantialInstitution = (FinantialInstitution)FinantialInstitution.findAll().findFirst().get();
        PaymentCodePool paymentCodePool = (PaymentCodePool)FenixFramework.getDomainObject((String)"1128610031206402");
        for (long i = 0x6DDD00L; i < 7349999L; ++i) {
            if (i % 10000L == 0L) {
                this.taskLog("%d\n", new Object[]{i});
            }
            this.generateNewCodeFor(paymentCodePool.getMaxAmount(), paymentCodePool.getValidFrom(), paymentCodePool.getValidTo(), false, paymentCodePool, i);
        }
    }

    private void generateNewCodeFor(BigDecimal amount, LocalDate validFrom, LocalDate validTo, boolean useFixedAmount, PaymentCodePool referenceCodePool, long nextSequentialNumber) {
        String sequentialNumberPadded = StringUtils.leftPad((String)String.valueOf(nextSequentialNumber), (int)7, (String)CODE_FILLER);
        String controDigitsPadded = StringUtils.leftPad((String)String.valueOf(new Random().nextInt(99)), (int)2, (String)CODE_FILLER);
        String referenceCodeString = sequentialNumberPadded + controDigitsPadded;
        BigDecimal minAmount = referenceCodePool.getMinAmount();
        BigDecimal maxAmount = referenceCodePool.getMaxAmount();
        if (useFixedAmount) {
            minAmount = amount;
            maxAmount = amount;
        } else if (TreasuryConstants.isGreaterThan((BigDecimal)amount, (BigDecimal)maxAmount)) {
            maxAmount = amount;
        }
        PaymentReferenceCode newPaymentReference = this.create(referenceCodeString, validFrom, validTo, PaymentReferenceCodeStateType.UNUSED, referenceCodePool, minAmount, maxAmount);
        newPaymentReference.setPayableAmount(amount);
    }

    public PaymentReferenceCode create(String string, LocalDate localDate, LocalDate localDate2, PaymentReferenceCodeStateType paymentReferenceCodeStateType, PaymentCodePool paymentCodePool, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (PaymentReferenceCode)advice$create.perform((Callable)new CreateAdvancePaymentReferenceCodes$callable$create(this, string, localDate, localDate2, paymentReferenceCodeStateType, paymentCodePool, bigDecimal, bigDecimal2));
    }

    static /* synthetic */ PaymentReferenceCode advised$create(CreateAdvancePaymentReferenceCodes this_, String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, PaymentCodePool pool, BigDecimal minAmount, BigDecimal maxAmount) {
        PaymentReferenceCode paymentReferenceCode = new PaymentReferenceCode();
        this_.init(paymentReferenceCode, referenceCode, beginDate, endDate, state, pool, minAmount, maxAmount);
        return paymentReferenceCode;
    }

    protected void init(PaymentReferenceCode code, String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, PaymentCodePool pool, BigDecimal minAmount, BigDecimal maxAmount) {
        code.setReferenceCode(Strings.padStart((String)referenceCode, (int)9, (char)'0'));
        code.setBeginDate(beginDate);
        code.setEndDate(endDate);
        code.setState(state);
        code.setPaymentCodePool(pool);
        code.setMinAmount(minAmount);
        code.setMaxAmount(maxAmount);
        this.checkRules(code);
    }

    private void checkRules(PaymentReferenceCode code) {
        if (code.getMinAmount() == null) {
            code.setMinAmount(BigDecimal.ZERO);
        }
        if (code.getMaxAmount() == null) {
            code.setMaxAmount(BigDecimal.ZERO);
        }
    }
}

