/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.tuition;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tuition.TuitionDebtCreationBean$callable$updateData;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionDebtCreationBean
implements Serializable,
ITreasuryBean {
    private static final long serialVersionUID = 1L;
    private LocalDate debtDate;
    private ExecutionYear executionYear;
    private Registration registration;
    private TuitionPaymentPlan tuitionPaymentPlan;
    private Enrolment enrolment;
    private DebtAccount debtAccount;
    private List<TreasuryTupleDataSourceBean> registrationDataSource;
    private List<TreasuryTupleDataSourceBean> executionYearDataSource;
    private List<TreasuryTupleDataSourceBean> tuitionPaymentPlansDataSource;
    private List<TreasuryTupleDataSourceBean> standaloneEnrolmentsDataSource;
    private List<TreasuryTupleDataSourceBean> extracurricularEnrolmentsDataSource;
    private List<TreasuryTupleDataSourceBean> improvementEnrolmentEvaluationsDataSource;
    private String errorMessage;
    private TuitionPaymentPlanGroup tuitionPaymentPlanGroup;
    private AcademicTax academicTax;
    public static final Advice advice$updateData = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public TuitionDebtCreationBean(DebtAccount debtAccount, TuitionPaymentPlanGroup tuitionPaymentPlanGroup) {
        this.debtAccount = debtAccount;
        this.tuitionPaymentPlanGroup = tuitionPaymentPlanGroup;
        this.updateData();
    }

    public TuitionDebtCreationBean(DebtAccount debtAccount, AcademicTax academicTax) {
        this.debtAccount = debtAccount;
        this.academicTax = academicTax;
        this.updateData();
    }

    public void updateData() {
        Object object = advice$updateData.perform((Callable)new TuitionDebtCreationBean$callable$updateData(this));
    }

    static /* synthetic */ void advised$updateData(TuitionDebtCreationBean this_) {
        if (!(this_.executionYear == null || this_.registration != null && this_.possibleExecutionYears().contains(this_.executionYear))) {
            this_.executionYear = null;
            this_.tuitionPaymentPlan = null;
        }
        this_.getRegistrationDataSource();
        this_.getExecutionYearDataSource();
        this_.getTuitionPaymentPlansDataSource();
        this_.getErrorMessage();
        this_.getStandaloneEnrolmentsDataSource();
        this_.getExtracurricularEnrolmentsDataSource();
        this_.getImprovementEnrolmentEvaluationsDataSource();
        this_.debtDate = this_.registration != null && this_.executionYear != null && this_.isRegistrationTuition() && !TuitionServices.normalEnrolments(this_.registration, this_.executionYear).isEmpty() ? TuitionServices.enrolmentDate(this_.registration, this_.executionYear, false) : new LocalDate();
    }

    public List<TreasuryTupleDataSourceBean> getExecutionYearDataSource() {
        this.executionYearDataSource = Lists.newArrayList();
        for (ExecutionYear executionYear : this.possibleExecutionYears()) {
            String id = executionYear.getExternalId();
            String text = executionYear.getQualifiedName();
            if (this.isRegistrationTuition() && this.registration != null) {
                Set<Enrolment> normalEnrolments = TuitionServices.normalEnrolments(this.registration, executionYear);
                if (normalEnrolments.size() == 1) {
                    text = text + " " + AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionDebtCreationBean.enrolments.one", new String[0]);
                } else if (normalEnrolments.size() > 1) {
                    text = text + " " + AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionDebtCreationBean.enrolments", String.valueOf(normalEnrolments.size()));
                }
            }
            this.executionYearDataSource.add(new TreasuryTupleDataSourceBean(id, text));
        }
        return this.executionYearDataSource;
    }

    private List<ExecutionYear> possibleExecutionYears() {
        List<ExecutionYear> executionYears = ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList());
        return executionYears;
    }

    public List<TreasuryTupleDataSourceBean> getRegistrationDataSource() {
        if (!this.isStudent()) {
            this.registrationDataSource = Lists.newArrayList();
            return this.registrationDataSource;
        }
        this.registrationDataSource = ((PersonCustomer)this.debtAccount.getCustomer()).getPerson().getStudent().getRegistrationsSet().stream().map(r -> new TreasuryTupleDataSourceBean(r.getExternalId(), String.format("[%s] %s", r.getDegree().getCode(), r.getDegree().getPresentationNameI18N(this.getExecutionYear()).getContent()))).collect(Collectors.toList());
        return this.registrationDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getTuitionPaymentPlansDataSource() {
        this.tuitionPaymentPlansDataSource = Lists.newArrayList();
        if (!this.isStudent()) {
            return this.tuitionPaymentPlansDataSource;
        }
        if (this.getRegistration() == null || this.getExecutionYear() == null) {
            return this.tuitionPaymentPlansDataSource;
        }
        if ((this.isStandaloneTuition() || this.isExtracurricularTuition()) && this.enrolment == null) {
            return this.tuitionPaymentPlansDataSource;
        }
        if (this.isRegistrationTuition()) {
            StudentCurricularPlan studentCurricularPlan = this.registration.getStudentCurricularPlan(this.getExecutionYear());
            if (studentCurricularPlan == null) {
                return this.tuitionPaymentPlansDataSource;
            }
            this.tuitionPaymentPlansDataSource = TuitionPaymentPlan.find(this.tuitionPaymentPlanGroup, studentCurricularPlan.getDegreeCurricularPlan(), this.getExecutionYear()).map(t -> new TreasuryTupleDataSourceBean(t.getExternalId(), t.getConditionsDescription().getContent())).collect(Collectors.toList());
        } else if (this.isStandaloneTuition() || this.isExtracurricularTuition()) {
            this.tuitionPaymentPlansDataSource = TuitionPaymentPlan.find(this.tuitionPaymentPlanGroup, this.enrolment.getCurricularCourse().getDegreeCurricularPlan(), this.getExecutionYear()).map(t -> new TreasuryTupleDataSourceBean(t.getExternalId(), t.getConditionsDescription().getContent())).collect(Collectors.toList());
        }
        return this.tuitionPaymentPlansDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getStandaloneEnrolmentsDataSource() {
        if (!this.isStudent()) {
            this.standaloneEnrolmentsDataSource = Lists.newArrayList();
            return this.standaloneEnrolmentsDataSource;
        }
        if (this.getRegistration() == null || this.getExecutionYear() == null) {
            this.standaloneEnrolmentsDataSource = Lists.newArrayList();
            return this.standaloneEnrolmentsDataSource;
        }
        this.standaloneEnrolmentsDataSource = TuitionServices.standaloneEnrolments(this.getRegistration(), this.getExecutionYear()).stream().sorted(Enrolment.COMPARATOR_BY_NAME_AND_ID).collect(Collectors.toList()).stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getName().getContent())).collect(Collectors.toList());
        return this.standaloneEnrolmentsDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getExtracurricularEnrolmentsDataSource() {
        if (!this.isStudent()) {
            this.extracurricularEnrolmentsDataSource = Lists.newArrayList();
            return this.extracurricularEnrolmentsDataSource;
        }
        if (this.getRegistration() == null || this.getExecutionYear() == null) {
            this.extracurricularEnrolmentsDataSource = Lists.newArrayList();
            return this.extracurricularEnrolmentsDataSource;
        }
        this.extracurricularEnrolmentsDataSource = TuitionServices.extracurricularEnrolments(this.getRegistration(), this.getExecutionYear()).stream().sorted(Enrolment.COMPARATOR_BY_NAME_AND_ID).collect(Collectors.toList()).stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getName().getContent())).collect(Collectors.toList());
        return this.extracurricularEnrolmentsDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getImprovementEnrolmentEvaluationsDataSource() {
        if (!this.isStudent()) {
            this.improvementEnrolmentEvaluationsDataSource = Lists.newArrayList();
            return this.improvementEnrolmentEvaluationsDataSource;
        }
        if (this.getRegistration() == null || this.getExecutionYear() == null) {
            this.improvementEnrolmentEvaluationsDataSource = Lists.newArrayList();
            return this.improvementEnrolmentEvaluationsDataSource;
        }
        this.improvementEnrolmentEvaluationsDataSource = TuitionServices.improvementEnrolments(this.getRegistration(), this.getExecutionYear()).stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getEnrolment().getName().getContent() + " - " + l.getExecutionPeriod().getQualifiedName())).collect(Collectors.toList()).stream().sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        return this.improvementEnrolmentEvaluationsDataSource;
    }

    public boolean isTuitionCharged() {
        if (this.registration == null || this.executionYear == null) {
            return false;
        }
        if ((this.isStandaloneTuition() || this.isExtracurricularTuition()) && this.enrolment == null) {
            return false;
        }
        if (this.isRegistrationTuition()) {
            return TuitionServices.isTuitionForRegistrationCharged(this.registration, this.executionYear);
        }
        if (this.isStandaloneTuition()) {
            return TuitionServices.isTuitionForStandaloneCharged(this.registration, this.executionYear, this.enrolment);
        }
        if (this.isExtracurricularTuition()) {
            return TuitionServices.isTuitionForExtracurricularCharged(this.registration, this.executionYear, this.enrolment);
        }
        return false;
    }

    public String getErrorMessage() {
        this.errorMessage = "";
        this.tuitionPaymentPlan = null;
        if (this.registration == null || this.executionYear == null) {
            this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionDebtCreationBean.infer.select.registration.and.executionYear", new String[0]);
            return this.errorMessage;
        }
        if ((this.isStandaloneTuition() || this.isExtracurricularTuition()) && this.enrolment == null) {
            this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionDebtCreationBean.infer.select.enrolment", new String[0]);
            return this.errorMessage;
        }
        if (this.isRegistrationTuition()) {
            if (TuitionServices.isTuitionForRegistrationCharged(this.registration, this.executionYear)) {
                this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("error.TuitionDebtCreationBean.tuition.registration.already.charged", new String[0]);
                return this.errorMessage;
            }
            this.tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(this.registration, this.executionYear);
            if (this.tuitionPaymentPlan == null) {
                this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionDebtCreationBean.infer.impossible", new String[0]);
            }
        } else if (this.isStandaloneTuition()) {
            if (TuitionServices.isTuitionForStandaloneCharged(this.registration, this.executionYear, this.enrolment)) {
                this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("error.TuitionDebtCreationBean.tuition.registration.already.charged", new String[0]);
                return this.errorMessage;
            }
            this.tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForStandaloneEnrolment(this.registration, this.executionYear, this.enrolment);
            if (this.tuitionPaymentPlan == null) {
                this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionDebtCreationBean.infer.impossible", new String[0]);
            }
        } else if (this.isExtracurricularTuition()) {
            if (TuitionServices.isTuitionForExtracurricularCharged(this.registration, this.executionYear, this.enrolment)) {
                this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("error.TuitionDebtCreationBean.tuition.registration.already.charged", new String[0]);
                return this.errorMessage;
            }
            this.tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForExtracurricularEnrolment(this.registration, this.executionYear, this.enrolment);
            if (this.tuitionPaymentPlan == null) {
                this.errorMessage = AcademicTreasuryConstants.academicTreasuryBundle("label.TuitionDebtCreationBean.infer.impossible", new String[0]);
            }
        }
        return this.errorMessage;
    }

    public boolean isImprovementTax() {
        return this.academicTax != null && this.academicTax == AcademicTreasurySettings.getInstance().getImprovementAcademicTax();
    }

    public boolean isStandaloneTuition() {
        return this.tuitionPaymentPlanGroup != null && this.tuitionPaymentPlanGroup.isForStandalone();
    }

    public boolean isExtracurricularTuition() {
        return this.tuitionPaymentPlanGroup != null && this.tuitionPaymentPlanGroup.isForExtracurricular();
    }

    public boolean isRegistrationTuition() {
        return this.tuitionPaymentPlanGroup != null && this.tuitionPaymentPlanGroup.isForRegistration();
    }

    public boolean isStudent() {
        return this.debtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)this.debtAccount.getCustomer()).getPerson().getStudent() != null;
    }

    public LocalDate getDebtDate() {
        return this.debtDate;
    }

    public void setDebtDate(LocalDate debtDate) {
        this.debtDate = debtDate;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public void setRegistration(Registration registration) {
        this.registration = registration;
    }

    public TuitionPaymentPlan getTuitionPaymentPlan() {
        return this.tuitionPaymentPlan;
    }

    public void setTuitionPaymentPlan(TuitionPaymentPlan tuitionPaymentPlan) {
        this.tuitionPaymentPlan = tuitionPaymentPlan;
    }

    public Enrolment getEnrolment() {
        return this.enrolment;
    }

    public void setEnrolment(Enrolment enrolment) {
        this.enrolment = enrolment;
    }
}

