/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AbstractReportEntryBean;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.joda.time.DateTime;

public class TreasuryExemptionReportEntryBean
extends AbstractReportEntryBean {
    public static String[] SPREADSHEET_HEADERS = new String[]{AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.identification", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.versioningCreator", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.creationDate", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.customerId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.debtAccountId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.customerName", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.debitEntryId", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.debitEntryDescription", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.exemptedAmount", new String[0]), AcademicTreasuryConstants.academicTreasuryBundle("label.TreasuryExemptionReportEntryBean.header.reason", new String[0])};
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private String customerId;
    private String customerName;
    private String debtAccountId;
    private String debitEntryId;
    private String debitEntryDescription;
    private String exemptedAmount;
    private String reason;
    private TreasuryExemption treasuryExemption;
    boolean completed = false;

    public TreasuryExemptionReportEntryBean(TreasuryExemption treasuryExemption, DebtReportRequest request, ErrorsLog errorsLog) {
        String decimalSeparator = request.getDecimalSeparator();
        try {
            this.treasuryExemption = treasuryExemption;
            this.identification = treasuryExemption.getExternalId();
            this.versioningCreator = TreasuryPlataformDependentServicesFactory.implementation().versioningCreatorUsername((Object)treasuryExemption);
            this.creationDate = TreasuryPlataformDependentServicesFactory.implementation().versioningCreationDate((Object)treasuryExemption);
            this.customerId = treasuryExemption.getDebitEntry().getDebtAccount().getCustomer().getExternalId();
            this.customerName = treasuryExemption.getDebitEntry().getDebtAccount().getCustomer().getName();
            this.debtAccountId = treasuryExemption.getDebitEntry().getDebtAccount().getExternalId();
            this.debitEntryId = treasuryExemption.getDebitEntry().getExternalId();
            this.debitEntryDescription = treasuryExemption.getDebitEntry().getDescription();
            this.exemptedAmount = treasuryExemption.getDebitEntry().getCurrency().getValueFor(treasuryExemption.getValueToExempt());
            if (",".equals(decimalSeparator)) {
                this.exemptedAmount = this.exemptedAmount.replace(".", ",");
            }
            this.reason = treasuryExemption.getReason();
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(treasuryExemption, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(AcademicTreasuryConstants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.versioningCreator));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.customerId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.debtAccountId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.customerName));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.debitEntryId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.debitEntryDescription));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.exemptedAmount));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.reason));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.treasuryExemption, e);
        }
    }
}

