/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.treasury;

import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academic.domain.treasury.IImprovementTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IPaymentCodePool;
import org.fenixedu.academic.domain.treasury.ITreasuryBridgeAPI;
import org.fenixedu.academic.domain.treasury.ITreasuryEntity;
import org.fenixedu.academic.domain.treasury.ITreasuryProduct;
import org.fenixedu.academic.domain.treasury.ITuitionTreasuryEvent;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.PersonServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class AcademicTreasuryBridgeImpl
implements ITreasuryBridgeAPI {
    public Set<ITreasuryEntity> getTreasuryEntities() {
        return FinantialEntity.findAll().map(f -> new TreasuryEntity((FinantialEntity)f)).collect(Collectors.toSet());
    }

    public ITreasuryEntity getTreasuryEntityByCode(String code) {
        if (FenixFramework.getDomainObject((String)code) == null) {
            throw new AcademicTreasuryDomainException("error.ITreasuryBridgeAPI.finantial.entity.not.found", new String[0]);
        }
        return new TreasuryEntity((FinantialEntity)FenixFramework.getDomainObject((String)code));
    }

    public Set<ITreasuryProduct> getProducts(ITreasuryEntity treasuryEntity) {
        return Product.findAllActive().filter(p -> p.getFinantialInstitutionsSet().contains(((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution())).map(p -> new AcademicProduct((Product)p)).collect(Collectors.toSet());
    }

    public ITreasuryProduct getProductByCode(String code) {
        return Product.findUniqueByCode((String)code).map(p -> new AcademicProduct((Product)p)).orElse(null);
    }

    public List<IPaymentCodePool> getPaymentCodePools(ITreasuryEntity treasuryEntity) {
        FinantialInstitution finantialInstitution = ((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution();
        return finantialInstitution.getPaymentCodePoolsSet().stream().map(p -> new PaymentCodePoolImpl((PaymentCodePool)p)).collect(Collectors.toList());
    }

    public IPaymentCodePool getPaymentCodePoolByCode(String code) {
        if (FenixFramework.getDomainObject((String)code) == null) {
            throw new AcademicTreasuryDomainException("error.ITreasuryBridgeAPI.paymentCodePool.not.found", new String[0]);
        }
        return new PaymentCodePoolImpl((PaymentCodePool)FenixFramework.getDomainObject((String)code));
    }

    public IAcademicServiceRequestAndAcademicTaxTreasuryEvent academicTreasuryEventForAcademicServiceRequest(AcademicServiceRequest academicServiceRequest) {
        return academicServiceRequest.getAcademicTreasuryEvent();
    }

    public void standaloneUnenrolment(Enrolment standaloneEnrolment) {
        TuitionServices.removeDebitEntryForStandaloneEnrolment(standaloneEnrolment);
    }

    public void extracurricularUnenrolment(Enrolment extracurricularEnrolment) {
        TuitionServices.removeDebitEntryForExtracurricularEnrolment(extracurricularEnrolment);
    }

    public ITuitionTreasuryEvent getTuitionForRegistrationTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
    }

    public ITuitionTreasuryEvent getTuitionForStandaloneTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.findAcademicTreasuryEventTuitionForStandalone(registration, executionYear);
    }

    public ITuitionTreasuryEvent getTuitionForExtracurricularTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return null;
    }

    public ITuitionTreasuryEvent getTuitionForImprovementTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear);
    }

    public void improvementUnrenrolment(EnrolmentEvaluation improvementEnrolmentEvaluation) {
        AcademicTaxServices.removeDebitEntryForImprovement(improvementEnrolmentEvaluation);
    }

    public boolean isToPayTuition(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.isToPayRegistrationTuition(registration, executionYear);
    }

    public List<IAcademicTreasuryEvent> getAcademicTaxesList(Registration registration, ExecutionYear executionYear) {
        return AcademicTaxServices.findAllTreasuryEventsForAcademicTaxes(registration, executionYear);
    }

    public IImprovementTreasuryEvent getImprovementTaxTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        if (!AcademicTreasuryEvent.findUniqueForImprovementTuition(registration, executionYear).isPresent()) {
            return null;
        }
        return AcademicTreasuryEvent.findUniqueForImprovementTuition(registration, executionYear).get();
    }

    public IAcademicTreasuryEvent getAcademicTreasuryEventForTarget(IAcademicTreasuryTarget target) {
        Person person = target.getAcademicTreasuryTargetPerson();
        return AcademicTreasuryEvent.findUniqueForTarget(person, target).orElse(null);
    }

    public void anullDebtsForTarget(IAcademicTreasuryTarget target, String reason) {
        IAcademicTreasuryEvent event = this.getAcademicTreasuryEventForTarget(target);
        if (event != null) {
            event.annulDebts(reason);
        }
    }

    public IAcademicTreasuryEvent createDebt(ITreasuryEntity treasuryEntity, ITreasuryProduct treasuryProduct, IAcademicTreasuryTarget target, LocalDate when, boolean createPaymentCode, IPaymentCodePool paymentCodePool, int numberOfUnits, int numberOfPages) {
        AcademicTreasuryEvent treasuryEvent;
        DebtAccount debtAccount;
        FinantialInstitution finantialInstitution = ((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution();
        DocumentNumberSeries documentNumberSeries = (DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)finantialInstitution).get();
        DateTime now = new DateTime();
        Product product = ((AcademicProduct)treasuryProduct).product;
        Vat vat = (Vat)Vat.findActiveUnique((VatType)product.getVatType(), (FinantialInstitution)finantialInstitution, (DateTime)when.toDateTimeAtStartOfDay()).get();
        AdministrativeOffice administrativeOffice = ((TreasuryEntity)treasuryEntity).finantialEntity.getAdministrativeOffice();
        PaymentCodePool pool = ((PaymentCodePoolImpl)paymentCodePool).paymentCodePool;
        Person person = target.getAcademicTreasuryTargetPerson();
        PersonCustomer personCustomer = person.getPersonCustomer();
        if (personCustomer == null) {
            personCustomer = PersonCustomer.createWithCurrentFiscalInformation(person);
        }
        if ((debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).orElse(null)) == null) {
            debtAccount = DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer);
        }
        if ((treasuryEvent = (AcademicTreasuryEvent)this.getAcademicTreasuryEventForTarget(target)) == null) {
            treasuryEvent = AcademicTreasuryEvent.createForAcademicTreasuryEventTarget(product, target);
        }
        if (treasuryEvent.isCharged()) {
            return treasuryEvent;
        }
        AcademicTariff academicTariff = null;
        academicTariff = target.getAcademicTreasuryTargetDegree() != null ? AcademicTariff.findMatch(product, target.getAcademicTreasuryTargetDegree(), when.toDateTimeAtStartOfDay()) : AcademicTariff.findMatch(product, administrativeOffice, when.toDateTimeAtStartOfDay());
        LocalDate dueDate = academicTariff.dueDate(when);
        DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)documentNumberSeries, (DateTime)now);
        BigDecimal amount = academicTariff.amountToPay(numberOfUnits, numberOfPages);
        DebitEntry debitEntry = DebitEntry.create(Optional.of(debitNote), (DebtAccount)debtAccount, (TreasuryEvent)treasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, (Map)target.getAcademicTreasuryTargetPropertiesMap(), (Product)product, (String)target.getAcademicTreasuryTargetDescription().getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)BigDecimal.ONE, (InterestRate)academicTariff.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay());
        if (createPaymentCode) {
            this.createPaymentReferenceCode(pool, debitEntry, when, dueDate);
        }
        return treasuryEvent;
    }

    public IAcademicTreasuryEvent createDebt(ITreasuryEntity treasuryEntity, ITreasuryProduct treasuryProduct, IAcademicTreasuryTarget target, BigDecimal amount, LocalDate when, LocalDate dueDate, boolean createPaymentCode, IPaymentCodePool paymentCodePool) {
        AcademicTreasuryEvent treasuryEvent;
        DebtAccount debtAccount;
        FinantialInstitution finantialInstitution = ((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution();
        DocumentNumberSeries documentNumberSeries = (DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)finantialInstitution).get();
        DateTime now = new DateTime();
        Product product = ((AcademicProduct)treasuryProduct).product;
        Vat vat = (Vat)Vat.findActiveUnique((VatType)product.getVatType(), (FinantialInstitution)finantialInstitution, (DateTime)when.toDateTimeAtStartOfDay()).get();
        PaymentCodePool pool = ((PaymentCodePoolImpl)paymentCodePool).paymentCodePool;
        Person person = target.getAcademicTreasuryTargetPerson();
        PersonCustomer personCustomer = person.getPersonCustomer();
        if (personCustomer == null) {
            personCustomer = PersonCustomer.createWithCurrentFiscalInformation(person);
        }
        if ((debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).orElse(null)) == null) {
            debtAccount = DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer);
        }
        if ((treasuryEvent = (AcademicTreasuryEvent)this.getAcademicTreasuryEventForTarget(target)) == null) {
            treasuryEvent = AcademicTreasuryEvent.createForAcademicTreasuryEventTarget(product, target);
        }
        DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)documentNumberSeries, (DateTime)now);
        DebitEntry debitEntry = DebitEntry.create(Optional.of(debitNote), (DebtAccount)debtAccount, (TreasuryEvent)treasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, (Map)target.getAcademicTreasuryTargetPropertiesMap(), (Product)product, (String)target.getAcademicTreasuryTargetDescription().getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)BigDecimal.ONE, null, (DateTime)when.toDateTimeAtStartOfDay());
        if (createPaymentCode) {
            this.createPaymentReferenceCode(pool, debitEntry, when, dueDate);
        }
        return treasuryEvent;
    }

    private PaymentReferenceCode createPaymentReferenceCode(PaymentCodePool paymentCodePool, DebitEntry debitEntry, LocalDate when, LocalDate dueDate) {
        PaymentReferenceCode paymentReferenceCode = paymentCodePool.getReferenceCodeGenerator().generateNewCodeFor(debitEntry.getOpenAmount(), when, dueDate, true);
        paymentReferenceCode.createPaymentTargetTo((Set)Sets.newHashSet((Object[])new DebitEntry[]{debitEntry}), debitEntry.getOpenAmount());
        return paymentReferenceCode;
    }

    public boolean isAcademicalActsBlocked(Person person, LocalDate when) {
        return PersonServices.isAcademicalActsBlocked(person, when);
    }

    public boolean isAcademicalActBlockingSuspended(Person person, LocalDate when) {
        return AcademicActBlockingSuspension.isBlockingSuspended(person, when);
    }

    public List<IAcademicTreasuryEvent> getAllAcademicTreasuryEventsList(Person person) {
        return AcademicTreasuryEvent.find(person).collect(Collectors.toList());
    }

    public String getPersonAccountTreasuryManagementURL(Person person) {
        String countryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        return "/treasury/accounting/managecustomer/customer/read/" + PersonCustomer.findUnique(person, countryCode, fiscalNumber).get().getExternalId();
    }

    public boolean isPersonAccountTreasuryManagementAvailable(Person person) {
        String countryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        return PersonCustomer.findUnique(person, countryCode, fiscalNumber).isPresent();
    }

    public String getRegistrationAccountTreasuryManagementURL(Registration registration) {
        String fiscalNumber;
        String countryCode;
        if (registration.getDegree().getAdministrativeOffice().getFinantialEntity() == null) {
            return this.getPersonAccountTreasuryManagementURL(registration.getPerson());
        }
        FinantialInstitution inst = registration.getDegree().getAdministrativeOffice().getFinantialEntity().getFinantialInstitution();
        Person person = registration.getPerson();
        PersonCustomer customer = PersonCustomer.findUnique(person, countryCode = PersonCustomer.countryCode(person), fiscalNumber = PersonCustomer.fiscalNumber(person)).get();
        DebtAccount account = customer.getDebtAccountFor(inst);
        if (account != null) {
            return "/treasury/accounting/managecustomer/debtaccount/read/" + customer.getDebtAccountFor(inst).getExternalId();
        }
        return this.getPersonAccountTreasuryManagementURL(person);
    }

    public void createAcademicDebts(Registration registration) {
        AcademicDebtGenerationRule.runAllActiveForRegistration(registration, true);
    }

    @Subscribe
    public void handle(DomainObjectEvent<SettlementNote> settlementNoteEvent) {
        SettlementNote settlementNote = (SettlementNote)settlementNoteEvent.getInstance();
        boolean toReturn = true;
        try {
            toReturn = !FenixFramework.isDomainObjectValid((DomainObject)settlementNote);
        }
        catch (Throwable t) {
            toReturn = true;
        }
        if (toReturn) {
            return;
        }
        for (SettlementEntry s : settlementNote.getSettlemetEntries().collect(Collectors.toSet())) {
            AcademicTreasuryEvent academicTreasuryEvent;
            DebitEntry d;
            InvoiceEntry invoiceEntry = s.getInvoiceEntry();
            if (!(invoiceEntry instanceof DebitEntry) || (d = (DebitEntry)invoiceEntry).getTreasuryEvent() == null || !(d.getTreasuryEvent() instanceof AcademicTreasuryEvent) || !(academicTreasuryEvent = (AcademicTreasuryEvent)d.getTreasuryEvent()).isForTreasuryEventTarget()) continue;
            ((IAcademicTreasuryTarget)academicTreasuryEvent.getTreasuryEventTarget()).handleSettlement((IAcademicTreasuryEvent)academicTreasuryEvent);
        }
    }

    public boolean isValidFiscalNumber(String fiscalCountryCode, String fiscalNumber) {
        return FiscalCodeValidation.isValidFiscalNumber((String)fiscalCountryCode, (String)fiscalNumber);
    }

    public boolean updateCustomer(Person person, String fiscalCountryCode, String fiscalNumber) {
        return PersonCustomer.switchCustomer(person, fiscalCountryCode, fiscalNumber);
    }

    private static class PaymentCodePoolImpl
    implements IPaymentCodePool {
        private PaymentCodePool paymentCodePool;

        public PaymentCodePoolImpl(PaymentCodePool paymentCodePool) {
            this.paymentCodePool = paymentCodePool;
        }

        public String getCode() {
            return this.paymentCodePool.getExternalId();
        }

        public String getName() {
            return this.paymentCodePool.getName();
        }

        public boolean isActive() {
            return this.paymentCodePool.getActive() != null && this.paymentCodePool.getActive() != false;
        }

        public int hashCode() {
            return this.paymentCodePool.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof PaymentCodePoolImpl && ((PaymentCodePoolImpl)obj).paymentCodePool == this.paymentCodePool;
        }
    }

    private static class TreasuryEntity
    implements ITreasuryEntity {
        private FinantialEntity finantialEntity;

        public TreasuryEntity(FinantialEntity finantialEntity) {
            this.finantialEntity = finantialEntity;
        }

        public String getCode() {
            return this.finantialEntity.getExternalId();
        }

        public String getName() {
            return this.finantialEntity.getName().getContent();
        }

        public int hashCode() {
            return this.finantialEntity.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TreasuryEntity && ((TreasuryEntity)obj).finantialEntity == this.finantialEntity;
        }
    }

    private static class AcademicProduct
    implements ITreasuryProduct {
        private Product product;

        private AcademicProduct(Product product) {
            this.product = product;
        }

        public String getCode() {
            return this.product.getCode();
        }

        public String getName() {
            return this.product.getName().getContent();
        }

        public int hashCode() {
            return this.product.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AcademicProduct && ((AcademicProduct)obj).product == this.product;
        }
    }
}

