/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.integration.tuitioninfo;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoSettings;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType$callable$create;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType$callable$delete;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType$callable$edit;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType$callable$toogleActive;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoTypeAcademicEntry;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoTypeBean;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPTuitionInfoType
extends ERPTuitionInfoType_Base {
    public static final Comparator<ERPTuitionInfoType> COMPARE_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$toogleActive;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    public ERPTuitionInfoType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setErpTuitionInfoSettings(ERPTuitionInfoSettings.getInstance());
        this.setActive(true);
    }

    private ERPTuitionInfoType(ERPTuitionInfoTypeBean bean) {
        this();
        if (ERPTuitionInfoSettings.getInstance().isExportationActive()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.exportation.active", new String[0]);
        }
        this.setExecutionYear(bean.getExecutionYear());
        this.setErpTuitionInfoProduct(bean.getErpTuitionInfoProduct());
        this.getTuitionProductsSet().addAll(bean.getTuitionProducts());
        if (bean.getTuitionPaymentPlanGroup() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.TuitionPaymentPlanGroup.required.to.infer.academic.info", new String[0]);
        }
        this.addAcademicEntries(bean);
        this.checkRules();
    }

    private void addAcademicEntries(ERPTuitionInfoTypeBean bean) {
        if (bean.getTuitionPaymentPlanGroup().isForExtracurricular()) {
            ERPTuitionInfoTypeAcademicEntry.createForExtracurricularTuition(this);
        } else if (bean.getTuitionPaymentPlanGroup().isForStandalone()) {
            ERPTuitionInfoTypeAcademicEntry.createForStandaloneTuition(this);
        } else if (bean.getTuitionPaymentPlanGroup().isForRegistration()) {
            for (DegreeType degreeType : bean.getDegreeTypes()) {
                ERPTuitionInfoTypeAcademicEntry.createForRegistrationTuition(this, degreeType);
            }
            for (Degree degree : bean.getDegrees()) {
                ERPTuitionInfoTypeAcademicEntry.createForRegistrationTuition(this, degree);
            }
            for (DegreeCurricularPlan degreeCurricularPlan : bean.getDegreeCurricularPlans()) {
                ERPTuitionInfoTypeAcademicEntry.createForRegistrationTuition(this, degreeCurricularPlan);
            }
        }
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.bennu.required", new String[0]);
        }
        if (this.getExecutionYear() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.executionYear.required", new String[0]);
        }
        if (this.getTuitionProductsSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.tuitionProducts.required", new String[0]);
        }
        if (this.getErpTuitionInfoProduct() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.erpTuitionProduct.required", new String[0]);
        }
        ExecutionYear executionYear = this.getExecutionYear();
        if (this.getErpTuitionInfoProduct().getErpTuitionInfoTypesSet().stream().filter(t -> t.getExecutionYear() == executionYear).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.erpTuitionProduct.already.defined", new String[0]);
        }
        if (this.getErpTuitionInfoTypeAcademicEntriesSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.academic.entries.required", new String[0]);
        }
        for (ERPTuitionInfoTypeAcademicEntry entry : this.getErpTuitionInfoTypeAcademicEntriesSet()) {
            entry.checkRules();
        }
    }

    public void edit(ERPTuitionInfoTypeBean eRPTuitionInfoTypeBean) {
        Object object = advice$edit.perform((Callable)new ERPTuitionInfoType$callable$edit(this, eRPTuitionInfoTypeBean));
    }

    static /* synthetic */ void advised$edit(ERPTuitionInfoType this_, ERPTuitionInfoTypeBean bean) {
        if (ERPTuitionInfoSettings.getInstance().isExportationActive()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.exportation.active", new String[0]);
        }
        this_.getTuitionProductsSet().clear();
        this_.getTuitionProductsSet().addAll(bean.getTuitionProducts());
        while (!this_.getErpTuitionInfoTypeAcademicEntriesSet().isEmpty()) {
            ((ERPTuitionInfoTypeAcademicEntry)((Object)this_.getErpTuitionInfoTypeAcademicEntriesSet().iterator().next())).delete();
        }
        this_.addAcademicEntries(bean);
        this_.checkRules();
    }

    public boolean isActive() {
        return this.getActive();
    }

    public void toogleActive() {
        Object object = advice$toogleActive.perform((Callable)new ERPTuitionInfoType$callable$toogleActive(this));
    }

    static /* synthetic */ void advised$toogleActive(ERPTuitionInfoType this_) {
        if (ERPTuitionInfoSettings.getInstance().isExportationActive()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.exportation.active", new String[0]);
        }
        this_.setActive(!this_.getActive());
        this_.checkRules();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ERPTuitionInfoType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ERPTuitionInfoType this_) {
        if (ERPTuitionInfoSettings.getInstance().isExportationActive()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.exportation.active", new String[0]);
        }
        if (!this_.getErpTuitionInfosSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.delete.not.possible", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setErpTuitionInfoProduct(null);
        this_.setErpTuitionInfoSettings(null);
        this_.setExecutionYear(null);
        this_.getTuitionProductsSet().clear();
        while (!this_.getErpTuitionInfoTypeAcademicEntriesSet().isEmpty()) {
            ((ERPTuitionInfoTypeAcademicEntry)((Object)this_.getErpTuitionInfoTypeAcademicEntriesSet().iterator().next())).delete();
        }
        this_.deleteDomainObject();
    }

    public static Stream<ERPTuitionInfoType> findAll() {
        return ERPTuitionInfoSettings.getInstance().getErpTuitionInfoTypesSet().stream();
    }

    public static Stream<ERPTuitionInfoType> findActive() {
        return ERPTuitionInfoType.findAll().filter(e -> e.isActive());
    }

    public static Stream<? extends ERPTuitionInfoType> findForExecutionYear(ExecutionYear executionYear) {
        return executionYear.getErpTuitionInfoTypesSet().stream();
    }

    public static Stream<ERPTuitionInfoType> findActiveForExecutionYear(ExecutionYear executionYear) {
        return executionYear.getErpTuitionInfoTypesSet().stream().filter(e -> e.isActive());
    }

    public static Stream<ERPTuitionInfoType> findByCode(String code) {
        return ERPTuitionInfoType.findAll().filter(e -> e.getErpTuitionInfoProduct().getCode().equals(code));
    }

    public static Optional<ERPTuitionInfoType> findUniqueByCode(String code) {
        return ERPTuitionInfoType.findAll().filter(e -> e.getErpTuitionInfoProduct().getCode().equals(code)).findFirst();
    }

    public static ERPTuitionInfoType create(ERPTuitionInfoTypeBean eRPTuitionInfoTypeBean) {
        return (ERPTuitionInfoType)((Object)advice$create.perform((Callable)new ERPTuitionInfoType$callable$create(eRPTuitionInfoTypeBean)));
    }

    static /* synthetic */ ERPTuitionInfoType advised$create(ERPTuitionInfoTypeBean bean) {
        return new ERPTuitionInfoType(bean);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$toogleActive = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = new Comparator<ERPTuitionInfoType>(){

            @Override
            public int compare(ERPTuitionInfoType o1, ERPTuitionInfoType o2) {
                int c = o1.getErpTuitionInfoProduct().getName().compareTo(o2.getErpTuitionInfoProduct().getName());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

