/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituation_Base;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.dto.academicservicerequest.AcademicServiceRequestDebitEntryBean;
import org.fenixedu.academictreasury.services.EmolumentServices$callable$calculateForAcademicServiceRequest;
import org.fenixedu.academictreasury.services.EmolumentServices$callable$createAcademicServiceRequestEmolument;
import org.fenixedu.academictreasury.services.EmolumentServices$callable$createAcademicServiceRequestEmolument$1;
import org.fenixedu.academictreasury.services.EmolumentServices$callable$createEmolument;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EmolumentServices {
    public static final Advice advice$createEmolument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$calculateForAcademicServiceRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicServiceRequestEmolument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAcademicServiceRequestEmolument$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Product createEmolument(String string, LocalizedString localizedString, VatType vatType, FinantialInstitution finantialInstitution) {
        return (Product)advice$createEmolument.perform((Callable)new EmolumentServices$callable$createEmolument(string, localizedString, vatType, finantialInstitution));
    }

    static /* synthetic */ Product advised$createEmolument(String code, LocalizedString name, VatType vatType, FinantialInstitution finantialInstitution) {
        if (AcademicTreasurySettings.getInstance().getEmolumentsProductGroup() == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.emoluments.product.group.not.defined", new String[0]);
        }
        return Product.create((ProductGroup)AcademicTreasurySettings.getInstance().getEmolumentsProductGroup(), (String)code, (LocalizedString)name, (LocalizedString)Product.defaultUnitOfMeasure(), (boolean)true, (boolean)false, (int)0, (VatType)vatType, Collections.singletonList(finantialInstitution), null);
    }

    public static Stream<Product> findEmoluments(FinantialEntity finantialEntity) {
        if (AcademicTreasurySettings.getInstance().getEmolumentsProductGroup() == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.emoluments.product.group.not.defined", new String[0]);
        }
        return AcademicTreasurySettings.getInstance().getEmolumentsProductGroup().getProductsSet().stream().filter(l -> l.getFinantialInstitutionsSet().contains(finantialEntity.getFinantialInstitution()));
    }

    @Subscribe
    public void newAcademicServiceRequestSituationEvent(DomainObjectEvent<AcademicServiceRequest> event) {
        this.newAcademicServiceRequestSituationEvent((AcademicServiceRequest)event.getInstance());
    }

    public boolean newAcademicServiceRequestSituationEvent(AcademicServiceRequest academicServiceRequest) {
        if (!(academicServiceRequest instanceof ITreasuryServiceRequest)) {
            return false;
        }
        ITreasuryServiceRequest iTreasuryServiceRequest = (ITreasuryServiceRequest)academicServiceRequest;
        if (!iTreasuryServiceRequest.getServiceRequestType().isPayable()) {
            return false;
        }
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        if (serviceRequestMapEntry == null) {
            return false;
        }
        if (!academicServiceRequest.getAcademicServiceRequestSituationsSet().stream().map(AcademicServiceRequestSituation_Base::getAcademicServiceRequestSituationType).collect(Collectors.toSet()).contains(serviceRequestMapEntry.getCreateEventOnSituation())) {
            return false;
        }
        return EmolumentServices.createAcademicServiceRequestEmolument(iTreasuryServiceRequest);
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEvent(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return AcademicTreasuryEvent.findUnique(iTreasuryServiceRequest).orElse(null);
    }

    public static AcademicTariff findTariffForAcademicServiceRequest(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate when) {
        Degree degree = iTreasuryServiceRequest.getRegistration().getDegree();
        CycleType cycleType = iTreasuryServiceRequest.getCycleType();
        Product product = ServiceRequestMapEntry.findProduct(iTreasuryServiceRequest);
        return iTreasuryServiceRequest.hasCycleType() ? AcademicTariff.findMatch(product, degree, cycleType, when.toDateTimeAtStartOfDay()) : AcademicTariff.findMatch(product, degree, when.toDateTimeAtStartOfDay());
    }

    public static AcademicServiceRequestDebitEntryBean calculateForAcademicServiceRequest(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate localDate) {
        return (AcademicServiceRequestDebitEntryBean)advice$calculateForAcademicServiceRequest.perform((Callable)new EmolumentServices$callable$calculateForAcademicServiceRequest(iTreasuryServiceRequest, localDate));
    }

    static /* synthetic */ AcademicServiceRequestDebitEntryBean advised$calculateForAcademicServiceRequest(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate debtDate) {
        PersonCustomer personCustomer;
        if (!iTreasuryServiceRequest.getServiceRequestType().isPayable()) {
            return null;
        }
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        if (serviceRequestMapEntry == null) {
            return null;
        }
        Person person = iTreasuryServiceRequest.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
        }
        AcademicTariff academicTariff = EmolumentServices.findTariffForAcademicServiceRequest(iTreasuryServiceRequest, debtDate);
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.tariff.not.found", debtDate.toString("dd/MM/yyyy"));
        }
        FinantialEntity finantialEntity = academicTariff.getFinantialEntity();
        FinantialInstitution finantialInstitution = finantialEntity.getFinantialInstitution();
        if (!DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).isPresent()) {
            DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer);
        }
        if (EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest) == null) {
            AcademicTreasuryEvent.createForAcademicServiceRequest(iTreasuryServiceRequest);
        }
        AcademicTreasuryEvent academicTreasuryEvent = EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest);
        LocalizedString debitEntryName = academicTariff.academicServiceRequestDebitEntryName(academicTreasuryEvent);
        LocalDate dueDate = academicTariff.dueDate(debtDate);
        Vat vat = academicTariff.vat(debtDate);
        BigDecimal amount = academicTariff.amountToPay(academicTreasuryEvent);
        return new AcademicServiceRequestDebitEntryBean(debitEntryName, dueDate, vat.getTaxRate(), amount);
    }

    public static boolean createAcademicServiceRequestEmolument(ITreasuryServiceRequest iTreasuryServiceRequest) {
        return (Boolean)advice$createAcademicServiceRequestEmolument.perform((Callable)new EmolumentServices$callable$createAcademicServiceRequestEmolument(iTreasuryServiceRequest));
    }

    static /* synthetic */ boolean advised$createAcademicServiceRequestEmolument(ITreasuryServiceRequest iTreasuryServiceRequest) {
        LocalDate when = EmolumentServices.possibleDebtDateOnAcademicService(iTreasuryServiceRequest);
        return EmolumentServices.createAcademicServiceRequestEmolument(iTreasuryServiceRequest, when);
    }

    public static boolean createAcademicServiceRequestEmolument(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate localDate) {
        return (Boolean)advice$createAcademicServiceRequestEmolument$1.perform((Callable)new EmolumentServices$callable$createAcademicServiceRequestEmolument$1(iTreasuryServiceRequest, localDate));
    }

    static /* synthetic */ boolean advised$createAcademicServiceRequestEmolument(ITreasuryServiceRequest iTreasuryServiceRequest, LocalDate when) {
        DebtAccount personDebtAccount;
        DebitEntry debitEntry;
        AcademicTreasuryEvent academicTresuryEvent;
        PersonCustomer personCustomer;
        if (!iTreasuryServiceRequest.getServiceRequestType().isPayable()) {
            return false;
        }
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        if (serviceRequestMapEntry == null) {
            return false;
        }
        Person person = iTreasuryServiceRequest.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", new String[0]);
        }
        AcademicTariff academicTariff = EmolumentServices.findTariffForAcademicServiceRequest(iTreasuryServiceRequest, when);
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.tariff.not.found", when.toString("dd/MM/yyyy"));
        }
        FinantialEntity finantialEntity = academicTariff.getFinantialEntity();
        FinantialInstitution finantialInstitution = finantialEntity.getFinantialInstitution();
        if (!DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).isPresent()) {
            DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer);
        }
        if (EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest) == null) {
            AcademicTreasuryEvent.createForAcademicServiceRequest(iTreasuryServiceRequest);
        }
        if ((academicTresuryEvent = EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest)).isChargedWithDebitEntry()) {
            BigDecimal newTotalAmount;
            BigDecimal oldtotalAmount = academicTresuryEvent.getAmountToPay().add(academicTresuryEvent.getCreditAmount()).add(DebitEntry.findActive((TreasuryEvent)academicTresuryEvent).map(l -> l.getExemptedAmount()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
            if (org.fenixedu.treasury.util.Constants.isEqual((BigDecimal)oldtotalAmount, (BigDecimal)(newTotalAmount = academicTariff.amountToPay(academicTresuryEvent)))) {
                return false;
            }
            String reason = Constants.academicTreasuryBundle("info.EmolumentServices.serviceRequest.change.value.anull.debit.entries", new String[0]);
            academicTresuryEvent.annulAllDebitEntries(reason);
        }
        if ((debitEntry = academicTariff.createDebitEntryForAcademicServiceRequest(personDebtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).orElse(null), academicTresuryEvent)) == null) {
            return false;
        }
        if (org.fenixedu.treasury.util.Constants.isEqual((BigDecimal)debitEntry.getOpenAmount(), (BigDecimal)BigDecimal.ZERO)) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.academicServiceRequest.amount.equals.to.zero", new String[0]);
        }
        DebitNote debitNote = DebitNote.create((DebtAccount)personDebtAccount, (DocumentNumberSeries)((DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)personDebtAccount.getFinantialInstitution()).get()), (DateTime)new DateTime());
        debitNote.addDebitNoteEntries(Collections.singletonList(debitEntry));
        if (AcademicTreasurySettings.getInstance().isCloseServiceRequestEmolumentsWithDebitNote()) {
            debitNote.closeDocument();
        }
        if (serviceRequestMapEntry.getGeneratePaymentCode()) {
            PaymentCodePool pool = serviceRequestMapEntry.getPaymentCodePool();
            if (pool == null) {
                throw new AcademicTreasuryDomainException("error.EmolumentServices.academicServiceRequest.paymentCodePool.is.required", new String[0]);
            }
            LocalDate dueDate = academicTresuryEvent.getDueDate();
            LocalDate now = new LocalDate();
            PaymentReferenceCode referenceCode = pool.getReferenceCodeGenerator().generateNewCodeFor(academicTresuryEvent.getRemainingAmountToPay(), now, dueDate.compareTo((ReadablePartial)now) > 0 ? dueDate : now, true);
            referenceCode.createPaymentTargetTo((Set)Sets.newHashSet((Object[])new DebitEntry[]{debitEntry}), debitEntry.getOpenAmount());
        }
        return true;
    }

    public static LocalDate possibleDebtDateOnAcademicService(ITreasuryServiceRequest iTreasuryServiceRequest) {
        if (!iTreasuryServiceRequest.getServiceRequestType().isPayable()) {
            return null;
        }
        ServiceRequestMapEntry serviceRequestMapEntry = ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest);
        if (serviceRequestMapEntry == null) {
            return null;
        }
        AcademicServiceRequestSituationType createEventOnSituation = serviceRequestMapEntry.getCreateEventOnSituation();
        if (iTreasuryServiceRequest.getSituationByType(createEventOnSituation) == null) {
            return iTreasuryServiceRequest.getRequestDate().toLocalDate();
        }
        return iTreasuryServiceRequest.getSituationByType(createEventOnSituation).getSituationDate().toLocalDate();
    }

    public static boolean removeDebitEntryForAcademicService(ITreasuryServiceRequest iTreasuryServiceRequest) {
        if (EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest);
        if (!academicTreasuryEvent.isChargedWithDebitEntry()) {
            return false;
        }
        DebitEntry debitEntry = academicTreasuryEvent.findActiveAcademicServiceRequestDebitEntry().get();
        DebitNote debitNote = (DebitNote)debitEntry.getFinantialDocument();
        if (!debitEntry.isProcessedInDebitNote()) {
            debitEntry.annulDebitEntry(Constants.academicTreasuryBundle("label.EmolumentServices.removeDebitEntryForAcademicService.reason", new String[0]));
            debitEntry.delete();
            return true;
        }
        if (debitEntry.getCreditEntriesSet().isEmpty()) {
            debitNote.anullDebitNoteWithCreditNote(Constants.academicTreasuryBundle("label.EmolumentServices.removeDebitEntryForAcademicService.reason", new String[0]), false);
            return true;
        }
        return false;
    }
}

