/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AbstractReportEntryBean;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;

public class ProductReportEntryBean
extends AbstractReportEntryBean {
    public static final String[] SPREADSHEET_HEADERS = new String[]{Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.identification", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.group.code", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.group", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.code", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.description.pt", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.description.en", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.unitOfMeasure.pt", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.unitOfMeasure.en", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.active", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.legacy", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.tuitionInstallmentOrder", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.vatType.code", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.vatType", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.exemptionReason.code", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.exemptionReason", new String[0]), Constants.academicTreasuryBundle("label.ProductReportEntryBean.header.finantialInstitution", new String[0])};
    private String identification;
    private String groupCode;
    private String group;
    private String code;
    private String descriptionPt;
    private String descriptionEn;
    private String unitOfMeasurePt;
    private String unitOfMeasureEn;
    private boolean active;
    private boolean legacy;
    private int tuitionInstallmentOrder;
    private String vatTypeCode;
    private String vatType;
    private String exemptionReasonCode;
    private String exemptionReason;
    private String finantialInstitution;
    private Product product;
    boolean completed = false;

    public ProductReportEntryBean(Product p, DebtReportRequest request, ErrorsLog errorsLog) {
        this.product = p;
        try {
            this.identification = p.getExternalId();
            this.groupCode = p.getProductGroup() != null ? p.getProductGroup().getCode() : "";
            this.group = p.getProductGroup().getName().getContent();
            this.code = p.getCode();
            this.descriptionPt = p.getName().getContent(Constants.DEFAULT_LANGUAGE);
            this.descriptionEn = p.getName().getContent(Constants.ENGLISH_LANGUAGE);
            this.unitOfMeasurePt = p.getUnitOfMeasure().getContent(Constants.DEFAULT_LANGUAGE);
            this.unitOfMeasureEn = p.getUnitOfMeasure().getContent(Constants.ENGLISH_LANGUAGE);
            this.active = p.isActive();
            this.legacy = p.isLegacy();
            this.tuitionInstallmentOrder = p.getTuitionInstallmentOrder();
            this.vatTypeCode = p.getVatType() != null ? p.getVatType().getCode() : "";
            this.vatType = p.getVatType() != null ? p.getVatType().getName().getContent() : "";
            this.exemptionReasonCode = p.getVatExemptionReason() != null ? p.getVatExemptionReason().getCode() : "";
            this.exemptionReason = p.getVatExemptionReason() != null ? p.getVatExemptionReason().getName().getContent() : "";
            this.finantialInstitution = !p.getFinantialInstitutionsSet().isEmpty() ? ((FinantialInstitution)p.getFinantialInstitutionsSet().iterator().next()).getFiscalNumber() : "";
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.product, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(Constants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.groupCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.group));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.code));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.descriptionPt));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.descriptionEn));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.unitOfMeasurePt));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.unitOfMeasureEn));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.active));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.legacy));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.tuitionInstallmentOrder));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatTypeCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.exemptionReasonCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.exemptionReason));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.finantialInstitution));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.product, e);
        }
    }
}

