/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports.task;

import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.dto.reports.DebtReportRequestBean;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

@Task(englishTitle="Register debt report request to generate report", readOnly=true)
public class RegisterDebtReportRequestTask
extends CronTask {
    private static final int MAX_REPORTS_DAY = 3;

    public void runTask() throws Exception {
        LocalDate now = new LocalDate();
        if (DebtReportRequest.findAll().filter(r -> r.getVersioningCreationDate().toLocalDate().compareTo((ReadablePartial)now) == 0).count() >= 3L) {
            this.taskLog("Exceeded the report requests %d. Please request explicitly.\n", new Object[]{3});
            return;
        }
        this.taskLog("Requesting a new debt report", new Object[0]);
        DebtReportRequestBean bean = new DebtReportRequestBean();
        bean.setBeginDate(new LocalDate(1950, 1, 1));
        bean.setEndDate(now);
        bean.setDecimalSeparator(",");
        bean.setIncludeAnnuledEntries(true);
        DebtReportRequest.create(bean);
    }
}

