/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports;

import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultErrorsFile_Base;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.joda.time.DateTime;

public class DebtReportRequestResultErrorsFile
extends DebtReportRequestResultErrorsFile_Base {
    protected DebtReportRequestResultErrorsFile(DebtReportRequest request, byte[] content) {
        this.setBennu(Bennu.getInstance());
        this.setDebtReportRequest(request);
        String filename = Constants.academicTreasuryBundle("label.DebtReportRequestResultErrorsFile.filename", new DateTime().toString("YYYYMMddHHmmss"));
        this.init(filename, filename, content);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDebtReportRequest() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequestResultErrorsFile.debtReportRequest.required", new String[0]);
        }
    }

    public boolean isAccessible(User user) {
        return TreasuryAccessControlAPI.isBackOfficeMember((User)user);
    }

    public static DebtReportRequestResultErrorsFile create(DebtReportRequest request, byte[] content) {
        return new DebtReportRequestResultErrorsFile(request, content);
    }
}

