/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.importation;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportFile$callable$create;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportFile_Base;
import org.fenixedu.academictreasury.domain.importation.TreasuryImportType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryImportFile
extends TreasuryImportFile_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected TreasuryImportFile() {
        this.setBennu(Bennu.getInstance());
    }

    protected TreasuryImportFile(TreasuryImportType type, String filename, byte[] content) {
        this();
        this.init(filename, filename, content);
        this.setTreasuryImportType(type);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTreasuryImportType() == null) {
            throw new AcademicTreasuryDomainException("error.TreasuryImportFile.type.required", new String[0]);
        }
    }

    public boolean isAccessible(User user) {
        return TreasuryAccessControlAPI.isBackOfficeMember((User)user);
    }

    public boolean isProcessed() {
        return this.getWhenProcessed() != null;
    }

    public static Stream<TreasuryImportFile> findAll() {
        return Bennu.getInstance().getTreasuryImportFilesSet().stream();
    }

    public static TreasuryImportFile create(TreasuryImportType treasuryImportType, String string, byte[] byArray) {
        return (TreasuryImportFile)((Object)advice$create.perform((Callable)new TreasuryImportFile$callable$create(treasuryImportType, string, byArray)));
    }

    static /* synthetic */ TreasuryImportFile advised$create(TreasuryImportType type, String filename, byte[] content) {
        return new TreasuryImportFile(type, filename, content);
    }
}

