/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreatePaymentReferencesStrategy$callable$process;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreatePaymentReferencesStrategy$callable$process$1;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CreatePaymentReferencesStrategy$callable$processDebtsForRegistration;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry_Base;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreatePaymentReferencesStrategy
implements IAcademicDebtGenerationRuleStrategy {
    private static Logger logger;
    private static final List<String> MESSAGES_TO_IGNORE;
    public static final Advice advice$process;
    public static final Advice advice$process$1;
    public static final Advice advice$processDebtsForRegistration;

    @Override
    public boolean isAppliedOnTuitionDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnAcademicTaxDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnOtherDebitEntries() {
        return true;
    }

    @Override
    public boolean isToCreateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToAggregateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCloseDebitNote() {
        return false;
    }

    @Override
    public boolean isToCreatePaymentReferenceCodes() {
        return true;
    }

    @Override
    public boolean isEntriesRequired() {
        return true;
    }

    @Override
    public boolean isToAlignAcademicTaxesDueDate() {
        return true;
    }

    @Override
    public void process(AcademicDebtGenerationRule academicDebtGenerationRule) {
        Object object = advice$process.perform((Callable)new CreatePaymentReferencesStrategy$callable$process(this, academicDebtGenerationRule));
    }

    static /* synthetic */ void advised$process(CreatePaymentReferencesStrategy this_, AcademicDebtGenerationRule rule) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        for (DegreeCurricularPlan degreeCurricularPlan : rule.getDegreeCurricularPlansSet()) {
            for (Registration registration : degreeCurricularPlan.getRegistrations()) {
                if (registration.getStudentCurricularPlan(rule.getExecutionYear()) == null || !rule.getDegreeCurricularPlansSet().contains(registration.getStudentCurricularPlan(rule.getExecutionYear()).getDegreeCurricularPlan())) continue;
                try {
                    this_.processDebtsForRegistration(rule, registration);
                }
                catch (AcademicTreasuryDomainException e) {
                    if (MESSAGES_TO_IGNORE.contains(e.getMessage())) continue;
                    logger.debug(e.getMessage());
                }
                catch (TreasuryDomainException e) {
                    logger.debug(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void process(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        Object object = advice$process$1.perform((Callable)new CreatePaymentReferencesStrategy$callable$process$1(this, academicDebtGenerationRule, registration));
    }

    static /* synthetic */ void advised$process(CreatePaymentReferencesStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        if (rule.getDebtGenerationRuleRestriction() != null && !rule.getDebtGenerationRuleRestriction().strategyImplementation().isToApply(rule, registration)) {
            return;
        }
        if (registration.getStudentCurricularPlan(rule.getExecutionYear()) == null) {
            return;
        }
        if (!rule.getDegreeCurricularPlansSet().contains(registration.getStudentCurricularPlan(rule.getExecutionYear()).getDegreeCurricularPlan())) {
            return;
        }
        this_.processDebtsForRegistration(rule, registration);
    }

    private void processDebtsForRegistration(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        Object object = advice$processDebtsForRegistration.perform((Callable)new CreatePaymentReferencesStrategy$callable$processDebtsForRegistration(this, academicDebtGenerationRule, registration));
    }

    static /* synthetic */ void advised$processDebtsForRegistration(CreatePaymentReferencesStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        if (rule.getDebtGenerationRuleRestriction() != null && !rule.getDebtGenerationRuleRestriction().strategyImplementation().isToApply(rule, registration)) {
            return;
        }
        Set<DebitEntry> debitEntries = CreatePaymentReferencesStrategy.grabDebitEntries(rule, registration);
        if (!Sets.difference(rule.getAcademicDebtGenerationRuleEntriesSet().stream().map(e -> e.getProduct()).collect(Collectors.toSet()), debitEntries.stream().map(d -> d.getProduct()).collect(Collectors.toSet())).isEmpty()) {
            return;
        }
        if (debitEntries.stream().filter(d -> d.getFinantialDocument() == null || d.getFinantialDocument().isAnnulled()).count() > 0L) {
            DebitEntry debitEntryWithoutDebitNote = (DebitEntry)debitEntries.stream().filter(d -> d.getFinantialDocument() == null || d.getFinantialDocument().isAnnulled()).iterator().next();
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.debitEntry.with.none.or.annuled.finantial.document", debitEntryWithoutDebitNote.getDescription());
        }
        if (MultipleEntriesPaymentCode.findUsedByDebitEntriesSet(debitEntries).count() > 0L || MultipleEntriesPaymentCode.findNewByDebitEntriesSet(debitEntries).count() > 0L) {
            return;
        }
        Currency currency = debitEntries.iterator().next().getDebtAccount().getFinantialInstitution().getCurrency();
        BigDecimal amount = debitEntries.stream().map(d -> d.getOpenAmount()).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
        PaymentReferenceCode paymentCode = rule.getPaymentCodePool().getReferenceCodeGenerator().generateNewCodeFor(currency.getValueWithScale(amount), new LocalDate(), this_.maxDebitEntryDueDate(debitEntries), false);
        paymentCode.createPaymentTargetTo(debitEntries, amount);
        if (rule.getAcademicTaxDueDateAlignmentType() != null) {
            rule.getAcademicTaxDueDateAlignmentType().applyDueDate(rule, debitEntries);
        }
    }

    public static Set<DebitEntry> grabDebitEntries(AcademicDebtGenerationRule rule, Registration registration) {
        HashSet debitEntries = Sets.newHashSet();
        for (AcademicDebtGenerationRuleEntry entry : rule.getAcademicDebtGenerationRuleEntriesSet()) {
            Product product = entry.getProduct();
            DebitEntry grabbedDebitEntry = null;
            grabbedDebitEntry = AcademicTreasurySettings.getInstance().getTuitionProductGroup() == product.getProductGroup() ? CreatePaymentReferencesStrategy.grabDebitEntryForTuition(rule, registration, entry) : (AcademicTax.findUnique(product).isPresent() ? CreatePaymentReferencesStrategy.grabDebitEntryForAcademicTax(rule, registration, entry) : CreatePaymentReferencesStrategy.grabDebitEntry(rule, registration, entry));
            if (grabbedDebitEntry == null) continue;
            debitEntries.add(grabbedDebitEntry);
        }
        return debitEntries;
    }

    private static DebitEntry grabDebitEntryForAcademicTax(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        AcademicTax academicTax;
        PersonCustomer customer = registration.getPerson().getPersonCustomer();
        if (customer == null) {
            return null;
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax = AcademicTax.findUnique(product).get());
        if (t != null && t.isChargedWithDebitEntry()) {
            return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t).filter(d -> d.isInDebt()).findFirst().orElse(null);
        }
        return null;
    }

    private static DebitEntry grabDebitEntryForTuition(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        PersonCustomer customer = registration.getPerson().getPersonCustomer();
        if (customer == null) {
            return null;
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        if (TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear) == null) {
            return null;
        }
        AcademicTreasuryEvent t = TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
        if (!t.isChargedWithDebitEntry(product)) {
            return null;
        }
        return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t, product).filter(d -> d.isInDebt()).findFirst().orElse(null);
    }

    private static DebitEntry grabDebitEntry(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == entry.getProduct().getProductGroup()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.entry.is.tuition", new String[0]);
        }
        if (AcademicTax.findUnique(entry.getProduct()).isPresent()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.entry.is.academicTax", new String[0]);
        }
        FinantialEntity finantialEntity = registration.getDegree().getAdministrativeOffice().getFinantialEntity();
        if (finantialEntity == null) {
            return null;
        }
        if (registration.getPerson().getPersonCustomer() == null) {
            return null;
        }
        PersonCustomer personCustomer = registration.getPerson().getPersonCustomer();
        if (!DebtAccount.findUnique((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
            return null;
        }
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialEntity.getFinantialInstitution(), (Customer)personCustomer).get();
        for (DebitEntry debitEntry : DebitEntry.findActive((DebtAccount)debtAccount, (Product)entry.getProduct()).collect(Collectors.toSet())) {
            if (!debitEntry.isInDebt() || debitEntry.isAnnulled()) continue;
            return debitEntry;
        }
        return null;
    }

    private LocalDate maxDebitEntryDueDate(Set<DebitEntry> debitEntries) {
        LocalDate maxDate = debitEntries.stream().max(DebitEntry.COMPARE_BY_DUE_DATE).map(DebitEntry_Base::getDueDate).orElse(new LocalDate());
        return maxDate.isAfter((ReadablePartial)new LocalDate()) ? maxDate : new LocalDate();
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$process$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$processDebtsForRegistration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(CreatePaymentReferencesStrategy.class);
        MESSAGES_TO_IGNORE = Lists.newArrayList((Object[])new String[]{"error.AcademicDebtGenerationRule.debitEntry.with.none.or.annuled.finantial.document"});
    }
}

