/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.customer;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer$callable$changeFiscalNumber;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer$callable$create;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer$callable$delete;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer_Base;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalDataUpdateLog;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.dto.AdhocCustomerBean;
import org.fenixedu.treasury.util.Constants;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PersonCustomer
extends PersonCustomer_Base {
    private static final String STUDENT_CODE = "STUDENT";
    private static final String CANDIDACY_CODE = "CANDIDATE";
    private static final Comparator<PersonCustomer> SORT_BY_PERSON_MERGE;
    public static final Advice advice$delete;
    public static final Advice advice$changeFiscalNumber;
    public static final Advice advice$create;

    protected PersonCustomer() {
    }

    protected PersonCustomer(Person person, String fiscalCountry, String fiscalNumber) {
        this();
        if (!"999999990".equals(this.getFiscalNumber()) && PersonCustomer.find(this.getPerson(), this.getFiscalCountry(), this.getFiscalNumber()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.customer.duplicated", new String[0]);
        }
        this.setPerson(person);
        this.setCustomerType(PersonCustomer.getDefaultCustomerType(this));
        super.setCountryCode(fiscalCountry);
        super.setFiscalNumber(fiscalNumber);
        if (!FiscalCodeValidation.isValidFiscalNumber((String)this.getCountryCode(), (String)this.getFiscalNumber())) {
            throw new AcademicTreasuryDomainException("error.Customer.fiscal.information.invalid", new String[0]);
        }
        this.checkRules();
        for (FinantialInstitution finantialInstitution : FinantialInstitution.findAll().collect(Collectors.toSet())) {
            DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)this);
        }
    }

    protected void checkRules() {
        Person person;
        super.checkRules();
        if (this.getPerson() == null && this.getPersonForInactivePersonCustomer() == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getCountryCode())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.countryCode", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getFiscalNumber())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalNumber", new String[0]);
        }
        if (this.getPerson() != null && this.getPersonForInactivePersonCustomer() != null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.may.only.be.related.to.person.with.one.relation", new String[0]);
        }
        if ("999999990".equals(this.getFiscalNumber()) && !Constants.isDefaultCountry((String)this.getFiscalCountry())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.default.fiscal.number.applied.only.to.default.country", new String[0]);
        }
        Person person2 = person = this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
        if (!"999999990".equals(this.getFiscalNumber()) && PersonCustomer.find(person, this.getFiscalCountry(), this.getFiscalNumber()).filter(pc -> !pc.isFromPersonMerge()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.person.customer.duplicated", new String[0]);
        }
    }

    public String getCode() {
        return this.getExternalId();
    }

    public Person getAssociatedPerson() {
        return this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
    }

    public static String fiscalNumber(Person person) {
        return person.getSocialSecurityNumber();
    }

    public String getName() {
        return this.getAssociatedPerson().getName();
    }

    public String getFirstNames() {
        return this.getAssociatedPerson().getProfile().getGivenNames();
    }

    public String getLastNames() {
        return this.getAssociatedPerson().getProfile().getFamilyNames();
    }

    public String getEmail() {
        return this.getAssociatedPerson().getDefaultEmailAddressValue();
    }

    public String getPhoneNumber() {
        Person person = this.getAssociatedPerson();
        if (!Strings.isNullOrEmpty((String)person.getDefaultPhoneNumber())) {
            return person.getDefaultPhoneNumber();
        }
        return person.getDefaultMobilePhoneNumber();
    }

    public String getMobileNumber() {
        return this.getAssociatedPerson().getDefaultMobilePhoneNumber();
    }

    public String getIdentificationNumber() {
        return PersonCustomer.identificationNumber(this.getAssociatedPerson());
    }

    public static String identificationNumber(Person person) {
        return person.getDocumentIdNumber();
    }

    private PhysicalAddress getPhysicalAddress() {
        return PersonCustomer.physicalAddress(this.getAssociatedPerson());
    }

    public static PhysicalAddress physicalAddress(Person person) {
        if (person.getDefaultPhysicalAddress() != null) {
            return person.getDefaultPhysicalAddress();
        }
        if (person.getPendingOrValidPhysicalAddresses().size() == 1) {
            return (PhysicalAddress)person.getPendingOrValidPhysicalAddresses().get(0);
        }
        return null;
    }

    public String getAddress() {
        if (this.getPhysicalAddress() == null) {
            return null;
        }
        return this.getPhysicalAddress().getAddress();
    }

    public String getDistrictSubdivision() {
        if (this.getPhysicalAddress() == null) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)this.getPhysicalAddress().getArea())) {
            return this.getPhysicalAddress().getArea();
        }
        if (!Strings.isNullOrEmpty((String)this.getPhysicalAddress().getDistrictSubdivisionOfResidence())) {
            return this.getPhysicalAddress().getDistrictSubdivisionOfResidence();
        }
        if (!Strings.isNullOrEmpty((String)this.getPhysicalAddress().getDistrictOfResidence())) {
            return this.getPhysicalAddress().getDistrictOfResidence();
        }
        return null;
    }

    public String getDistrict() {
        if (this.getPhysicalAddress() == null) {
            return null;
        }
        return this.getPhysicalAddress().getDistrictOfResidence();
    }

    public String getZipCode() {
        if (this.getPhysicalAddress() == null) {
            return null;
        }
        return this.getPhysicalAddress().getAreaCode();
    }

    public String getAddressCountryCode() {
        if (this.getPhysicalAddress() == null) {
            return null;
        }
        if (this.getPhysicalAddress().getCountryOfResidence() == null) {
            return null;
        }
        return this.getPhysicalAddress().getCountryOfResidence().getCode();
    }

    public static String countryCode(Person person) {
        return person.getFiscalCountry() != null ? person.getFiscalCountry().getCode() : null;
    }

    public static String countryCode(PersonBean personBean) {
        if (personBean == null) {
            return null;
        }
        if (personBean.getFiscalCountry() == null) {
            return null;
        }
        return personBean.getFiscalCountry().getCode();
    }

    public static boolean isValidFiscalNumber(Person person) {
        return FiscalCodeValidation.isValidFiscalNumber((String)PersonCustomer.countryCode(person), (String)PersonCustomer.fiscalNumber(person));
    }

    public String getNationalityCountryCode() {
        Person person = this.getAssociatedPerson();
        if (person.getCountry() != null) {
            return person.getCountry().getCode();
        }
        return null;
    }

    public String getBusinessIdentification() {
        Person person = this.getAssociatedPerson();
        if (person.getStudent() != null) {
            return person.getStudent().getNumber().toString();
        }
        return this.getIdentificationNumber();
    }

    public String getFiscalCountry() {
        return this.getCountryCode();
    }

    public String getPaymentReferenceBaseCode() {
        return this.getCode();
    }

    public boolean isPersonCustomer() {
        return true;
    }

    public boolean isActive() {
        return this.getPerson() != null;
    }

    public boolean isFromPersonMerge() {
        return this.getFromPersonMerge();
    }

    public boolean isDeletable() {
        return this.getDebtAccountsSet().stream().allMatch(da -> da.isDeletable());
    }

    public Customer getActiveCustomer() {
        if (this.isActive()) {
            return this;
        }
        Person person = this.getPersonForInactivePersonCustomer();
        Optional<? extends PersonCustomer> activeCustomer = PersonCustomer.findUnique(person, PersonCustomer.countryCode(person), PersonCustomer.fiscalNumber(person));
        if (!activeCustomer.isPresent()) {
            return null;
        }
        return (Customer)activeCustomer.get();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PersonCustomer$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PersonCustomer this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.PersonCustomer.cannot.delete", new String[0]);
        }
        super.setPersonForInactivePersonCustomer(null);
        super.setPerson(null);
        for (DebtAccount debtAccount : this_.getDebtAccountsSet()) {
            debtAccount.delete();
        }
        super.delete();
    }

    public boolean isBlockingAcademicalActs(LocalDate when) {
        if (DebtAccount.find((Customer)this).map(da -> Constants.isGreaterThan((BigDecimal)da.getTotalInDebt(), (BigDecimal)BigDecimal.ZERO)).reduce((a, c) -> a != false || c != false).orElse(Boolean.FALSE).booleanValue()) {
            return DebitEntry.find((Customer)this).map(d -> PersonCustomer.isDebitEntryBlockingAcademicalActs(d, when)).reduce((a, c) -> a != false || c != false).orElse(Boolean.FALSE);
        }
        return false;
    }

    public static boolean isDebitEntryBlockingAcademicalActs(DebitEntry debitEntry, LocalDate when) {
        if (debitEntry.isAnnulled()) {
            return false;
        }
        if (!debitEntry.isInDebt()) {
            return false;
        }
        if (!debitEntry.isBlockAcademicActsOnDebt() && !debitEntry.isDueDateExpired(when)) {
            return false;
        }
        if (!AcademicTreasurySettings.getInstance().isAcademicalActBlocking(debitEntry.getProduct())) {
            return false;
        }
        return !debitEntry.isAcademicalActBlockingSuspension();
    }

    public BigDecimal getGlobalBalance() {
        Person person;
        BigDecimal globalBalance = BigDecimal.ZERO;
        Person person2 = person = this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
        if (person.getPersonCustomer() != null) {
            for (DebtAccount debtAccount : person.getPersonCustomer().getDebtAccountsSet()) {
                globalBalance = globalBalance.add(debtAccount.getTotalInDebt());
            }
        }
        for (PersonCustomer personCustomer : person.getInactivePersonCustomersSet()) {
            for (DebtAccount debtAccount : personCustomer.getDebtAccountsSet()) {
                globalBalance = globalBalance.add(debtAccount.getTotalInDebt());
            }
        }
        return globalBalance;
    }

    public Set<Customer> getAllCustomers() {
        return PersonCustomer.find(this.getAssociatedPerson()).collect(Collectors.toSet());
    }

    public void mergeWithPerson(Person person) {
        if (this.getPerson() == person) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.merging.not.happening", new String[0]);
        }
        if (this.getPersonForInactivePersonCustomer() == person) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.merged.already.with.person", new String[0]);
        }
        if (person.getPersonCustomer() != null) {
            PersonCustomer personCustomer = person.getPersonCustomer();
            personCustomer.setPersonForInactivePersonCustomer(this.getPerson());
            personCustomer.setPerson(null);
            personCustomer.setFromPersonMerge(true);
            personCustomer.checkRules();
        }
        for (PersonCustomer personCustomer : person.getInactivePersonCustomersSet()) {
            personCustomer.setPersonForInactivePersonCustomer(this.getPerson());
            personCustomer.setFromPersonMerge(true);
            personCustomer.checkRules();
        }
        Person thisPerson = this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
        for (AcademicTreasuryEvent e : Sets.newHashSet((Iterable)person.getAcademicTreasuryEventSet())) {
            e.setPerson(thisPerson);
        }
        this.checkRules();
    }

    public void changeFiscalNumber(AdhocCustomerBean adhocCustomerBean) {
        Object object = advice$changeFiscalNumber.perform((Callable)new PersonCustomer$callable$changeFiscalNumber(this, adhocCustomerBean));
    }

    static /* synthetic */ void advised$changeFiscalNumber(PersonCustomer this_, AdhocCustomerBean bean) {
        if (!Strings.isNullOrEmpty((String)this_.getErpCustomerId())) {
            throw new TreasuryDomainException("warning.Customer.changeFiscalNumber.maybe.integrated.in.erp", new String[0]);
        }
        String oldFiscalCountry = this_.getFiscalCountry();
        String oldFiscalNumber = this_.getFiscalNumber();
        boolean changeFiscalNumberConfirmed = bean.isChangeFiscalNumberConfirmed();
        boolean withFinantialDocumentsIntegratedInERP = this_.isWithFinantialDocumentsIntegratedInERP();
        boolean customerInformationMaybeIntegratedWithSuccess = this_.isCustomerInformationMaybeIntegratedWithSuccess();
        boolean customerWithFinantialDocumentsIntegratedInPreviousERP = this_.isCustomerWithFinantialDocumentsIntegratedInPreviousERP();
        if (!bean.isChangeFiscalNumberConfirmed()) {
            throw new TreasuryDomainException("message.Customer.changeFiscalNumber.confirmation", new String[0]);
        }
        String countryCode = bean.getCountryCode();
        String fiscalNumber = bean.getFiscalNumber();
        if (Strings.isNullOrEmpty((String)countryCode)) {
            throw new TreasuryDomainException("error.Customer.countryCode.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new TreasuryDomainException("error.Customer.fiscalNumber.required", new String[0]);
        }
        if (PersonCustomer.lowerCase((String)countryCode).equals(PersonCustomer.lowerCase((String)this_.getCountryCode())) && fiscalNumber.equals(this_.getFiscalNumber())) {
            throw new TreasuryDomainException("error.Customer.already.with.fiscal.information", new String[0]);
        }
        if (this_.isFiscalValidated() && this_.isFiscalCodeValid()) {
            throw new TreasuryDomainException("error.Customer.changeFiscalNumber.already.valid", new String[0]);
        }
        if (customerInformationMaybeIntegratedWithSuccess) {
            throw new TreasuryDomainException("warning.Customer.changeFiscalNumber.maybe.integrated.in.erp", new String[0]);
        }
        if (withFinantialDocumentsIntegratedInERP) {
            throw new TreasuryDomainException("error.Customer.changeFiscalNumber.documents.integrated.erp", new String[0]);
        }
        if (!FiscalCodeValidation.isValidFiscalNumber((String)countryCode, (String)fiscalNumber)) {
            throw new TreasuryDomainException("error.Customer.fiscal.information.invalid", new String[0]);
        }
        Optional<? extends PersonCustomer> customerOptional = PersonCustomer.findUnique(this_.getAssociatedPerson(), countryCode, fiscalNumber);
        if (this_.isActive()) {
            if (customerOptional.isPresent()) {
                throw new TreasuryDomainException("error.Customer.changeFiscalNumber.customer.exists.for.fiscal.number", new String[0]);
            }
            this_.setCountryCode(countryCode);
            this_.setFiscalNumber(fiscalNumber);
            this_.getPerson().editSocialSecurityNumber(Country.readByTwoLetterCode((String)countryCode), fiscalNumber);
        } else {
            if (customerOptional.isPresent()) {
                this_.setFromPersonMerge(true);
            }
            this_.setCountryCode(countryCode);
            this_.setFiscalNumber(fiscalNumber);
        }
        this_.checkRules();
        FiscalDataUpdateLog.create((Customer)this_, (String)oldFiscalCountry, (String)oldFiscalNumber, (boolean)changeFiscalNumberConfirmed, (boolean)withFinantialDocumentsIntegratedInERP, (boolean)customerInformationMaybeIntegratedWithSuccess, (boolean)customerWithFinantialDocumentsIntegratedInPreviousERP);
    }

    public Set<? extends TreasuryEvent> getTreasuryEventsSet() {
        Person person = this.isActive() ? this.getPerson() : this.getPersonForInactivePersonCustomer();
        HashSet result = Sets.newHashSet();
        for (IAcademicTreasuryEvent event : TreasuryBridgeAPIFactory.implementation().getAllAcademicTreasuryEventsList(person)) {
            result.add((TreasuryEvent)event);
        }
        return result;
    }

    public boolean isUiOtherRelatedCustomerActive() {
        return !this.isActive() && this.getPersonForInactivePersonCustomer().getPersonCustomer() != null;
    }

    public String uiRedirectToActiveCustomer(String url) {
        if (this.isActive() || !this.isUiOtherRelatedCustomerActive()) {
            return url + "/" + this.getExternalId();
        }
        return url + "/" + this.getPersonForInactivePersonCustomer().getPersonCustomer().getExternalId();
    }

    public static String uiPersonFiscalNumber(Person person) {
        String fiscalCountry = !Strings.isNullOrEmpty((String)PersonCustomer.countryCode(person)) ? PersonCustomer.countryCode(person) : "";
        String fiscalNumber = !Strings.isNullOrEmpty((String)PersonCustomer.fiscalNumber(person)) ? PersonCustomer.fiscalNumber(person) : "";
        return fiscalCountry + " " + fiscalNumber;
    }

    public LocalizedString getIdentificationTypeDesignation() {
        Person person = this.getAssociatedPerson();
        if (person.getIdDocumentType() != null) {
            return person.getIdDocumentType().getLocalizedNameI18N();
        }
        return null;
    }

    public String getIdentificationTypeCode() {
        Person person = this.getAssociatedPerson();
        if (person.getIdDocumentType() != null) {
            return person.getIdDocumentType().getName();
        }
        return null;
    }

    public String getIban() {
        return this.getAssociatedPerson().getIban();
    }

    public static Stream<? extends PersonCustomer> findAll() {
        return Customer.findAll().filter(c -> c instanceof PersonCustomer).map(PersonCustomer.class::cast);
    }

    public static Stream<? extends PersonCustomer> find(Person person) {
        HashSet result = Sets.newHashSet();
        if (person != null) {
            if (person.getPersonCustomer() != null) {
                result.add(person.getPersonCustomer());
            }
            result.addAll(person.getInactivePersonCustomersSet());
        }
        return result.stream();
    }

    public static Stream<? extends PersonCustomer> find(Person person, String fiscalCountryCode, String fiscalNumber) {
        return PersonCustomer.find(person).filter(pc -> !Strings.isNullOrEmpty((String)pc.getFiscalCountry()) && PersonCustomer.lowerCase((String)pc.getFiscalCountry()).equals(PersonCustomer.lowerCase((String)fiscalCountryCode)) && !Strings.isNullOrEmpty((String)pc.getFiscalNumber()) && pc.getFiscalNumber().equals(fiscalNumber));
    }

    public static Optional<? extends PersonCustomer> findUnique(Person person, String fiscalCountryCode, String fiscalNumber) {
        return PersonCustomer.find(person, fiscalCountryCode, fiscalNumber).sorted(SORT_BY_PERSON_MERGE).findFirst();
    }

    public static PersonCustomer createWithCurrentFiscalInformation(Person person) {
        if (person.getFiscalCountry() == null) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalCountry.required", new String[0]);
        }
        if (!Strings.isNullOrEmpty((String)person.getSocialSecurityNumber())) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalNumber.required", new String[0]);
        }
        return PersonCustomer.create(person, person.getFiscalCountry().getCode(), person.getSocialSecurityNumber());
    }

    public static PersonCustomer create(Person person, String string, String string2) {
        return (PersonCustomer)((Object)advice$create.perform((Callable)new PersonCustomer$callable$create(person, string, string2)));
    }

    static /* synthetic */ PersonCustomer advised$create(Person person, String fiscalCountry, String fiscalNumber) {
        return new PersonCustomer(person, fiscalCountry, fiscalNumber);
    }

    public static boolean switchCustomer(Person person, String fiscalCountryCode, String fiscalNumber) {
        PersonCustomer personCustomer = person.getPersonCustomer();
        Optional<? extends PersonCustomer> newCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber);
        if (newCustomer.isPresent() && newCustomer.get().isActive()) {
            return false;
        }
        if (personCustomer != null) {
            personCustomer.setPerson(null);
            personCustomer.setPersonForInactivePersonCustomer(person);
        }
        if (!newCustomer.isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
            newCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber);
        } else {
            newCustomer.get().setPerson(person);
            newCustomer.get().setPersonForInactivePersonCustomer(null);
        }
        if (personCustomer != null) {
            personCustomer.checkRules();
        }
        newCustomer.get().checkRules();
        return true;
    }

    public static CustomerType getDefaultCustomerType(PersonCustomer person) {
        if (person.getPerson().getStudent() != null) {
            return CustomerType.findByCode((String)STUDENT_CODE).findFirst().orElse(null);
        }
        return CustomerType.findByCode((String)CANDIDACY_CODE).findFirst().orElse(null);
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$changeFiscalNumber = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        SORT_BY_PERSON_MERGE = new Comparator<PersonCustomer>(){

            @Override
            public int compare(PersonCustomer o1, PersonCustomer o2) {
                if (!o1.isFromPersonMerge() && o2.isFromPersonMerge()) {
                    return -1;
                }
                if (o1.isFromPersonMerge() && !o2.isFromPersonMerge()) {
                    return 1;
                }
                return o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

