/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.treasury.ITreasuryBridgeAPI;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academictreasury.domain.listeners.DebitEntryDeletionListener;
import org.fenixedu.academictreasury.domain.listeners.ProductDeletionListener;
import org.fenixedu.academictreasury.domain.treasury.AcademicTreasuryBridgeImpl;
import org.fenixedu.academictreasury.services.EmolumentServices;
import org.fenixedu.academictreasury.services.RegistrationServices;
import org.fenixedu.academictreasury.services.accesscontrol.spi.AcademicTreasuryAccessControlExtension;
import org.fenixedu.academictreasury.services.signals.AcademicServiceRequestCancelOrRejectHandler;
import org.fenixedu.academictreasury.services.signals.ExtracurricularEnrolmentHandler;
import org.fenixedu.academictreasury.services.signals.ImprovementEnrolmentHandler;
import org.fenixedu.academictreasury.services.signals.StandaloneEnrolmentHandler;
import org.fenixedu.bennu.core.signals.Signal;
import org.fenixedu.treasury.domain.bennu.signals.BennuSignalsServices;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;
import pt.ist.fenixframework.FenixFramework;

@WebListener
public class AcademicTreasuryInitializer
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent arg0) {
        AcademicTreasuryInitializer.registerNewRegistrationHandler();
        AcademicTreasuryInitializer.registerNewAcademicServiceRequestSituationHandler();
        AcademicTreasuryInitializer.registerAcademicServiceRequestCancelOrRejectHandler();
        AcademicTreasuryInitializer.registerStandaloneEnrolmentHandler();
        AcademicTreasuryInitializer.registerExtracurricularEnrolmentHandler();
        AcademicTreasuryInitializer.registerImprovementEnrolmentHandler();
        TreasuryAccessControlAPI.registerExtension((ITreasuryAccessControlExtension)new AcademicTreasuryAccessControlExtension());
        DebitEntryDeletionListener.attach();
        ProductDeletionListener.attach();
        AcademicTreasuryBridgeImpl impl = new AcademicTreasuryBridgeImpl();
        TreasuryBridgeAPIFactory.registerImplementation((ITreasuryBridgeAPI)impl);
        BennuSignalsServices.registerSettlementEventHandler((Object)impl);
        this.addDeletionListeners();
    }

    private void addDeletionListeners() {
        FenixFramework.getDomainModel().registerDeletionListener(Person.class, p -> p.getInactivePersonCustomersSet().forEach(ipc -> ipc.delete()));
    }

    private static void registerNewRegistrationHandler() {
        Signal.register((String)"academic.registration.create", (Object)new RegistrationServices());
    }

    private static void registerNewAcademicServiceRequestSituationHandler() {
        Signal.register((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new EmolumentServices());
    }

    private static void registerAcademicServiceRequestCancelOrRejectHandler() {
        Signal.register((String)"ACADEMIC_SERVICE_REQUEST_REJECT_OR_CANCEL_EVENT", (Object)new AcademicServiceRequestCancelOrRejectHandler());
    }

    private static void registerStandaloneEnrolmentHandler() {
        Signal.register((String)"STANDALONE_ENROLMENT", (Object)new StandaloneEnrolmentHandler());
    }

    private static void registerExtracurricularEnrolmentHandler() {
        Signal.register((String)"EXTRACURRICULAR_ENROLMENT", (Object)new ExtracurricularEnrolmentHandler());
    }

    private static void registerImprovementEnrolmentHandler() {
        Signal.register((String)"IMPROVEMENT_ENROLMENT", (Object)new ImprovementEnrolmentHandler());
    }
}

