/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.manageemoluments;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academictreasury.services.EmolumentServices;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.manageemoluments.FinantialEntityController;
import org.fenixedu.academictreasury.ui.manageemoluments.ProductController$callable$deleteProduct;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.VatType;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Component(value="org.fenixedu.academictreasury.ui.manageemoluments")
@BennuSpringController(value=FinantialEntityController.class)
@RequestMapping(value={"/academictreasury/manageemoluments/product"})
public class ProductController
extends AcademicTreasuryBaseController {
    public static final Advice advice$deleteProduct = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public void deleteProduct(Product product) {
        Object object = advice$deleteProduct.perform((Callable)new ProductController$callable$deleteProduct(this, product));
    }

    static /* synthetic */ void advised$deleteProduct(ProductController this_, Product product) {
    }

    @RequestMapping(value={"/searchemoluments/{finantialEntityId}"})
    public String searchEmoluments(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, Model model) {
        List<Product> searchemolumentsResultsDataSet = this.getSearchUniverseSearchEmolumentsDataSet(finantialEntity);
        model.addAttribute("searchemolumentsResultsDataSet", searchemolumentsResultsDataSet);
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        return "academicTreasury/manageemoluments/product/searchemoluments";
    }

    private List<Product> getSearchUniverseSearchEmolumentsDataSet(FinantialEntity finantialEntity) {
        return new ArrayList<Product>(EmolumentServices.findEmoluments(finantialEntity).filter(l -> l.isActive()).sorted(Product.COMPARE_BY_NAME).collect(Collectors.toList()));
    }

    @RequestMapping(value={"/searchemoluments/view/{finantialEntityId}/{productId}"})
    public String processSearchEmolumentsToViewAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, Model model) {
        return String.format("redirect:/academictreasury/manageemoluments/academictariff/viewemolumenttariffs/%s/%s", finantialEntity.getExternalId(), product.getExternalId());
    }

    @RequestMapping(value={"/createemolument/{finantialEntityId}"}, method={RequestMethod.GET})
    public String createemolument(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("vatType_options", VatType.findAll().collect(Collectors.toSet()));
        return "academicTreasury/manageemoluments/product/createemolument";
    }

    @RequestMapping(value={"/createemolument/{finantialEntityId}"}, method={RequestMethod.POST})
    public String createemolument(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="vattype", required=false) VatType vatType, Model model) {
        try {
            Product product = EmolumentServices.createEmolument(code, name, vatType, finantialEntity.getFinantialInstitution());
            model.addAttribute("product", (Object)product);
            return String.format("redirect:/academictreasury/manageemoluments/product/searchemoluments/%s", finantialEntity.getExternalId());
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.createemolument(finantialEntity, model);
        }
    }
}

