/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.reports;

import com.google.common.base.Strings;
import com.qubit.terra.docs.core.DocumentGenerator;
import com.qubit.terra.docs.core.DocumentTemplateEngine;
import com.qubit.terra.docs.core.IDocumentTemplateService;
import com.qubit.terra.docs.util.IReportDataProvider;
import com.qubit.terra.docs.util.helpers.IDocumentHelper;
import java.io.InputStream;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.services.reports.DocumentPrinterConfiguration;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.services.reports.dataproviders.CustomerDataProvider;
import org.fenixedu.treasury.services.reports.dataproviders.DebtAccountDataProvider;
import org.fenixedu.treasury.services.reports.dataproviders.FinantialInstitutionDataProvider;
import org.fenixedu.treasury.services.reports.helpers.DateHelper;
import org.fenixedu.treasury.services.reports.helpers.EnumerationHelper;
import org.fenixedu.treasury.services.reports.helpers.LanguageHelper;
import org.fenixedu.treasury.services.reports.helpers.MoneyHelper;
import org.fenixedu.treasury.services.reports.helpers.NumbersHelper;
import org.fenixedu.treasury.services.reports.helpers.StringsHelper;

public class DocumentPrinter {
    private static final String TEMPLATES_TUITIONS_PAYMENT_PLAN = "templates/tuitionsPaymentPlan.odt";
    public static final String PDF = "application/pdf";
    public static final String ODT = "application/vnd.oasis.opendocument.text";

    public static synchronized void registerService() {
        DocumentPrinterConfiguration service = new DocumentPrinterConfiguration();
        DocumentTemplateEngine.registerServiceImplementations((IDocumentTemplateService)service);
    }

    private static void registerHelpers(DocumentGenerator generator) {
        generator.registerHelper("dates", (IDocumentHelper)new DateHelper());
        generator.registerHelper("lang", (IDocumentHelper)new LanguageHelper());
        generator.registerHelper("numbers", (IDocumentHelper)new NumbersHelper());
        generator.registerHelper("enumeration", (IDocumentHelper)new EnumerationHelper());
        generator.registerHelper("strings", (IDocumentHelper)new StringsHelper());
        generator.registerHelper("money", (IDocumentHelper)new MoneyHelper());
    }

    public static byte[] printRegistrationTuititionPaymentPlan(Registration registration, String outputMimeType) {
        Person p = registration.getStudent().getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(p);
        String fiscalNumber = PersonCustomer.fiscalNumber(p);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        PersonCustomer customer = PersonCustomer.findUnique(p, fiscalCountryCode, fiscalNumber).orElse(null);
        FinantialInstitution finst = registration.getDegree().getAdministrativeOffice().getFinantialEntity().getFinantialInstitution();
        DebtAccount account = DebtAccount.findUnique((FinantialInstitution)finst, (Customer)customer).orElse(null);
        return DocumentPrinter.printRegistrationTuititionPaymentPlan(account, outputMimeType);
    }

    public static byte[] printRegistrationTuititionPaymentPlan(DebtAccount debtAccount, String outputMimeType) {
        DocumentGenerator generator = null;
        InputStream resourceAsStream = DocumentGenerator.class.getClassLoader().getResourceAsStream(TEMPLATES_TUITIONS_PAYMENT_PLAN);
        generator = DocumentGenerator.create((InputStream)resourceAsStream, (String)outputMimeType);
        DocumentPrinter.registerHelpers(generator);
        generator.registerDataProvider((IReportDataProvider)new DebtAccountDataProvider(debtAccount, null));
        generator.registerDataProvider((IReportDataProvider)new CustomerDataProvider(debtAccount.getCustomer(), "customer"));
        generator.registerDataProvider((IReportDataProvider)new FinantialInstitutionDataProvider(debtAccount.getFinantialInstitution()));
        byte[] outputReport = generator.generateReport();
        return outputReport;
    }

    static {
        DocumentPrinter.registerService();
    }
}

