/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services.accesscontrol.spi;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;

public class AcademicTreasuryAccessControlExtension
implements ITreasuryAccessControlExtension {
    public boolean isFrontOfficeMember(User user) {
        return FinantialInstitution.findAll().map(l -> this.isFrontOfficeMember(user, (FinantialInstitution)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isFrontOfficeMember(User user, FinantialInstitution finantialInstitution) {
        return FinantialEntity.find((FinantialInstitution)finantialInstitution).map(l -> this.isFrontOfficeMember(user, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isFrontOfficeMember(User user, FinantialEntity finantialEntity) {
        if (finantialEntity.getAdministrativeOffice() == null) {
            return false;
        }
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    public boolean isBackOfficeMember(User user) {
        return FinantialInstitution.findAll().map(l -> this.isBackOfficeMember(user, (FinantialInstitution)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isBackOfficeMember(User user, FinantialInstitution finantialInstitution) {
        return FinantialEntity.findAll().map(l -> this.isBackOfficeMember(user, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    public boolean isBackOfficeMember(User user, FinantialEntity finantialEntity) {
        if (finantialEntity.getAdministrativeOffice() == null) {
            return false;
        }
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS_ADV, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    public Set<User> getFrontOfficeMembers() {
        return FinantialEntity.findAll().filter(l -> l.getAdministrativeOffice() != null).map(l -> AcademicAccessRule.getMembers((AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS, Collections.emptySet(), Collections.singleton(l.getAdministrativeOffice())).collect(Collectors.toSet())).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Collections.emptySet());
    }

    public Set<User> getBackOfficeMembers() {
        return FinantialEntity.findAll().filter(l -> l.getAdministrativeOffice() != null).map(l -> AcademicAccessRule.getMembers((AcademicOperationType)AcademicOperationType.MANAGE_STUDENT_PAYMENTS_ADV, Collections.emptySet(), Collections.singleton(l.getAdministrativeOffice())).collect(Collectors.toSet())).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Collections.emptySet());
    }

    public boolean isAllowToModifySettlements(User user, FinantialInstitution finantialInstitution) {
        return FinantialEntity.findAll().map(l -> this.isAllowToModifySettlements(user, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isAllowToModifySettlements(User user, FinantialEntity finantialEntity) {
        if (finantialEntity.getAdministrativeOffice() == null) {
            return false;
        }
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.PAYMENTS_MODIFY_SETTLEMENTS, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }

    public boolean isAllowToModifyInvoices(User user, FinantialInstitution finantialInstitution) {
        return FinantialEntity.findAll().map(l -> this.isAllowToModifyInvoices(user, (FinantialEntity)l)).reduce((a, b) -> a != false || b != false).orElse(false);
    }

    private boolean isAllowToModifyInvoices(User user, FinantialEntity finantialEntity) {
        if (finantialEntity.getAdministrativeOffice() == null) {
            return false;
        }
        return AcademicAccessRule.isMember((User)user, (AcademicOperationType)AcademicOperationType.PAYMENTS_MODIFY_INVOICES, Collections.emptySet(), Collections.singleton(finantialEntity.getAdministrativeOffice()));
    }
}

