/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultFile_Base;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.joda.time.DateTime;

public class DebtReportRequestResultFile
extends DebtReportRequestResultFile_Base {
    protected DebtReportRequestResultFile(DebtReportRequest request, byte[] content) {
        this.setBennu(Bennu.getInstance());
        this.setDebtReportRequest(request);
        String filename = Constants.academicTreasuryBundle("label.DebtReportRequestResultFile.ZIP.filename", new DateTime().toString("YYYYMMddHHmmss"));
        this.init(filename, filename, content);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDebtReportRequest() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequestResultFile.debtReportRequest.required", new String[0]);
        }
    }

    public BigDecimal getFilesizeMb() {
        return new BigDecimal(this.getSize()).setScale(4, RoundingMode.DOWN).divide(new BigDecimal(1024)).divide(new BigDecimal(1024)).setScale(1, RoundingMode.DOWN);
    }

    public boolean isAccessible(User user) {
        return TreasuryAccessControlAPI.isBackOfficeMember((User)user);
    }

    public static DebtReportRequestResultFile create(DebtReportRequest request, byte[] content) {
        return new DebtReportRequestResultFile(request, content);
    }
}

