/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$5$callable$run;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$cancelRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$create;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$processRequest;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest$callable$writeReportResultFile;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultErrorsFile;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequestResultFile;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest_Base;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.domain.reports.task.PendingDebtReportRequestsCronTask;
import org.fenixedu.academictreasury.dto.reports.AcademicActBlockingSuspensionReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.DebtAccountReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.DebtReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.DebtReportRequestBean;
import org.fenixedu.academictreasury.dto.reports.PaymentReferenceCodeEntryBean;
import org.fenixedu.academictreasury.dto.reports.PaymentReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.ProductReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.SettlementReportEntryBean;
import org.fenixedu.academictreasury.dto.reports.SibsTransactionDetailEntryBean;
import org.fenixedu.academictreasury.dto.reports.TreasuryExemptionReportEntryBean;
import org.fenixedu.academictreasury.services.debtReports.DebtReportService;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.TaskRunner;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DebtReportRequest
extends DebtReportRequest_Base {
    public static final String DOT = ".";
    public static final String COMMA = ",";
    public static final Advice advice$processRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$writeReportResultFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$cancelRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected DebtReportRequest() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setDomainRootForPendingReportRequests(FenixFramework.getDomainRoot());
    }

    protected DebtReportRequest(DebtReportRequestBean bean) {
        this();
        this.setBeginDate(bean.getBeginDate());
        this.setEndDate(bean.getEndDate());
        this.setType(bean.getType());
        this.setDecimalSeparator(bean.getDecimalSeparator());
        this.setIncludeAnnuledEntries(bean.isIncludeAnnuledEntries());
        this.checkRules();
    }

    private void checkRules() {
        if (this.getBeginDate() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.beginDate.required", new String[0]);
        }
        if (this.getEndDate() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.endDate.required", new String[0]);
        }
        if (this.getType() == null) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.type.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getDecimalSeparator()) || !this.getDecimalSeparator().equals(COMMA) && !this.getDecimalSeparator().equals(DOT)) {
            throw new AcademicTreasuryDomainException("error.DebtReportRequest.decimalSeparator.invalid", new String[0]);
        }
    }

    public boolean isPending() {
        return this.getDomainRootForPendingReportRequests() != null;
    }

    public boolean isIncludeAnnuledEntries() {
        return super.getIncludeAnnuledEntries();
    }

    public void processRequest() {
        Object object = advice$processRequest.perform((Callable)new DebtReportRequest$callable$processRequest(this));
    }

    static /* synthetic */ void advised$processRequest(DebtReportRequest this_) {
        if (this_.getType().isRequestForInvoiceEntries()) {
            ErrorsLog errorsLog = new ErrorsLog();
            byte[] debitCreditsContent = this_.extractInformationForDebitAndCredits(errorsLog);
            byte[] settlementsContent = this_.extractInformationForSettlements(errorsLog);
            byte[] paymentCodesContent = this_.extractInformationForPaymentCodes(errorsLog);
            byte[] othersContent = this_.extractOtherTreasuryData(errorsLog);
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                zos.putNextEntry(new ZipEntry(Constants.academicTreasuryBundle("label.DebtReportRequestResultFile.INVOICE_ENTRIES.filename", new DateTime().toString("YYYYMMddHHmmss"))));
                zos.write(debitCreditsContent);
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry(Constants.academicTreasuryBundle("label.DebtReportRequestResultFile.SETTLEMENT_ENTRIES.filename", new DateTime().toString("YYYYMMddHHmmss"))));
                zos.write(settlementsContent);
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry(Constants.academicTreasuryBundle("label.DebtReportRequestResultFile.PAYMENT_CODES.filename", new DateTime().toString("YYYYMMddHHmmss"))));
                zos.write(paymentCodesContent);
                zos.closeEntry();
                zos.putNextEntry(new ZipEntry(Constants.academicTreasuryBundle("label.DebtReportRequestResultFile.OTHER.filename", new DateTime().toString("YYYYMMddHHmmss"))));
                zos.write(othersContent);
                zos.closeEntry();
                zos.close();
                baos.close();
                byte[] contents = baos.toByteArray();
                this_.writeReportResultFile(errorsLog, contents);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void writeReportResultFile(ErrorsLog errorsLog, byte[] byArray) {
        Object object = advice$writeReportResultFile.perform((Callable)new DebtReportRequest$callable$writeReportResultFile(this, errorsLog, byArray));
    }

    static /* synthetic */ void advised$writeReportResultFile(DebtReportRequest this_, ErrorsLog errorsLog, byte[] content) {
        DebtReportRequestResultFile.create(this_, content);
        DebtReportRequestResultErrorsFile.create(this_, errorsLog.getLog().getBytes());
        this_.setDomainRootForPendingReportRequests(null);
    }

    private byte[] extractInformationForSettlements(final ErrorsLog errorsLog) {
        return Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.settlementEntriesSheetName(), (String[])SettlementReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.settlementEntriesReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.paymentEntriesSheetName(), (String[])PaymentReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.paymentEntriesReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.reimbursementEntriesSheetName(), (String[])PaymentReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.reimbursementEntriesReport(DebtReportRequest.this, errorsLog))};
            }
        }, (IErrorsLog)errorsLog);
    }

    private byte[] extractInformationForPaymentCodes(final ErrorsLog errorsLog) {
        return Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.paymentReferenceCodeSheetName(), (String[])PaymentReferenceCodeEntryBean.SPREADSHEET_HEADERS, DebtReportService.paymentReferenceCodeReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.sibsTransactionDetailSheetName(), (String[])SibsTransactionDetailEntryBean.SPREADSHEET_HEADERS, DebtReportService.sibsTransactionDetailReport(DebtReportRequest.this, errorsLog))};
            }
        }, (IErrorsLog)errorsLog);
    }

    private byte[] extractOtherTreasuryData(final ErrorsLog errorsLog) {
        return Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.debtAccountEntriesSheetName(), (String[])DebtAccountReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.debtAccountEntriesReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.academicActBlockingSuspensionSheetName(), (String[])AcademicActBlockingSuspensionReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.academicActBlockingSuspensionReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.treasuryExemptionSheetName(), (String[])TreasuryExemptionReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.treasuryExemptionReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.productSheetName(), (String[])ProductReportEntryBean.SPREADSHEET_HEADERS, DebtReportService.productReport(DebtReportRequest.this, errorsLog))};
            }
        }, (IErrorsLog)errorsLog);
    }

    private byte[] extractInformationForDebitAndCredits(final ErrorsLog errorsLog) {
        return Spreadsheet.buildSpreadsheetContent((Spreadsheet)new Spreadsheet(){

            public ExcelSheet[] getSheets() {
                return new ExcelSheet[]{ExcelSheet.create((String)DebtReportRequest.this.debitEntriesSheetName(), (String[])DebtReportEntryBean.SPREADSHEET_DEBIT_HEADERS, DebtReportService.debitEntriesReport(DebtReportRequest.this, errorsLog)), ExcelSheet.create((String)DebtReportRequest.this.creditEntriesSheetName(), (String[])DebtReportEntryBean.SPREADSHEET_CREDIT_HEADERS, DebtReportService.creditEntriesReport(DebtReportRequest.this, errorsLog))};
            }

            private String decimalSeparator() {
                if (Strings.isNullOrEmpty((String)DebtReportRequest.this.getDecimalSeparator())) {
                    return DebtReportRequest.DOT;
                }
                return DebtReportRequest.this.getDecimalSeparator();
            }
        }, (IErrorsLog)errorsLog);
    }

    public void cancelRequest() {
        Object object = advice$cancelRequest.perform((Callable)new DebtReportRequest$callable$cancelRequest(this));
    }

    static /* synthetic */ void advised$cancelRequest(DebtReportRequest this_) {
        this_.setDomainRootForPendingReportRequests(null);
    }

    protected String treasuryExemptionSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.treasuryExemptionSheetName", new String[0]);
    }

    protected String sibsTransactionDetailSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.sibsTransactionDetailSheetName", new String[0]);
    }

    protected String paymentReferenceCodeSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.paymentReferenceCodeSheetName", new String[0]);
    }

    private String academicActBlockingSuspensionSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.academicActBlockingSuspensionSheetName", new String[0]);
    }

    private String debitEntriesSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.debitEntriesSheetName", new String[0]);
    }

    private String creditEntriesSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.creditEntriesSheetName", new String[0]);
    }

    private String paymentEntriesSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.paymentEntriesSheetName", new String[0]);
    }

    private String settlementEntriesSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.settlementEntriesSheetName", new String[0]);
    }

    private String reimbursementEntriesSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.reimbursementEntriesSheetName", new String[0]);
    }

    private String debtAccountEntriesSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.debtAccountEntriesSheetName", new String[0]);
    }

    private String productSheetName() {
        return Constants.academicTreasuryBundle("label.DebtReportRequest.productsSheetName", new String[0]);
    }

    public static Stream<DebtReportRequest> findAll() {
        return FenixFramework.getDomainRoot().getDebtReportRequestsSet().stream();
    }

    public static Stream<DebtReportRequest> findPending() {
        return FenixFramework.getDomainRoot().getDebtReportRequestsSet().stream().filter(i -> i.isPending());
    }

    public static DebtReportRequest create(DebtReportRequestBean debtReportRequestBean) {
        return (DebtReportRequest)((Object)advice$create.perform((Callable)new DebtReportRequest$callable$create(debtReportRequestBean)));
    }

    static /* synthetic */ DebtReportRequest advised$create(DebtReportRequestBean bean) {
        DebtReportRequest request = new DebtReportRequest(bean);
        new Thread(){
            public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

            @Override
            public void run() {
                Object object = advice$run.perform((Callable)new DebtReportRequest$5$callable$run(this));
            }

            static /* synthetic */ void advised$run(5 this_) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SchedulerSystem.queue((TaskRunner)new TaskRunner((CronTask)new PendingDebtReportRequestsCronTask()));
            }
        }.start();
        return request;
    }
}

