/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.integration.tuitioninfo;

import com.google.common.base.Strings;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoProduct_Base;
import pt.ist.fenixframework.FenixFramework;

public class ERPTuitionInfoProduct
extends ERPTuitionInfoProduct_Base {
    public ERPTuitionInfoProduct() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ERPTuitionInfoProduct(String code, String name) {
        this();
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.bennu.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.code.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getName())) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.name.required", new String[0]);
        }
        if (ERPTuitionInfoProduct.findByCode(this.getCode()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.ERPTuitionInfoType.code.not.unique", new String[0]);
        }
    }

    public static Stream<ERPTuitionInfoProduct> findAll() {
        return FenixFramework.getDomainRoot().getErpTuitionInfoProductsSet().stream();
    }

    public static Stream<ERPTuitionInfoProduct> findByCode(String code) {
        return ERPTuitionInfoProduct.findAll().filter(p -> p.getCode().equals(code));
    }

    public static ERPTuitionInfoProduct create(String code, String name) {
        return new ERPTuitionInfoProduct(code, name);
    }
}

