/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration.strategies;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRuleEntry;
import org.fenixedu.academictreasury.domain.debtGeneration.IAcademicDebtGenerationRuleStrategy;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CloseDebtsStrategy$callable$process;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CloseDebtsStrategy$callable$process$1;
import org.fenixedu.academictreasury.domain.debtGeneration.strategies.CloseDebtsStrategy$callable$processDebtsForRegistration;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry_Base;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CloseDebtsStrategy
implements IAcademicDebtGenerationRuleStrategy {
    private static Logger logger;
    public static final Advice advice$process;
    public static final Advice advice$process$1;
    public static final Advice advice$processDebtsForRegistration;

    @Override
    public boolean isAppliedOnTuitionDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnAcademicTaxDebitEntries() {
        return true;
    }

    @Override
    public boolean isAppliedOnOtherDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCreateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToAggregateDebitEntries() {
        return false;
    }

    @Override
    public boolean isToCloseDebitNote() {
        return true;
    }

    @Override
    public boolean isToCreatePaymentReferenceCodes() {
        return false;
    }

    @Override
    public boolean isEntriesRequired() {
        return true;
    }

    @Override
    public boolean isToAlignAcademicTaxesDueDate() {
        return true;
    }

    @Override
    public void process(AcademicDebtGenerationRule academicDebtGenerationRule) {
        Object object = advice$process.perform((Callable)new CloseDebtsStrategy$callable$process(this, academicDebtGenerationRule));
    }

    static /* synthetic */ void advised$process(CloseDebtsStrategy this_, AcademicDebtGenerationRule rule) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        for (DegreeCurricularPlan degreeCurricularPlan : rule.getDegreeCurricularPlansSet()) {
            for (Registration registration : degreeCurricularPlan.getRegistrations()) {
                if (rule.getDebtGenerationRuleRestriction() != null && !rule.getDebtGenerationRuleRestriction().strategyImplementation().isToApply(rule, registration)) continue;
                try {
                    this_.processDebtsForRegistration(rule, registration);
                }
                catch (AcademicTreasuryDomainException e) {
                    logger.info(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void process(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        Object object = advice$process$1.perform((Callable)new CloseDebtsStrategy$callable$process$1(this, academicDebtGenerationRule, registration));
    }

    static /* synthetic */ void advised$process(CloseDebtsStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        if (!rule.isActive()) {
            throw new AcademicTreasuryDomainException("error.AcademicDebtGenerationRule.not.active.to.process", new String[0]);
        }
        if (rule.getDebtGenerationRuleRestriction() != null && !rule.getDebtGenerationRuleRestriction().strategyImplementation().isToApply(rule, registration)) {
            return;
        }
        try {
            this_.processDebtsForRegistration(rule, registration);
        }
        catch (AcademicTreasuryDomainException e) {
            logger.info(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processDebtsForRegistration(AcademicDebtGenerationRule academicDebtGenerationRule, Registration registration) {
        Object object = advice$processDebtsForRegistration.perform((Callable)new CloseDebtsStrategy$callable$processDebtsForRegistration(this, academicDebtGenerationRule, registration));
    }

    static /* synthetic */ void advised$processDebtsForRegistration(CloseDebtsStrategy this_, AcademicDebtGenerationRule rule, Registration registration) {
        HashSet debitEntriesSetForAlignment = Sets.newHashSet();
        for (AcademicDebtGenerationRuleEntry entry : rule.getAcademicDebtGenerationRuleEntriesSet()) {
            Product product = entry.getProduct();
            Set<DebitEntry> grabbedDebitEntries = null;
            if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == product.getProductGroup()) {
                grabbedDebitEntries = this_.grabDebitEntryForTuitions(rule, registration, entry);
            } else if (AcademicTax.findUnique(product).isPresent()) {
                grabbedDebitEntries = this_.grabDebitEntryForAcademicTax(rule, registration, entry);
            }
            if (grabbedDebitEntries == null) continue;
            debitEntriesSetForAlignment.addAll(grabbedDebitEntries);
        }
        if (rule.getAcademicTaxDueDateAlignmentType() != null) {
            rule.getAcademicTaxDueDateAlignmentType().applyDueDate(rule, debitEntriesSetForAlignment);
        }
        for (DebitEntry grabbedDebitEntry : debitEntriesSetForAlignment) {
            DebitNote debitNote;
            LocalDate dueDate;
            if (grabbedDebitEntry.getFinantialDocument() == null || !grabbedDebitEntry.getFinantialDocument().isPreparing() || (dueDate = grabbedDebitEntry.getDueDate()).minusDays(rule.getDays()).isAfter((ReadablePartial)new LocalDate()) || !Constants.isPositive((debitNote = (DebitNote)grabbedDebitEntry.getFinantialDocument()).getTotalAmount())) continue;
            LocalDate maxDebitEntryDueDate = this_.maxDebitEntryDueDate(debitNote);
            debitNote.setDocumentDueDate(maxDebitEntryDueDate);
            debitNote.closeDocument();
        }
    }

    private Set<DebitEntry> grabDebitEntryForTuitions(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        PersonCustomer customer = registration.getPerson().getPersonCustomer();
        if (customer == null) {
            return Sets.newHashSet();
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
        if (t == null || !t.isChargedWithDebitEntry(product)) {
            return Sets.newHashSet();
        }
        return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t, product).collect(Collectors.toSet());
    }

    private Set<DebitEntry> grabDebitEntryForAcademicTax(AcademicDebtGenerationRule rule, Registration registration, AcademicDebtGenerationRuleEntry entry) {
        AcademicTax academicTax;
        PersonCustomer customer = registration.getPerson().getPersonCustomer();
        if (customer == null) {
            return Sets.newHashSet();
        }
        Product product = entry.getProduct();
        ExecutionYear executionYear = rule.getExecutionYear();
        AcademicTreasuryEvent t = AcademicTaxServices.findAcademicTreasuryEvent(registration, executionYear, academicTax = AcademicTax.findUnique(product).get());
        if (t != null && t.isChargedWithDebitEntry()) {
            return IAcademicDebtGenerationRuleStrategy.findActiveDebitEntries(customer, (TreasuryEvent)t).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    private LocalDate maxDebitEntryDueDate(DebitNote debitNote) {
        LocalDate maxDate = debitNote.getDebitEntries().max(DebitEntry.COMPARE_BY_DUE_DATE).map(DebitEntry_Base::getDueDate).orElse(new LocalDate());
        return maxDate.isAfter((ReadablePartial)new LocalDate()) ? maxDate : new LocalDate();
    }

    static {
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$process$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$processDebtsForRegistration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(CloseDebtsStrategy.class);
    }
}

