/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managetuitionpaymentplan;

import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.dto.tariff.TuitionPaymentPlanBean;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.managetuitionpaymentplan.FinantialEntityController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=FinantialEntityController.class)
@RequestMapping(value={"/academictreasury/managetuitionpaymentplan/tuitionpaymentplan"})
public class TuitionPaymentPlanController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan";
    private static final String JSP_PATH = "academicTreasury/managetuitionpaymentplan/tuitionpaymentplan";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/";
    private static final String _SEARCH_TO_DELETE_ACTION_URI = "/search/delete";
    public static final String SEARCH_TO_DELETE_ACTION_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/search/delete";
    private static final String _CREATECHOOSEDEGREECURRICULARPLANS_URI = "/createchoosedegreecurricularplans";
    public static final String CREATECHOOSEDEGREECURRICULARPLANS_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/createchoosedegreecurricularplans";
    private static final String _CREATECHOOSEDEGREECURRICULARPLANSPOSTBACK_URI = "/createchoosedegreecurricularplanspostback";
    public static final String CREATECHOOSEDEGREECURRICULARPLANSPOSTBACK_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/createchoosedegreecurricularplanspostback";
    private static final String _CREATEDEFINESTUDENTCONDITIONS_URI = "/createdefinestudentconditions";
    public static final String CREATEDEFINESTUDENTCONDITIONS_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/createdefinestudentconditions";
    private static final String _CREATEDEFINESTUDENTCONDITIONSPOSTBACK_URI = "/createdefinestudentconditionspostback";
    public static final String CREATEDEFINESTUDENTCONDITIONSPOSTBACK_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/createdefinestudentconditionspostback";
    private static final String _CREATEINSERTINSTALLMENTS_URI = "/createinsertinstallments";
    public static final String CREATEINSERTINSTALLMENTS_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/createinsertinstallments";
    private static final String _CREATEINSERTINSTALLMENTSPOSTBACK_URI = "/createinsertinstallmentspostback";
    public static final String CREATEINSERTINSTALLMENTSPOSTBACK_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/createinsertinstallmentspostback";
    private static final String _ADDINSTALLMENTSPOSTBACK_URI = "/addinstallmentspostback";
    public static final String ADDINSTALLMENTSPOSTBACK_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/addinstallmentspostback";
    private static final String _REMOVEINSTALLMENT_URI = "/removeinstallment";
    public static final String REMOVEINSTALLMENT_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/removeinstallment";
    private static final String _CREATEPAYMENTPLAN_URI = "/createpaymentplan";
    public static final String CREATEPAYMENTPLAN_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/createpaymentplan";
    private static final String BACKTODEGREECURRICULARPLAN_TO_CHOOSE_ACTION_URI = "/backtochoosedegreecurricularplans";
    public static final String BACKTODEGREECURRICULARPLAN_TO_CHOOSE_ACTION_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/backtochoosedegreecurricularplans";
    private static final String BACKTODEFINE_STUDENT_CONDITIONS_ACTION_URI = "/backtodefinestudentconditions";
    public static final String BACKTODEFINE_STUDENT_CONDITIONS_ACTION_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/backtodefinestudentconditions";
    private static final String _ORDER_UP_ACTION_URI = "/paymentplanorderup";
    public static final String ORDER_UP_ACTION_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/paymentplanorderup";
    private static final String _ORDER_DOWN_ACTION_URI = "/paymentplanorderdown";
    public static final String ORDER_DOWN_ACTION_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/paymentplanorderdown";
    private static final String _COPY_PAYMENT_PLAN_CHOOSE_EXECUTION_YEAR_DEGREE_CURRICULAR_PLANS_URI = "/copypaymentplanchooseexecutionyeardegreecurricularplans";
    public static final String COPY_PAYMENT_PLAN_CHOOSE_EXECUTION_YEAR_DEGREE_CURRICULAR_PLANS_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/copypaymentplanchooseexecutionyeardegreecurricularplans";
    private static final String _COPY_PAYMENT_PLAN_CHOOSE_EXECUTION_YEAR_DEGREE_CURRICULAR_PLANS_POSTBACK_URI = "/copypaymentplanchooseexecutionyeardegreecurricularplanspostback";
    public static final String COPY_PAYMENT_PLAN_CHOOSE_EXECUTION_YEAR_DEGREE_CURRICULAR_PLANS_POSTBACK__URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/copypaymentplanchooseexecutionyeardegreecurricularplanspostback";
    private static final String _COPY_PAYMENT_PLAN_CONFIRM_URI = "/copypaymentplanconfirm";
    public static final String COPY_PAYMENT_PLAN_CONFIRM_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/copypaymentplanconfirm";
    private static final String _COPY_PAYMENT_PLAN_URI = "/copypaymentplan";
    public static final String COPY_PAYMENT_PLAN_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/copypaymentplan";
    private static final String _CANCEL_COPY_PAYMENT_PLAN_URI = "/cancelcopypaymentplan";
    public static final String CANCEL_COPY_PAYMENT_PLAN_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/cancelcopypaymentplan";
    private static final String _BACK_COPY_PAYMENT_PLAN_CHOOSE_EXECUTION_YEAR_URI = "/backcopypaymentplanchooseexecutionyear";
    public static final String BACK_COPY_PAYMENT_PLAN_CHOOSE_EXECUTION_YEAR_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/backcopypaymentplanchooseexecutionyear";
    private static final String _EDIT_TUITION_INSTALLMENT_URI = "/edittuitioninstallment";
    public static final String EDIT_TUITION_INSTALLMENT_URL = "/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/edittuitioninstallment";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/managetuitionpaymentplan/tuitionpaymentplan/";
    }

    private TuitionPaymentPlan getTuitionPaymentPlan(Model model) {
        return (TuitionPaymentPlan)((Object)model.asMap().get("tuitionPaymentPlan"));
    }

    private void setTuitionPaymentPlan(TuitionPaymentPlan tuitionPaymentPlan, Model model) {
        model.addAttribute("tuitionPaymentPlan", (Object)tuitionPaymentPlan);
    }

    @RequestMapping(value={"/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}"})
    public String search(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        model.addAttribute("searchtuitionpaymentplanResultsDataSet", TuitionPaymentPlan.findSortedByPaymentPlanOrder(TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), degreeCurricularPlan, executionYear).collect(Collectors.toList()));
        return this.jspPage("search");
    }

    @RequestMapping(value={"/search/delete/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}/{tuitionPaymentPlanId}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @PathVariable(value="tuitionPaymentPlanId") TuitionPaymentPlan tuitionPaymentPlan, Model model, RedirectAttributes redirectAttributes) {
        try {
            tuitionPaymentPlan.delete();
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlan.deletion.success", (String[])new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(String.format("/academictreasury/managetuitionpaymentplan/tuitionpaymentplan//%s/%s/%s", finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/createchoosedegreecurricularplans/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.GET})
    public String createchoosedegreecurricularplans(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, Model model) {
        TuitionPaymentPlanBean bean = new TuitionPaymentPlanBean(null, TuitionPaymentPlanGroup.findUniqueDefaultGroupForRegistration().get(), finantialEntity, executionYear);
        return this._createchoosedegreecurricularplans(finantialEntity, executionYear, model, bean);
    }

    private String _createchoosedegreecurricularplans(FinantialEntity finantialEntity, ExecutionYear executionYear, Model model, TuitionPaymentPlanBean bean) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("createchoosedegreecurricularplans");
    }

    @RequestMapping(value={"/createchoosedegreecurricularplanspostback/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createchoosedegreecurricularplanspostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createdefinestudentconditions/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST})
    public String createdefinestudentconditions(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        if (bean.getDegreeType() == null || bean.getDegreeCurricularPlans().isEmpty()) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.TuitionPaymentPlan.choose.degree.curricular.plans", (String[])new String[0]), model);
            return this._createchoosedegreecurricularplans(finantialEntity, executionYear, model, bean);
        }
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("createdefinestudentconditions");
    }

    @RequestMapping(value={"/createdefinestudentconditionspostback/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createdefinestudentconditionspostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createinsertinstallments/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST})
    public String createinsertinstallments(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        List<String> messages = bean.validateStudentConditions();
        if (!messages.isEmpty()) {
            for (String m : messages) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)m, (String[])new String[0]), model);
            }
            return this.createdefinestudentconditions(finantialEntity, executionYear, bean, model);
        }
        if (bean.isCustomized() && Strings.isNullOrEmpty((String)bean.getName())) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.TuitionPaymentPlan.custom.payment.plan.name.required", (String[])new String[0]), model);
            return this.createdefinestudentconditions(finantialEntity, executionYear, bean, model);
        }
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("createinsertinstallments");
    }

    @RequestMapping(value={"/createinsertinstallmentspostback/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createinsertinstallmentspostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/addinstallmentspostback/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public String addinstallmentspostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        List<String> errorMessages = bean.addInstallment();
        if (!errorMessages.isEmpty()) {
            for (String error : errorMessages) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)error, (String[])new String[0]), model);
            }
        } else {
            bean.resetInstallmentFields();
        }
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("createinsertinstallments");
    }

    @RequestMapping(value={"/removeinstallment/{finantialEntityId}/{executionYearId}/{installmentNumber}"}, method={RequestMethod.POST})
    public String addinstallmentspostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="installmentNumber") int installmentNumber, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        try {
            bean.removeInstallment(installmentNumber);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
        }
        bean.resetInstallmentFields();
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("createinsertinstallments");
    }

    @RequestMapping(value={"/createpaymentplan/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST})
    public String createinsertinstallments(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean", required=false) TuitionPaymentPlanBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            TuitionPaymentPlan.create(bean);
            return this.redirect(String.format("%s/%s/%s", "/academictreasury/managetuitionpaymentplan/degreecurricularplan/choosedegreecurricularplan", finantialEntity.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.createinsertinstallments(finantialEntity, executionYear, bean, model);
        }
    }

    @RequestMapping(value={"/backtochoosedegreecurricularplans/{finantialEntityId}/{executionYearId}"})
    public String processBackToChooseDegreeCurricularPlansAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("createchoosedegreecurricularplans");
    }

    @RequestMapping(value={"/backtodefinestudentconditions/{finantialEntityId}/{executionYearId}"}, method={RequestMethod.POST})
    public String processBackToDefineStudentConditionsAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("createdefinestudentconditions");
    }

    @RequestMapping(value={"/paymentplanorderup/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}/{tuitionPaymentPlanId}"}, method={RequestMethod.GET})
    public String processOrderUpAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @PathVariable(value="tuitionPaymentPlanId") TuitionPaymentPlan tuitionPaymentPlan, Model model, RedirectAttributes redirectAttributes) {
        try {
            tuitionPaymentPlan.orderUp();
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlan.order.up.success", (String[])new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(String.format("/academictreasury/managetuitionpaymentplan/tuitionpaymentplan//%s/%s/%s", finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/paymentplanorderdown/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}/{tuitionPaymentPlanId}"}, method={RequestMethod.GET})
    public String processOrderDownAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @PathVariable(value="tuitionPaymentPlanId") TuitionPaymentPlan tuitionPaymentPlan, Model model, RedirectAttributes redirectAttributes) {
        try {
            tuitionPaymentPlan.orderDown();
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlan.order.down.success", (String[])new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(String.format("/academictreasury/managetuitionpaymentplan/tuitionpaymentplan//%s/%s/%s", finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/copypaymentplanchooseexecutionyeardegreecurricularplans/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}/{tuitionPaymentPlanId}"}, method={RequestMethod.GET})
    public String copyPaymentPlanChooseExecutionYearDegreeCurricularPlans(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @PathVariable(value="tuitionPaymentPlanId") TuitionPaymentPlan tuitionPaymentPlan, Model model) {
        TuitionPaymentPlanBean tuitionPaymentPlanBean = new TuitionPaymentPlanBean(tuitionPaymentPlan);
        return this._copyPaymentPlanChooseExecutionYearDegreeCurricularPlans(finantialEntity, executionYear, degreeCurricularPlan, model, tuitionPaymentPlanBean);
    }

    private String _copyPaymentPlanChooseExecutionYearDegreeCurricularPlans(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, Model model, TuitionPaymentPlanBean tuitionPaymentPlanBean) {
        model.addAttribute("tuitionPaymentPlanBean", (Object)tuitionPaymentPlanBean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(tuitionPaymentPlanBean));
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        return this.jspPage("copypaymentplanchooseexecutionyeardegreecurricularplans");
    }

    @RequestMapping(value={"/copypaymentplanchooseexecutionyeardegreecurricularplanspostback/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> copyPaymentPlanChooseExecutionYearDegreeCurricularPlansPostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/copypaymentplanconfirm/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}"}, method={RequestMethod.POST})
    public String copyPaymentPlanConfirm(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model, RedirectAttributes redirectAttributes) {
        bean.updateDatesBasedOnSelectedExecutionYear();
        model.addAttribute("tuitionPaymentPlanBean", (Object)bean);
        model.addAttribute("tuitionPaymentPlanBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        return this.jspPage("copypaymentplanconfirm");
    }

    @RequestMapping(value={"/copypaymentplan/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}"}, method={RequestMethod.POST})
    public String copyPaymentPlan(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            TuitionPaymentPlan.create(bean);
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlan.copy.success", (String[])new String[0]), model);
            return this.redirect(String.format("%s/%s/%s", "/academictreasury/managetuitionpaymentplan/degreecurricularplan/choosedegreecurricularplan", finantialEntity.getExternalId(), bean.getExecutionYear().getExternalId()), model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.copyPaymentPlanConfirm(finantialEntity, executionYear, degreeCurricularPlan, bean, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/cancelcopypaymentplan/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}"}, method={RequestMethod.POST})
    public String cancelCopyPaymentPlan(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(String.format("%s/%s/%s/%s", SEARCH_URL, finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/backcopypaymentplanchooseexecutionyear/{finantialEntityId}/{executionYearId}/{degreeCurricularPlanId}"}, method={RequestMethod.POST})
    public String backCopyPaymentPlanChooseExecutionYear(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="executionYearId") ExecutionYear executionYear, @PathVariable(value="degreeCurricularPlanId") DegreeCurricularPlan degreeCurricularPlan, @RequestParam(value="bean") TuitionPaymentPlanBean bean, Model model) {
        return this._copyPaymentPlanChooseExecutionYearDegreeCurricularPlans(finantialEntity, executionYear, degreeCurricularPlan, model, bean);
    }

    @RequestMapping(value={"/edittuitioninstallment/{tuitionInstallmentTariffId}"}, method={RequestMethod.GET})
    public String editTuitionInstallment(@PathVariable(value="tuitionInstallmentTariffId") TuitionInstallmentTariff tuitionInstallmentTariff, Model model) {
        return this._editTuitionInstallment(tuitionInstallmentTariff, model, new AcademicTariffBean(tuitionInstallmentTariff));
    }

    private String _editTuitionInstallment(TuitionInstallmentTariff tuitionInstallmentTariff, Model model, AcademicTariffBean academicTariffBean) {
        model.addAttribute("tuitionInstallmentTariff", (Object)tuitionInstallmentTariff);
        model.addAttribute("bean", (Object)academicTariffBean);
        model.addAttribute("academicTariffBeanJson", (Object)this.getBeanJson(academicTariffBean));
        FinantialEntity finantialEntity = tuitionInstallmentTariff.getFinantialEntity();
        ExecutionYear executionYear = tuitionInstallmentTariff.getTuitionPaymentPlan().getExecutionYear();
        DegreeCurricularPlan degreeCurricularPlan = tuitionInstallmentTariff.getTuitionPaymentPlan().getDegreeCurricularPlan();
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("executionYear", (Object)executionYear);
        model.addAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        return this.jspPage("edittuitioninstallment");
    }

    @RequestMapping(value={"/edittuitioninstallment/{tuitionInstallmentTariffId}"}, method={RequestMethod.POST})
    public String editTuitionInstallment(@PathVariable(value="tuitionInstallmentTariffId") TuitionInstallmentTariff tuitionInstallmentTariff, Model model, @RequestParam(value="bean") AcademicTariffBean bean, RedirectAttributes redirectAttributes) {
        try {
            tuitionInstallmentTariff.edit(bean);
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.TuitionPaymentPlan.edit.success", (String[])new String[0]), model);
            FinantialEntity finantialEntity = tuitionInstallmentTariff.getFinantialEntity();
            ExecutionYear executionYear = tuitionInstallmentTariff.getTuitionPaymentPlan().getExecutionYear();
            DegreeCurricularPlan degreeCurricularPlan = tuitionInstallmentTariff.getTuitionPaymentPlan().getDegreeCurricularPlan();
            return this.redirect(String.format("%s/%s/%s/%s", SEARCH_URL, finantialEntity.getExternalId(), executionYear.getExternalId(), degreeCurricularPlan.getExternalId()), model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this._editTuitionInstallment(tuitionInstallmentTariff, model, bean);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/managetuitionpaymentplan/tuitionpaymentplan/" + page;
    }
}

