/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.academictaxdebtcreation;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.dto.academictax.AcademicTaxDebtCreationBean;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/academictreasury/academictaxdebtcreation/academictaxdebtcreationbean"})
public class AcademicTaxDebtCreationBeanController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/academictaxdebtcreation/academictaxdebtcreationbean";
    private static final String JSP_PATH = "academicTreasury/academictaxdebtcreation/academictaxdebtcreationbean";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/academictaxdebtcreation/academictaxdebtcreationbean/create";
    private static final String _BACKTOCREATE_URI = "/backtocreate";
    public static final String BACKTOCREATE_URL = "/academictreasury/academictaxdebtcreation/academictaxdebtcreationbean/backtocreate";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/academictaxdebtcreation/academictaxdebtcreationbean/createpostback";
    private static final String _CONFIRMACADEMICTAXDEBTCREATION_URI = "/confirmacademictaxdebtcreation";
    public static final String CONFIRMACADEMICTAXDEBTCREATION_URL = "/academictreasury/academictaxdebtcreation/academictaxdebtcreationbean/confirmacademictaxdebtcreation";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/academictaxdebtcreation/academictaxdebtcreationbean/create/";
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        AcademicTaxDebtCreationBean bean = new AcademicTaxDebtCreationBean(debtAccount);
        return this._createFirstPage(debtAccount, bean, model);
    }

    @RequestMapping(value={"/backtocreate/{debtAccountId}"}, method={RequestMethod.POST})
    public String backTocreate(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) AcademicTaxDebtCreationBean bean, Model model) {
        return this._createFirstPage(debtAccount, bean, model);
    }

    public String _createFirstPage(DebtAccount debtAccount, AcademicTaxDebtCreationBean bean, Model model) {
        model.addAttribute("AcademicTaxDebtCreationBean_executionYear_options", (Object)ExecutionYear.readNotClosedExecutionYears());
        model.addAttribute("AcademicTaxDebtCreationBean_registration_options", (Object)((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent().getRegistrationsSet());
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("academicTaxDebtCreationBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/createpostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) AcademicTaxDebtCreationBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) AcademicTaxDebtCreationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            boolean dataMissing = false;
            if (bean.getRegistration() == null) {
                this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.registration.required", new String[0]), model);
                dataMissing = true;
            }
            if (bean.getExecutionYear() == null) {
                this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.executionYear.required", new String[0]), model);
                dataMissing = true;
            }
            if (bean.getDebtDate() == null) {
                this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.debtDate.required", new String[0]), model);
                dataMissing = true;
            }
            if (bean.getAcademicTax() == null) {
                this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.academicTax.required", new String[0]), model);
                dataMissing = true;
            }
            if (bean.isImprovementTax() && bean.getImprovementEvaluation() == null) {
                this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.improvementEvaluation.required", new String[0]), model);
                dataMissing = true;
            }
            if (dataMissing) {
                return this._createFirstPage(debtAccount, bean, model);
            }
            if (bean.isImprovementTax() && AcademicTaxServices.findAcademicTariff(bean.getImprovementEvaluation(), bean.getDebtDate()) == null) {
                this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.tariff.not.found", new String[0]), model);
                return this._createFirstPage(debtAccount, bean, model);
            }
            if (AcademicTaxServices.findAcademicTariff(bean.getAcademicTax(), bean.getRegistration(), bean.getDebtDate()) == null) {
                this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.tariff.not.found", new String[0]), model);
                dataMissing = true;
                return this._createFirstPage(debtAccount, bean, model);
            }
            if (bean.isImprovementTax()) {
                AcademicTreasuryEvent event = AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(bean.getRegistration(), bean.getExecutionYear());
                if (event != null && event.isChargedWithDebitEntry(bean.getImprovementEvaluation())) {
                    this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.event.is.charged", new String[0]), model);
                    return this._createFirstPage(debtAccount, bean, model);
                }
            } else {
                AcademicTreasuryEvent event = AcademicTaxServices.findAcademicTreasuryEvent(bean.getRegistration(), bean.getExecutionYear(), bean.getAcademicTax());
                if (event != null && event.isChargedWithDebitEntry()) {
                    this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.event.is.charged", new String[0]), model);
                    return this._createFirstPage(debtAccount, bean, model);
                }
            }
            if (!bean.getAcademicTax().isImprovementTax() && !AcademicTaxServices.isAppliableOnRegistration(bean.getAcademicTax(), bean.getRegistration(), bean.getExecutionYear())) {
                if (AcademicTaxServices.isRegistrationFirstYear(bean.getRegistration(), bean.getExecutionYear())) {
                    this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.academicTax.not.for.first.year", new String[0]), model);
                } else {
                    this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.academicTax.not.for.subsequent.years", new String[0]), model);
                }
                return this._createFirstPage(debtAccount, bean, model);
            }
            if (bean.isCharged()) {
                this.addErrorMessage(Constants.academicTreasuryBundle("error.AcademicTaxDebtCreation.academic.tax.already.charged", new String[0]), model);
                return this._createFirstPage(debtAccount, bean, model);
            }
            model.addAttribute("debtAccount", (Object)debtAccount);
            model.addAttribute("bean", (Object)bean);
            model.addAttribute("academicTaxDebtCreationBeanJson", (Object)this.getBeanJson(bean));
            if (bean.isImprovementTax()) {
                model.addAttribute("debt", (Object)AcademicTaxServices.calculateImprovementTax(bean.getImprovementEvaluation(), bean.getDebtDate()));
            } else {
                model.addAttribute("debt", (Object)AcademicTaxServices.calculateAcademicTax(bean.getRegistration(), bean.getExecutionYear(), bean.getAcademicTax(), bean.getDebtDate(), true));
            }
            return this.jspPage("confirmacademictaxdebtcreation");
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createFirstPage(debtAccount, bean, model);
        }
    }

    @RequestMapping(value={"/confirmacademictaxdebtcreation/{debtAccountId}"}, method={RequestMethod.POST})
    public String confirmacademictaxdebtcreation(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) AcademicTaxDebtCreationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (bean.isImprovementTax()) {
                AcademicTaxServices.createImprovementTax(bean.getImprovementEvaluation(), bean.getDebtDate());
            } else {
                AcademicTaxServices.createAcademicTax(bean.getRegistration(), bean.getExecutionYear(), bean.getAcademicTax(), bean.getDebtDate(), true);
            }
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.AcademicTax.debit.entries.created.success", (String[])new String[0]), model);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read//" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.create(debtAccount, bean, model, redirectAttributes);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/academictaxdebtcreation/academictaxdebtcreationbean/" + page;
    }
}

