/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tuition.TuitionDebitEntryBean;
import org.fenixedu.academictreasury.services.TuitionServices$callable$calculateInstallmentDebitEntryBeans;
import org.fenixedu.academictreasury.services.TuitionServices$callable$calculateInstallmentDebitEntryBeans$1;
import org.fenixedu.academictreasury.services.TuitionServices$callable$calculateInstallmentDebitEntryBeansForExtracurricular;
import org.fenixedu.academictreasury.services.TuitionServices$callable$calculateInstallmentDebitEntryBeansForExtracurricular$1;
import org.fenixedu.academictreasury.services.TuitionServices$callable$calculateInstallmentDebitEntryBeansForStandalone;
import org.fenixedu.academictreasury.services.TuitionServices$callable$calculateInstallmentDebitEntryBeansForStandalone$1;
import org.fenixedu.academictreasury.services.TuitionServices$callable$createInferedTuitionForExtracurricular;
import org.fenixedu.academictreasury.services.TuitionServices$callable$createInferedTuitionForExtracurricular$1;
import org.fenixedu.academictreasury.services.TuitionServices$callable$createInferedTuitionForRegistration;
import org.fenixedu.academictreasury.services.TuitionServices$callable$createInferedTuitionForStandalone;
import org.fenixedu.academictreasury.services.TuitionServices$callable$createInferedTuitionForStandalone$1;
import org.fenixedu.academictreasury.services.TuitionServices$callable$createTuitionForExtracurricular;
import org.fenixedu.academictreasury.services.TuitionServices$callable$createTuitionForRegistration;
import org.fenixedu.academictreasury.services.TuitionServices$callable$createTuitionForStandalone;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TuitionServices {
    public static final Advice advice$createInferedTuitionForRegistration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createTuitionForRegistration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$calculateInstallmentDebitEntryBeans = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$calculateInstallmentDebitEntryBeans$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createInferedTuitionForStandalone = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createInferedTuitionForStandalone$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createTuitionForStandalone = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$calculateInstallmentDebitEntryBeansForStandalone = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$calculateInstallmentDebitEntryBeansForStandalone$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createInferedTuitionForExtracurricular = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createInferedTuitionForExtracurricular$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createTuitionForExtracurricular = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$calculateInstallmentDebitEntryBeansForExtracurricular = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$calculateInstallmentDebitEntryBeansForExtracurricular$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static boolean isToPayRegistrationTuition(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationProtocol().isToPayGratuity();
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEventTuitionForRegistration(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).orElse(null);
    }

    public static boolean isTuitionForRegistrationCharged(Registration registration, ExecutionYear executionYear) {
        if (!AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).isPresent()) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).get();
        return academicTreasuryEvent.isCharged();
    }

    public static boolean createInferedTuitionForRegistration(Registration registration, ExecutionYear executionYear, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createInferedTuitionForRegistration.perform((Callable)new TuitionServices$callable$createInferedTuitionForRegistration(registration, executionYear, localDate, bl));
    }

    static /* synthetic */ boolean advised$createInferedTuitionForRegistration(Registration registration, ExecutionYear executionYear, LocalDate when, boolean forceCreationIfNotEnrolled) {
        return TuitionServices.createTuitionForRegistration(registration, executionYear, when, forceCreationIfNotEnrolled, null);
    }

    public static boolean createTuitionForRegistration(Registration registration, ExecutionYear executionYear, LocalDate localDate, boolean bl, TuitionPaymentPlan tuitionPaymentPlan) {
        return (Boolean)advice$createTuitionForRegistration.perform((Callable)new TuitionServices$callable$createTuitionForRegistration(registration, executionYear, localDate, bl, tuitionPaymentPlan));
    }

    static /* synthetic */ boolean advised$createTuitionForRegistration(Registration registration, ExecutionYear executionYear, LocalDate when, boolean forceCreationIfNotEnrolled, TuitionPaymentPlan tuitionPaymentPlan) {
        PersonCustomer personCustomer;
        if (!TuitionServices.isToPayRegistrationTuition(registration, executionYear) && !forceCreationIfNotEnrolled) {
            return false;
        }
        Person person = registration.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
        }
        if (tuitionPaymentPlan == null) {
            tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(registration, executionYear);
        }
        if (tuitionPaymentPlan == null) {
            return false;
        }
        if (!forceCreationIfNotEnrolled && tuitionPaymentPlan.isStudentMustBeEnrolled() && TuitionServices.normalEnrolments(registration, executionYear).isEmpty()) {
            return false;
        }
        if (!DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
            DebtAccount.create((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
        }
        if (!AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).isPresent()) {
            AcademicTreasuryEvent.createForRegistrationTuition(tuitionPaymentPlan.getProduct(), registration, executionYear);
        }
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).get();
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).get();
        return tuitionPaymentPlan.createDebitEntriesForRegistration(debtAccount, academicTreasuryEvent, when);
    }

    public static TuitionPaymentPlan usedPaymentPlan(Registration registration, ExecutionYear executionYear, LocalDate debtDate) {
        return TuitionServices.usedPaymentPlan(registration, executionYear, debtDate, null);
    }

    public static TuitionPaymentPlan usedPaymentPlan(Registration registration, ExecutionYear executionYear, LocalDate debtDate, TuitionPaymentPlan tuitionPaymentPlan) {
        if (tuitionPaymentPlan != null) {
            return tuitionPaymentPlan;
        }
        return TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(registration, executionYear);
    }

    public static List<TuitionDebitEntryBean> calculateInstallmentDebitEntryBeans(Registration registration, ExecutionYear executionYear, LocalDate localDate) {
        return (List)advice$calculateInstallmentDebitEntryBeans.perform((Callable)new TuitionServices$callable$calculateInstallmentDebitEntryBeans(registration, executionYear, localDate));
    }

    static /* synthetic */ List<TuitionDebitEntryBean> advised$calculateInstallmentDebitEntryBeans(Registration registration, ExecutionYear executionYear, LocalDate debtDate) {
        return TuitionServices.calculateInstallmentDebitEntryBeans(registration, executionYear, debtDate, null);
    }

    public static List<TuitionDebitEntryBean> calculateInstallmentDebitEntryBeans(Registration registration, ExecutionYear executionYear, LocalDate localDate, TuitionPaymentPlan tuitionPaymentPlan) {
        return (List)advice$calculateInstallmentDebitEntryBeans$1.perform((Callable)new TuitionServices$callable$calculateInstallmentDebitEntryBeans$1(registration, executionYear, localDate, tuitionPaymentPlan));
    }

    static /* synthetic */ List<TuitionDebitEntryBean> advised$calculateInstallmentDebitEntryBeans(Registration registration, ExecutionYear executionYear, LocalDate debtDate, TuitionPaymentPlan tuitionPaymentPlan) {
        PersonCustomer personCustomer;
        Person person = registration.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
        }
        if (tuitionPaymentPlan == null) {
            tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForRegistration(registration, executionYear);
        }
        if (tuitionPaymentPlan == null) {
            return Lists.newArrayList();
        }
        if (!DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
            DebtAccount.create((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
        }
        if (!AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).isPresent()) {
            AcademicTreasuryEvent.createForRegistrationTuition(tuitionPaymentPlan.getProduct(), registration, executionYear);
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForRegistrationTuition(registration, executionYear).get();
        ArrayList entries = Lists.newArrayList();
        for (TuitionInstallmentTariff tuitionInstallmentTariff : tuitionPaymentPlan.getTuitionInstallmentTariffsSet()) {
            int installmentOrder = tuitionInstallmentTariff.getInstallmentOrder();
            LocalizedString installmentName = tuitionPaymentPlan.installmentName(tuitionInstallmentTariff);
            LocalDate dueDate = tuitionInstallmentTariff.dueDate(debtDate);
            Vat vat = tuitionInstallmentTariff.vat(debtDate);
            BigDecimal amount = tuitionInstallmentTariff.amountToPay(academicTreasuryEvent);
            Currency currency = tuitionInstallmentTariff.getFinantialEntity().getFinantialInstitution().getCurrency();
            entries.add(new TuitionDebitEntryBean(installmentOrder, installmentName, dueDate, vat.getTaxRate(), amount, currency));
        }
        return entries.stream().sorted(new Comparator<TuitionDebitEntryBean>(){

            @Override
            public int compare(TuitionDebitEntryBean o1, TuitionDebitEntryBean o2) {
                return o1.getInstallmentOrder() - o2.getInstallmentOrder();
            }
        }).collect(Collectors.toList());
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEventTuitionForStandalone(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findUniqueForStandaloneTuition(registration, executionYear).orElse(null);
    }

    public static boolean isTuitionForStandaloneCharged(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        if (TuitionServices.findAcademicTreasuryEventTuitionForStandalone(registration, executionYear) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = TuitionServices.findAcademicTreasuryEventTuitionForStandalone(registration, executionYear);
        return academicTreasuryEvent.isChargedWithDebitEntry(enrolment);
    }

    public static boolean createInferedTuitionForStandalone(Enrolment enrolment, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createInferedTuitionForStandalone.perform((Callable)new TuitionServices$callable$createInferedTuitionForStandalone(enrolment, localDate, bl));
    }

    static /* synthetic */ boolean advised$createInferedTuitionForStandalone(Enrolment standaloneEnrolment, LocalDate when, boolean forceCreation) {
        return TuitionServices.createInferedTuitionForStandalone(Sets.newHashSet((Object[])new Enrolment[]{standaloneEnrolment}), when, forceCreation);
    }

    public static boolean createInferedTuitionForStandalone(Set<Enrolment> set, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createInferedTuitionForStandalone$1.perform((Callable)new TuitionServices$callable$createInferedTuitionForStandalone$1(set, localDate, bl));
    }

    static /* synthetic */ boolean advised$createInferedTuitionForStandalone(Set<Enrolment> standaloneEnrolments, LocalDate when, boolean forceCreation) {
        if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == null) {
            return false;
        }
        if (!TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().isPresent()) {
            return false;
        }
        boolean created = false;
        for (Enrolment standaloneEnrolment : standaloneEnrolments) {
            if (standaloneEnrolment.isStandalone()) continue;
            throw new AcademicTreasuryDomainException("error.TuitionServices.enrolment.is.not.standalone", new String[0]);
        }
        for (Enrolment standaloneEnrolment : standaloneEnrolments) {
            PersonCustomer personCustomer;
            Registration registration = standaloneEnrolment.getRegistration();
            Person person = registration.getPerson();
            String fiscalCountryCode = PersonCustomer.countryCode(person);
            String fiscalNumber = PersonCustomer.fiscalNumber(person);
            if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
            }
            if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
                PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
            }
            if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
            }
            ExecutionYear executionYear = standaloneEnrolment.getExecutionYear();
            if (TuitionPaymentPlan.inferTuitionPaymentPlanForStandaloneEnrolment(registration, executionYear, standaloneEnrolment) == null) continue;
            TuitionPaymentPlan tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForStandaloneEnrolment(registration, executionYear, standaloneEnrolment);
            created |= TuitionServices.createTuitionForStandalone(standaloneEnrolment, tuitionPaymentPlan, when, forceCreation);
        }
        return created;
    }

    public static boolean createTuitionForStandalone(Enrolment enrolment, TuitionPaymentPlan tuitionPaymentPlan, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createTuitionForStandalone.perform((Callable)new TuitionServices$callable$createTuitionForStandalone(enrolment, tuitionPaymentPlan, localDate, bl));
    }

    static /* synthetic */ boolean advised$createTuitionForStandalone(Enrolment standaloneEnrolment, TuitionPaymentPlan tuitionPaymentPlan, LocalDate when, boolean forceCreation) {
        PersonCustomer personCustomer;
        if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == null) {
            return false;
        }
        if (!TuitionPaymentPlanGroup.findUniqueDefaultGroupForStandalone().isPresent()) {
            return false;
        }
        Registration registration = standaloneEnrolment.getRegistration();
        ExecutionYear executionYear = standaloneEnrolment.getExecutionYear();
        Person person = registration.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
        }
        if (!TuitionServices.isToPayRegistrationTuition(registration, executionYear) && !forceCreation) {
            return false;
        }
        if (!DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
            DebtAccount.create((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
        }
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).get();
        if (!AcademicTreasuryEvent.findUniqueForStandaloneTuition(registration, executionYear).isPresent()) {
            AcademicTreasuryEvent.createForStandaloneTuition(tuitionPaymentPlan.getProduct(), registration, executionYear);
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForStandaloneTuition(registration, executionYear).get();
        if (debtAccount.getFinantialInstitution() != tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution()) {
            throw new AcademicTreasuryDomainException("error.TuitionServices.standalone.tuition.for.different.finantial.institutions.not.supported", new String[0]);
        }
        return tuitionPaymentPlan.createDebitEntriesForStandalone(debtAccount, academicTreasuryEvent, standaloneEnrolment, when);
    }

    public static TuitionPaymentPlan usedPaymentPlanForStandalone(Registration registration, ExecutionYear executionYear, Enrolment enrolment, LocalDate debtDate) {
        return TuitionServices.usedPaymentPlanForStandalone(registration, executionYear, enrolment, debtDate, null);
    }

    public static TuitionPaymentPlan usedPaymentPlanForStandalone(Registration registration, ExecutionYear executionYear, Enrolment enrolment, LocalDate debtDate, TuitionPaymentPlan tuitionPaymentPlan) {
        if (tuitionPaymentPlan != null) {
            return tuitionPaymentPlan;
        }
        return TuitionPaymentPlan.inferTuitionPaymentPlanForStandaloneEnrolment(registration, executionYear, enrolment);
    }

    public static List<TuitionDebitEntryBean> calculateInstallmentDebitEntryBeansForStandalone(Registration registration, ExecutionYear executionYear, LocalDate localDate, Set<Enrolment> set) {
        return (List)advice$calculateInstallmentDebitEntryBeansForStandalone.perform((Callable)new TuitionServices$callable$calculateInstallmentDebitEntryBeansForStandalone(registration, executionYear, localDate, set));
    }

    static /* synthetic */ List<TuitionDebitEntryBean> advised$calculateInstallmentDebitEntryBeansForStandalone(Registration registration, ExecutionYear executionYear, LocalDate debtDate, Set<Enrolment> enrolments) {
        return TuitionServices.calculateInstallmentDebitEntryBeansForStandalone(registration, executionYear, debtDate, null, enrolments);
    }

    public static List<TuitionDebitEntryBean> calculateInstallmentDebitEntryBeansForStandalone(Registration registration, ExecutionYear executionYear, LocalDate localDate, TuitionPaymentPlan tuitionPaymentPlan, Set<Enrolment> set) {
        return (List)advice$calculateInstallmentDebitEntryBeansForStandalone$1.perform((Callable)new TuitionServices$callable$calculateInstallmentDebitEntryBeansForStandalone$1(registration, executionYear, localDate, tuitionPaymentPlan, set));
    }

    static /* synthetic */ List<TuitionDebitEntryBean> advised$calculateInstallmentDebitEntryBeansForStandalone(Registration registration, ExecutionYear executionYear, LocalDate debtDate, TuitionPaymentPlan tuitionPaymentPlan, Set<Enrolment> enrolments) {
        PersonCustomer personCustomer;
        Person person = registration.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
        }
        ArrayList entries = Lists.newArrayList();
        for (Enrolment enrolment : enrolments) {
            if (tuitionPaymentPlan == null) {
                tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForStandaloneEnrolment(registration, executionYear, enrolment);
            }
            if (tuitionPaymentPlan == null) continue;
            if (!DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
                DebtAccount.create((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
            }
            DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).get();
            if (!AcademicTreasuryEvent.findUniqueForStandaloneTuition(registration, executionYear).isPresent()) {
                AcademicTreasuryEvent.createForStandaloneTuition(tuitionPaymentPlan.getProduct(), registration, executionYear);
            }
            AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForStandaloneTuition(registration, executionYear).get();
            TuitionInstallmentTariff tuitionInstallmentTariff = tuitionPaymentPlan.getStandaloneTuitionInstallmentTariff();
            int installmentOrder = tuitionInstallmentTariff.getInstallmentOrder();
            LocalizedString installmentName = tuitionInstallmentTariff.standaloneDebitEntryName(enrolment);
            LocalDate dueDate = tuitionInstallmentTariff.dueDate(debtDate);
            Vat vat = tuitionInstallmentTariff.vat(debtDate);
            BigDecimal amount = tuitionInstallmentTariff.amountToPay(academicTreasuryEvent, enrolment);
            Currency currency = tuitionInstallmentTariff.getFinantialEntity().getFinantialInstitution().getCurrency();
            entries.add(new TuitionDebitEntryBean(installmentOrder, installmentName, dueDate, vat.getTaxRate(), amount, currency));
        }
        return entries.stream().sorted(new Comparator<TuitionDebitEntryBean>(){

            @Override
            public int compare(TuitionDebitEntryBean o1, TuitionDebitEntryBean o2) {
                return o1.getInstallmentOrder() - o2.getInstallmentOrder();
            }
        }).collect(Collectors.toList());
    }

    public static boolean removeDebitEntryForStandaloneEnrolment(Enrolment standaloneEnrolment) {
        ExecutionYear executionYear;
        Registration registration = standaloneEnrolment.getRegistration();
        if (!AcademicTreasuryEvent.findUniqueForStandaloneTuition(registration, executionYear = standaloneEnrolment.getExecutionYear()).isPresent()) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForStandaloneTuition(registration, executionYear).get();
        if (!academicTreasuryEvent.isChargedWithDebitEntry(standaloneEnrolment)) {
            return false;
        }
        DebitEntry debitEntry = academicTreasuryEvent.findActiveEnrolmentDebitEntry(standaloneEnrolment).get();
        DebitNote debitNote = (DebitNote)debitEntry.getFinantialDocument();
        if (!debitEntry.isProcessedInDebitNote()) {
            debitEntry.annulDebitEntry(Constants.academicTreasuryBundle("label.TuitionServices.removeDebitEntryForStandaloneEnrolment.reason", new String[0]));
        } else {
            debitNote.anullDebitNoteWithCreditNote(Constants.academicTreasuryBundle("label.TuitionServices.removeDebitEntryForStandaloneEnrolment.reason", new String[0]), false);
        }
        return true;
    }

    public static AcademicTreasuryEvent findAcademicTreasuryEventTuitionForExtracurricular(Registration registration, ExecutionYear executionYear) {
        return AcademicTreasuryEvent.findUniqueForExtracurricularTuition(registration, executionYear).orElse(null);
    }

    public static boolean isTuitionForExtracurricularCharged(Registration registration, ExecutionYear executionYear, Enrolment enrolment) {
        if (TuitionServices.findAcademicTreasuryEventTuitionForExtracurricular(registration, executionYear) == null) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = TuitionServices.findAcademicTreasuryEventTuitionForExtracurricular(registration, executionYear);
        return academicTreasuryEvent.isChargedWithDebitEntry(enrolment);
    }

    public static boolean createInferedTuitionForExtracurricular(Enrolment enrolment, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createInferedTuitionForExtracurricular.perform((Callable)new TuitionServices$callable$createInferedTuitionForExtracurricular(enrolment, localDate, bl));
    }

    static /* synthetic */ boolean advised$createInferedTuitionForExtracurricular(Enrolment extracurricularEnrolment, LocalDate when, boolean forceCreation) {
        return TuitionServices.createInferedTuitionForExtracurricular(Sets.newHashSet((Object[])new Enrolment[]{extracurricularEnrolment}), when, forceCreation);
    }

    public static boolean createInferedTuitionForExtracurricular(Set<Enrolment> set, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createInferedTuitionForExtracurricular$1.perform((Callable)new TuitionServices$callable$createInferedTuitionForExtracurricular$1(set, localDate, bl));
    }

    static /* synthetic */ boolean advised$createInferedTuitionForExtracurricular(Set<Enrolment> extracurricularEnrolments, LocalDate when, boolean forceCreation) {
        if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == null) {
            return false;
        }
        if (!TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().isPresent()) {
            return false;
        }
        boolean created = false;
        for (Enrolment extracurricularEnrolment : extracurricularEnrolments) {
            if (extracurricularEnrolment.isExtraCurricular()) continue;
            throw new AcademicTreasuryDomainException("error.TuitionServices.enrolment.is.not.extracurricular", new String[0]);
        }
        for (Enrolment extracurricularEnrolment : extracurricularEnrolments) {
            PersonCustomer personCustomer;
            Registration registration = extracurricularEnrolment.getRegistration();
            Person person = registration.getPerson();
            String fiscalCountryCode = PersonCustomer.countryCode(person);
            String fiscalNumber = PersonCustomer.fiscalNumber(person);
            if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
            }
            if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
                PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
            }
            if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
                throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
            }
            ExecutionYear executionYear = extracurricularEnrolment.getExecutionYear();
            if (TuitionPaymentPlan.inferTuitionPaymentPlanForExtracurricularEnrolment(registration, executionYear, extracurricularEnrolment) == null) continue;
            TuitionPaymentPlan tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForExtracurricularEnrolment(registration, executionYear, extracurricularEnrolment);
            created |= TuitionServices.createTuitionForExtracurricular(extracurricularEnrolment, tuitionPaymentPlan, when, forceCreation);
        }
        return created;
    }

    public static boolean createTuitionForExtracurricular(Enrolment enrolment, TuitionPaymentPlan tuitionPaymentPlan, LocalDate localDate, boolean bl) {
        return (Boolean)advice$createTuitionForExtracurricular.perform((Callable)new TuitionServices$callable$createTuitionForExtracurricular(enrolment, tuitionPaymentPlan, localDate, bl));
    }

    static /* synthetic */ boolean advised$createTuitionForExtracurricular(Enrolment extracurricularEnrolment, TuitionPaymentPlan tuitionPaymentPlan, LocalDate when, boolean forceCreation) {
        PersonCustomer personCustomer;
        if (AcademicTreasurySettings.getInstance().getTuitionProductGroup() == null) {
            return false;
        }
        if (!TuitionPaymentPlanGroup.findUniqueDefaultGroupForExtracurricular().isPresent()) {
            return false;
        }
        Registration registration = extracurricularEnrolment.getRegistration();
        ExecutionYear executionYear = extracurricularEnrolment.getExecutionYear();
        Person person = registration.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
        }
        if (!TuitionServices.isToPayRegistrationTuition(registration, executionYear) && !forceCreation) {
            return false;
        }
        if (!DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
            DebtAccount.create((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
        }
        DebtAccount debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).get();
        if (!AcademicTreasuryEvent.findUniqueForExtracurricularTuition(registration, executionYear).isPresent()) {
            AcademicTreasuryEvent.createForExtracurricularTuition(tuitionPaymentPlan.getProduct(), registration, executionYear);
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForExtracurricularTuition(registration, executionYear).get();
        if (debtAccount.getFinantialInstitution() != tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution()) {
            throw new AcademicTreasuryDomainException("error.TuitionServices.standalone.tuition.for.different.finantial.institutions.not.supported", new String[0]);
        }
        return tuitionPaymentPlan.createDebitEntriesForExtracurricular(debtAccount, academicTreasuryEvent, extracurricularEnrolment, when);
    }

    public static TuitionPaymentPlan usedPaymentPlanForExtracurricular(Registration registration, ExecutionYear executionYear, Enrolment enrolment, LocalDate debtDate) {
        return TuitionServices.usedPaymentPlanForExtracurricular(registration, executionYear, enrolment, debtDate, null);
    }

    public static TuitionPaymentPlan usedPaymentPlanForExtracurricular(Registration registration, ExecutionYear executionYear, Enrolment enrolment, LocalDate debtDate, TuitionPaymentPlan tuitionPaymentPlan) {
        if (tuitionPaymentPlan != null) {
            return tuitionPaymentPlan;
        }
        return TuitionPaymentPlan.inferTuitionPaymentPlanForExtracurricularEnrolment(registration, executionYear, enrolment);
    }

    public static List<TuitionDebitEntryBean> calculateInstallmentDebitEntryBeansForExtracurricular(Registration registration, ExecutionYear executionYear, LocalDate localDate, Set<Enrolment> set) {
        return (List)advice$calculateInstallmentDebitEntryBeansForExtracurricular.perform((Callable)new TuitionServices$callable$calculateInstallmentDebitEntryBeansForExtracurricular(registration, executionYear, localDate, set));
    }

    static /* synthetic */ List<TuitionDebitEntryBean> advised$calculateInstallmentDebitEntryBeansForExtracurricular(Registration registration, ExecutionYear executionYear, LocalDate debtDate, Set<Enrolment> enrolments) {
        return TuitionServices.calculateInstallmentDebitEntryBeansForExtracurricular(registration, executionYear, debtDate, null, enrolments);
    }

    public static List<TuitionDebitEntryBean> calculateInstallmentDebitEntryBeansForExtracurricular(Registration registration, ExecutionYear executionYear, LocalDate localDate, TuitionPaymentPlan tuitionPaymentPlan, Set<Enrolment> set) {
        return (List)advice$calculateInstallmentDebitEntryBeansForExtracurricular$1.perform((Callable)new TuitionServices$callable$calculateInstallmentDebitEntryBeansForExtracurricular$1(registration, executionYear, localDate, tuitionPaymentPlan, set));
    }

    static /* synthetic */ List<TuitionDebitEntryBean> advised$calculateInstallmentDebitEntryBeansForExtracurricular(Registration registration, ExecutionYear executionYear, LocalDate debtDate, TuitionPaymentPlan tuitionPaymentPlan, Set<Enrolment> enrolments) {
        PersonCustomer personCustomer;
        Person person = registration.getPerson();
        String fiscalCountryCode = PersonCustomer.countryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (!PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).isPresent()) {
            PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        }
        if (!(personCustomer = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber).get()).isActive()) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.not.active", fiscalCountryCode, fiscalNumber);
        }
        ArrayList entries = Lists.newArrayList();
        for (Enrolment enrolment : enrolments) {
            if (tuitionPaymentPlan == null) {
                tuitionPaymentPlan = TuitionPaymentPlan.inferTuitionPaymentPlanForExtracurricularEnrolment(registration, executionYear, enrolment);
            }
            if (tuitionPaymentPlan == null) continue;
            if (!DebtAccount.findUnique((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer).isPresent()) {
                DebtAccount.create((FinantialInstitution)tuitionPaymentPlan.getFinantialEntity().getFinantialInstitution(), (Customer)personCustomer);
            }
            if (!AcademicTreasuryEvent.findUniqueForExtracurricularTuition(registration, executionYear).isPresent()) {
                AcademicTreasuryEvent.createForExtracurricularTuition(tuitionPaymentPlan.getProduct(), registration, executionYear);
            }
            AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForExtracurricularTuition(registration, executionYear).get();
            TuitionInstallmentTariff tuitionInstallmentTariff = tuitionPaymentPlan.getExtracurricularTuitionInstallmentTariff();
            int installmentOrder = tuitionInstallmentTariff.getInstallmentOrder();
            LocalizedString installmentName = tuitionInstallmentTariff.extracurricularDebitEntryName(enrolment);
            LocalDate dueDate = tuitionInstallmentTariff.dueDate(debtDate);
            Vat vat = tuitionInstallmentTariff.vat(debtDate);
            BigDecimal amount = tuitionInstallmentTariff.amountToPay(academicTreasuryEvent, enrolment);
            Currency currency = tuitionInstallmentTariff.getFinantialEntity().getFinantialInstitution().getCurrency();
            entries.add(new TuitionDebitEntryBean(installmentOrder, installmentName, dueDate, vat.getTaxRate(), amount, currency));
        }
        return entries.stream().sorted(new Comparator<TuitionDebitEntryBean>(){

            @Override
            public int compare(TuitionDebitEntryBean o1, TuitionDebitEntryBean o2) {
                return o1.getInstallmentOrder() - o2.getInstallmentOrder();
            }
        }).collect(Collectors.toList());
    }

    public static boolean removeDebitEntryForExtracurricularEnrolment(Enrolment extracurricularEnrolment) {
        ExecutionYear executionYear;
        Registration registration = extracurricularEnrolment.getRegistration();
        if (!AcademicTreasuryEvent.findUniqueForExtracurricularTuition(registration, executionYear = extracurricularEnrolment.getExecutionYear()).isPresent()) {
            return false;
        }
        AcademicTreasuryEvent academicTreasuryEvent = AcademicTreasuryEvent.findUniqueForExtracurricularTuition(registration, executionYear).get();
        if (!academicTreasuryEvent.isChargedWithDebitEntry(extracurricularEnrolment)) {
            return false;
        }
        DebitEntry debitEntry = academicTreasuryEvent.findActiveEnrolmentDebitEntry(extracurricularEnrolment).get();
        DebitNote debitNote = (DebitNote)debitEntry.getFinantialDocument();
        if (!debitEntry.isProcessedInDebitNote()) {
            debitEntry.annulDebitEntry(Constants.academicTreasuryBundle("label.TuitionServices.removeDebitEntryForExtracurricularEnrolment.reason", new String[0]));
        } else {
            debitNote.anullDebitNoteWithCreditNote(Constants.academicTreasuryBundle("label.TuitionServices.removeDebitEntryForExtracurricularEnrolment.reason", new String[0]), false);
        }
        return true;
    }

    public static LocalDate enrolmentDate(Registration registration, ExecutionYear executionYear, boolean isToForceCreation) {
        for (RegistrationDataByExecutionYear registrationDataByExecutionYear : registration.getRegistrationDataByExecutionYearSet()) {
            if (registrationDataByExecutionYear.getExecutionYear() != executionYear || registrationDataByExecutionYear.getEnrolmentDate() == null) continue;
            return registrationDataByExecutionYear.getEnrolmentDate();
        }
        if (isToForceCreation) {
            int i = 0;
            ExecutionYear it = executionYear.getPreviousExecutionYear();
            while (it != null) {
                if (TuitionServices.registrationDataByExecutionYear(registration, it) != null && TuitionServices.registrationDataByExecutionYear(registration, it).getEnrolmentDate() != null) {
                    return TuitionServices.registrationDataByExecutionYear(registration, it).getEnrolmentDate().plusYears(i);
                }
                it = it.getPreviousExecutionYear();
                ++i;
            }
        }
        return new LocalDate();
    }

    public static LocalDate lastRegisteredDate(Registration registration, ExecutionYear executionYear) {
        RegistrationState lastRegistrationState = registration.getLastRegistrationState(executionYear);
        if (lastRegistrationState == null) {
            return null;
        }
        if (!lastRegistrationState.isActive()) {
            return null;
        }
        LocalDate stateDate = lastRegistrationState.getStateDate().toLocalDate();
        LocalDate dateOnBeginExecutionYearCivilDate = new LocalDate(executionYear.getBeginCivilYear(), stateDate.getMonthOfYear(), stateDate.getDayOfMonth());
        LocalDate dateOnEndExecutionYearCivilDate = new LocalDate(executionYear.getEndCivilYear(), stateDate.getMonthOfYear(), stateDate.getDayOfMonth());
        if (executionYear.containsDate(dateOnBeginExecutionYearCivilDate)) {
            return dateOnBeginExecutionYearCivilDate;
        }
        if (executionYear.containsDate(dateOnEndExecutionYearCivilDate)) {
            return dateOnEndExecutionYearCivilDate;
        }
        return null;
    }

    public static List<ExecutionYear> orderedEnrolledExecutionYears(Registration registration) {
        return registration.getEnrolmentsExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList());
    }

    public static List<ExecutionYear> orderedEnrolledAndImprovementExecutionYears(Registration registration) {
        HashSet result = Sets.newHashSet();
        result.addAll(registration.getEnrolmentsExecutionYears().stream().collect(Collectors.toSet()));
        result.addAll(registration.getStudentCurricularPlansSet().stream().map(l -> l.getEnrolmentsSet()).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Sets.newHashSet()).stream().map(l -> l.getEvaluationsSet()).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Sets.newHashSet()).stream().filter(l -> l.getEvaluationSeason().isImprovement() && l.getExecutionPeriod() != null).map(l -> l.getExecutionPeriod().getExecutionYear()).collect(Collectors.toSet()));
        return result.stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList());
    }

    public static Set<Enrolment> normalEnrolments(Registration registration, ExecutionYear executionYear) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (studentCurricularPlan == null) {
            return Sets.newHashSet();
        }
        HashSet result = Sets.newHashSet((Iterable)registration.getEnrolments(executionYear));
        result.removeAll(studentCurricularPlan.getStandaloneCurriculumLines().stream().filter(l -> l.getExecutionYear() == executionYear && l.isEnrolment()).collect(Collectors.toList()));
        result.removeAll(studentCurricularPlan.getExtraCurricularCurriculumLines().stream().filter(l -> l.getExecutionYear() == executionYear && l.isEnrolment()).collect(Collectors.toList()));
        result.removeAll(studentCurricularPlan.getPropaedeuticCurriculumLines().stream().filter(l -> l.getExecutionYear() == executionYear && l.isEnrolment()).collect(Collectors.toList()));
        return result;
    }

    public static Set<Enrolment> standaloneEnrolments(Registration registration, ExecutionYear executionYear) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (studentCurricularPlan == null) {
            return Sets.newHashSet();
        }
        return studentCurricularPlan.getStandaloneCurriculumLines().stream().filter(l -> l.getExecutionYear() == executionYear && l.isEnrolment()).map(l -> (Enrolment)l).collect(Collectors.toSet());
    }

    public static Set<Enrolment> extracurricularEnrolments(Registration registration, ExecutionYear executionYear) {
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (studentCurricularPlan == null) {
            return Sets.newHashSet();
        }
        return studentCurricularPlan.getExtraCurricularCurriculumLines().stream().filter(l -> l.getExecutionYear() == executionYear && l.isEnrolment()).map(l -> (Enrolment)l).collect(Collectors.toSet());
    }

    public static Set<EnrolmentEvaluation> improvementEnrolments(Registration registration, ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
        if (studentCurricularPlan == null) {
            return result;
        }
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            result.addAll(studentCurricularPlan.getEnroledImprovements(executionSemester));
        }
        return result;
    }

    private static RegistrationDataByExecutionYear registrationDataByExecutionYear(Registration registration, ExecutionYear executionYear) {
        return registration.getRegistrationDataByExecutionYearSet().stream().filter(l -> l.getExecutionYear() == executionYear).findFirst().orElse(null);
    }
}

