/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.springframework.util.StringUtils;

public class PaymentReportEntryBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_HEADERS = new String[]{Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.identification", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.creationDate", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.responsible", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.settlementNoteNumber", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.settlementNoteDocumentDate", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.paymentDate", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.settlementNoteAnnuled", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.documentExportationPending", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.paymentMethod", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.amount", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.customerId", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.debtAccountId", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.name", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.identificationType", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.identificationNumber", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.vatNumber", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.email", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.address", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.studentNumber", new String[0]), Constants.academicTreasuryBundle("label.PaymentReportEntryBean.header.closeDate", new String[0])};
    private PaymentEntry paymentEntry;
    private boolean completed;
    private String identification;
    private DateTime creationDate;
    private String responsible;
    private String settlementNoteNumber;
    private DateTime settlementNoteDocumentDate;
    private DateTime paymentDate;
    private boolean settlementNoteAnnuled;
    private boolean documentExportationPending;
    private String paymentMethod;
    private String amount;
    private String customerId;
    private String debtAccountId;
    private String name;
    private LocalizedString identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String email;
    private String address;
    private Integer studentNumber;
    private DateTime closeDate;

    public PaymentReportEntryBean(PaymentEntry entry, DebtReportRequest request, ErrorsLog errorsLog) {
        String decimalSeparator = request.getDecimalSeparator();
        this.paymentEntry = entry;
        try {
            SettlementNote settlementNote = entry.getSettlementNote();
            this.identification = entry.getExternalId();
            this.creationDate = entry.getVersioningCreationDate();
            this.responsible = entry.getVersioningCreator();
            this.settlementNoteNumber = settlementNote.getUiDocumentNumber();
            this.settlementNoteDocumentDate = settlementNote.getDocumentDate();
            this.paymentDate = settlementNote.getPaymentDate();
            this.settlementNoteAnnuled = settlementNote.isAnnulled();
            this.documentExportationPending = settlementNote.isDocumentToExport();
            this.paymentMethod = entry.getPaymentMethod().getName().getContent();
            this.amount = settlementNote.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(entry.getPayedAmount()).toString();
            if (",".equals(decimalSeparator)) {
                this.amount = this.amount.replace(".", ",");
            }
            this.fillStudentInformation(entry);
            this.closeDate = settlementNote.getCloseDate();
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(entry, e);
        }
    }

    private void fillStudentInformation(PaymentEntry entry) {
        Customer customer = entry.getSettlementNote().getDebtAccount().getCustomer();
        this.customerId = customer.getExternalId();
        this.debtAccountId = entry.getSettlementNote().getDebtAccount().getExternalId();
        this.name = customer.getName();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null && ((PersonCustomer)customer).getPerson().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getPerson().getIdDocumentType().getLocalizedNameI18N();
        } else if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getIdDocumentType().getLocalizedNameI18N();
        }
        this.identificationNumber = customer.getIdentificationNumber();
        this.vatNumber = customer.getUiFiscalNumber();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null) {
            this.email = ((PersonCustomer)customer).getPerson().getInstitutionalOrDefaultEmailAddressValue();
        } else if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPersonForInactivePersonCustomer() != null) {
            this.email = ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getInstitutionalOrDefaultEmailAddressValue();
        }
        this.address = customer.getAddress();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null && ((PersonCustomer)customer).getPerson().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getPerson().getStudent().getNumber();
        } else if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getStudent().getNumber();
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(Constants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.responsible));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteDocumentDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.paymentDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteAnnuled));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentExportationPending));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.paymentMethod));
            row.createCell(i++).setCellValue(this.amount.toString());
            row.createCell(i++).setCellValue(this.customerId);
            row.createCell(i++).setCellValue(this.debtAccountId);
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.name));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.email));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.closeDate));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.paymentEntry, e);
        }
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return Constants.academicTreasuryBundle(value != false ? "label.true" : "label.false", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (StringUtils.isEmpty((Object)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!StringUtils.isEmpty((Object)value)) {
            return value;
        }
        return "";
    }
}

