/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.integration;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.integration.ERPTuitionInfoExportOperation$callable$create;
import org.fenixedu.academictreasury.domain.integration.ERPTuitionInfoExportOperation_Base;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.IntegrationOperation;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPTuitionInfoExportOperation
extends ERPTuitionInfoExportOperation_Base {
    public static final Comparator<ERPTuitionInfoExportOperation> COMPARE_BY_EXECUTION_DATE;
    public static final Comparator<ERPTuitionInfoExportOperation> COMPARE_BY_VERSIONING_CREATION_DATE;
    public static final Advice advice$create;

    public ERPTuitionInfoExportOperation() {
    }

    public ERPTuitionInfoExportOperation(ERPTuitionInfo erpTuitionInfo) {
        this();
        this.setErpTuitionInfo(erpTuitionInfo);
    }

    protected void init(OperationFile file, FinantialInstitution finantialInstitution, String erpOperationId, DateTime executionDate) {
        this.setFile(file);
        this.setFinantialInstitution(finantialInstitution);
        this.setExecutionDate(executionDate);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFile() == null) {
            throw new TreasuryDomainException("error.ERPTuitionInfoExportOperation.file.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.ERPTuitionInfoExportOperation.finantialInstitution.required", new String[0]);
        }
    }

    public static Stream<ERPTuitionInfoExportOperation> findAll() {
        return ERPTuitionInfo.findAll().flatMap(e -> e.getErpTuitionInfoExportOperationsSet().stream());
    }

    public static ERPTuitionInfoExportOperation create(ERPTuitionInfo eRPTuitionInfo, byte[] byArray, String string, FinantialInstitution finantialInstitution, String string2, DateTime dateTime) {
        return (ERPTuitionInfoExportOperation)((Object)advice$create.perform((Callable)new ERPTuitionInfoExportOperation$callable$create(eRPTuitionInfo, byArray, string, finantialInstitution, string2, dateTime)));
    }

    static /* synthetic */ ERPTuitionInfoExportOperation advised$create(ERPTuitionInfo erpTuitionInfo, byte[] data, String filename, FinantialInstitution finantialInstitution, String erpOperationId, DateTime executionDate) {
        ERPTuitionInfoExportOperation erpTuitionInfoExportOperation = new ERPTuitionInfoExportOperation(erpTuitionInfo);
        OperationFile file = data == null ? OperationFile.create((String)filename, (byte[])new byte[0], (IntegrationOperation)erpTuitionInfoExportOperation) : OperationFile.create((String)filename, (byte[])data, (IntegrationOperation)erpTuitionInfoExportOperation);
        erpTuitionInfoExportOperation.init(file, finantialInstitution, erpOperationId, executionDate);
        return erpTuitionInfoExportOperation;
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_EXECUTION_DATE = new Comparator<ERPTuitionInfoExportOperation>(){

            @Override
            public int compare(ERPTuitionInfoExportOperation o1, ERPTuitionInfoExportOperation o2) {
                int c = o1.getExecutionDate().compareTo((ReadableInstant)o2.getExecutionDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARE_BY_VERSIONING_CREATION_DATE = new Comparator<ERPTuitionInfoExportOperation>(){

            @Override
            public int compare(ERPTuitionInfoExportOperation o1, ERPTuitionInfoExportOperation o2) {
                int c = o1.getVersioningCreationDate().compareTo((ReadableInstant)o2.getVersioningCreationDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

