/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.emoluments;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequestSituationType;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry$callable$create;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry$callable$create$1;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry$callable$delete;
import org.fenixedu.academictreasury.domain.emoluments.ServiceRequestMapEntry_Base;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ServiceRequestMapEntry
extends ServiceRequestMapEntry_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public ServiceRequestMapEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ServiceRequestMapEntry(Product product, ServiceRequestType requestType, AcademicServiceRequestSituationType createEventOnSituation, boolean generatePaymentCode, PaymentCodePool paymentCodePool, String debitEntryDescriptionExtensionFormat) {
        this();
        this.setProduct(product);
        this.setServiceRequestType(requestType);
        this.setCreateEventOnSituation(createEventOnSituation);
        this.setGeneratePaymentCode(generatePaymentCode);
        this.setPaymentCodePool(paymentCodePool);
        this.setDebitEntryDescriptionExtensionFormat(debitEntryDescriptionExtensionFormat);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getProduct() == null) {
            throw new AcademicTreasuryDomainException("error.ServiceRequestMapEntry.product.required", new String[0]);
        }
        if (this.getServiceRequestType() == null) {
            throw new AcademicTreasuryDomainException("error.ServiceRequestMapEntry.serviceRequestType.required", new String[0]);
        }
        if (this.getCreateEventOnSituation() == null) {
            throw new AcademicTreasuryDomainException("error.ServiceRequestMapEntry.createEventOnSituation.required", new String[0]);
        }
        if (ServiceRequestMapEntry.find(this.getServiceRequestType()).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.ServiceRequestMapEntry.duplicatedForServiceRequestType", new String[0]);
        }
    }

    private boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ServiceRequestMapEntry$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ServiceRequestMapEntry this_) {
        if (!this_.isDeletable()) {
            throw new AcademicTreasuryDomainException("error.ServiceRequestMapEntry.delete.impossible", new String[0]);
        }
        this_.setServiceRequestType(null);
        this_.setProduct(null);
        this_.setDomainRoot(null);
        super.deleteDomainObject();
    }

    public static Stream<ServiceRequestMapEntry> findAll() {
        return FenixFramework.getDomainRoot().getServiceRequestMapEntriesSet().stream();
    }

    public static Stream<ServiceRequestMapEntry> find(Product product) {
        return product.getServiceRequestMapEntriesSet().stream();
    }

    public static Stream<ServiceRequestMapEntry> find(ServiceRequestType requestType) {
        return requestType.getServiceRequestMapEntriesSet().stream();
    }

    public static Stream<ServiceRequestMapEntry> find(Product product, ServiceRequestType requestType) {
        return ServiceRequestMapEntry.find(product).filter(e -> e.getServiceRequestType() == requestType);
    }

    public static ServiceRequestMapEntry findMatch(ITreasuryServiceRequest iTreasuryServiceRequest) {
        ServiceRequestType serviceRequestType = iTreasuryServiceRequest.getServiceRequestType();
        if (ServiceRequestMapEntry.find(serviceRequestType).count() > 1L) {
            throw new AcademicTreasuryDomainException("error.ServiceRequestMapEntry.duplicatedForServiceRequestType", new String[0]);
        }
        return ServiceRequestMapEntry.find(serviceRequestType).findFirst().orElse(null);
    }

    public static Product findProduct(ITreasuryServiceRequest iTreasuryServiceRequest) {
        if (ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest) == null) {
            throw new AcademicTreasuryDomainException("error.ServiceRequestMapEntry.cannot.find.serviceRequestMapEntry", new String[0]);
        }
        return ServiceRequestMapEntry.findMatch(iTreasuryServiceRequest).getProduct();
    }

    public static ServiceRequestMapEntry create(Product product, ServiceRequestType serviceRequestType, AcademicServiceRequestSituationType academicServiceRequestSituationType, String string) {
        return (ServiceRequestMapEntry)((Object)advice$create.perform((Callable)new ServiceRequestMapEntry$callable$create(product, serviceRequestType, academicServiceRequestSituationType, string)));
    }

    static /* synthetic */ ServiceRequestMapEntry advised$create(Product product, ServiceRequestType requestType, AcademicServiceRequestSituationType situationType, String debitEntryDescriptionExtensionFormat) {
        return new ServiceRequestMapEntry(product, requestType, situationType, false, null, debitEntryDescriptionExtensionFormat);
    }

    public static ServiceRequestMapEntry create(Product product, ServiceRequestType serviceRequestType, AcademicServiceRequestSituationType academicServiceRequestSituationType, boolean bl, PaymentCodePool paymentCodePool, String string) {
        return (ServiceRequestMapEntry)((Object)advice$create$1.perform((Callable)new ServiceRequestMapEntry$callable$create$1(product, serviceRequestType, academicServiceRequestSituationType, bl, paymentCodePool, string)));
    }

    static /* synthetic */ ServiceRequestMapEntry advised$create(Product product, ServiceRequestType requestType, AcademicServiceRequestSituationType situationType, boolean generatePaymentCode, PaymentCodePool paymentCodePool, String debitEntryDescriptionExtensionFormat) {
        return new ServiceRequestMapEntry(product, requestType, situationType, generatePaymentCode, paymentCodePool, debitEntryDescriptionExtensionFormat);
    }
}

