/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.emoluments.AcademicTax;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry_Base;
import org.joda.time.LocalDate;

public enum AcademicTaxDueDateAlignmentType {
    TUITION_INSTALLMENT_MAX_DUE_DATE,
    TUITION_INSTALLMENT_MIN_DUE_DATE;


    public boolean isTuitionInstallmentMaxDueDate() {
        return this == TUITION_INSTALLMENT_MAX_DUE_DATE;
    }

    public boolean isTuitionInstallmentMinDueDate() {
        return this == TUITION_INSTALLMENT_MIN_DUE_DATE;
    }

    public LocalizedString getDescriptionI18N() {
        return BundleUtil.getLocalizedString((String)"resources.AcademicTreasuryResources", (String)(((Object)((Object)this)).getClass().getSimpleName() + "." + this.name()), (String[])new String[0]);
    }

    public void applyDueDate(AcademicDebtGenerationRule rule, Set<DebitEntry> debitEntriesSet) {
        LocalDate dueDateToApply = this.dueDateToApply(debitEntriesSet);
        for (DebitEntry debitEntry : debitEntriesSet) {
            if (!AcademicTax.findUnique(debitEntry.getProduct()).isPresent()) continue;
            debitEntry.setDueDate(dueDateToApply);
        }
    }

    private LocalDate dueDateToApply(Set<DebitEntry> debitEntriesSet) {
        if (this.isTuitionInstallmentMaxDueDate()) {
            Optional<DebitEntry> maxDebitEntry = debitEntriesSet.stream().filter(d -> d.getProduct().getProductGroup() == AcademicTreasurySettings.getInstance().getTuitionProductGroup()).max(Comparator.comparing(DebitEntry_Base::getDueDate));
            if (maxDebitEntry.isPresent()) {
                return maxDebitEntry.get().getDueDate();
            }
        } else if (this.isTuitionInstallmentMinDueDate()) {
            Optional<DebitEntry> minDebitEntry = debitEntriesSet.stream().filter(d -> d.getProduct().getProductGroup() == AcademicTreasurySettings.getInstance().getTuitionProductGroup()).min(Comparator.comparing(DebitEntry_Base::getDueDate));
            if (minDebitEntry.isPresent()) {
                return minDebitEntry.get().getDueDate();
            }
        } else {
            throw new AcademicTreasuryDomainException("error.AcademicTaxDueDateAlignmentType.unknown.rule.to.apply", new String[0]);
        }
        throw new AcademicTreasuryDomainException("error.AcademicTaxDueDateAlignmentType.no.due.date.to.apply", new String[0]);
    }
}

