/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.customer;

import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.ReportGenerationException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import org.fenixedu.treasury.services.reports.DocumentPrinter;
import org.joda.time.DateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.customer.viewAccount", accessGroup="activeStudents")
@RequestMapping(value={"/academictreasury/customer/viewaccount"})
public class CustomerAccountingController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/customer/viewaccount";
    private static final String JSP_PATH = "academicTreasury/customer/";
    private static final String READ_CUSTOMER_URI = "/customer/read/";
    private static final String READ_CUSTOMER_URL = "/academictreasury/customer/viewaccount/customer/read/";
    private static final String READ_ACCOUNT_URI = "/account/read/";
    public static final String READ_ACCOUNT_URL = "/academictreasury/customer/viewaccount/account/read/";
    private static final String CUSTOMER_NOT_CREATED_URI = "/customernotcreated";
    public static final String CUSTOMER_NOT_CREATED_URL = "/academictreasury/customer/viewaccount/customernotcreated";
    private static final String PRINT_SETTLEMENT_NOTE_URI = "/printsettlementnote";
    public static final String PRINT_SETTLEMENT_NOTE_URL = "/academictreasury/customer/viewaccount/printsettlementnote";
    private static final String PRINT_PAYMENT_REFERENCES_URI = "/printpaymentreferences";
    public static final String PRINT_PAYMENT_REFERENCES_URL = "/academictreasury/customer/viewaccount/printpaymentreferences";
    private static final String _DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URI = "/downloadcertifieddocumentprint";
    public static final String DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URL = "/academictreasury/customer/viewaccount/downloadcertifieddocumentprint";

    public String getReadCustomerUrl() {
        return READ_CUSTOMER_URL;
    }

    public String getReadAccountUrl() {
        return READ_ACCOUNT_URL;
    }

    protected String getForwardPaymentUrl(DebtAccount debtAccount) {
        return CustomerAccountingController.FORWARD_PAYMENT_URL(debtAccount);
    }

    public static String FORWARD_PAYMENT_URL(DebtAccount debtAccount) {
        return String.format("/academictreasury/customer/viewaccount/read/%s/forwardpayment", debtAccount.getExternalId());
    }

    protected String getPrintSettlementNote() {
        return PRINT_SETTLEMENT_NOTE_URL;
    }

    protected String getDownloadCertifiedDocumentPrintUrl() {
        return DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URL;
    }

    @RequestMapping
    public String home(Model model) {
        return "forward:" + this.getReadCustomerUrl();
    }

    @RequestMapping(value={"/customer/read/"})
    public String readCustomer(Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("readCustomerUrl", (Object)this.getReadCustomerUrl());
        model.addAttribute("readAccountUrl", (Object)this.getReadAccountUrl());
        PersonCustomer customer = Authenticate.getUser().getPerson().getPersonCustomer();
        model.addAttribute("customer", (Object)customer);
        if (customer == null) {
            return this.redirect(this.getCustomerNotCreatedUrl(), model, redirectAttributes);
        }
        if (customer.getDebtAccountsSet().size() == 1) {
            DebtAccount debtAccount = (DebtAccount)customer.getDebtAccountsSet().iterator().next();
            return this.redirect(this.getReadAccountUrl() + debtAccount.getExternalId(), model, redirectAttributes);
        }
        ArrayList pendingInvoiceEntries = new ArrayList();
        for (DebtAccount debtAccount : customer.getDebtAccountsSet()) {
            pendingInvoiceEntries.addAll(debtAccount.getPendingInvoiceEntriesSet());
        }
        model.addAttribute("pendingDocumentsDataSet", pendingInvoiceEntries);
        return this.jspPage("readCustomer");
    }

    @RequestMapping(value={"/account/read/{oid}"})
    public String readAccount(@PathVariable(value="oid") DebtAccount debtAccount, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("fowardPaymentUrl", (Object)this.getForwardPaymentUrl(debtAccount));
        model.addAttribute("printSettlementNoteUrl", (Object)this.getPrintSettlementNote());
        model.addAttribute("downloadCertifiedDocumentPrintUrl", (Object)this.getDownloadCertifiedDocumentPrintUrl());
        ArrayList allInvoiceEntries = new ArrayList();
        List<Object> paymentEntries = new ArrayList();
        ArrayList exemptionEntries = new ArrayList();
        ArrayList<InvoiceEntry> pendingInvoiceEntries = new ArrayList<InvoiceEntry>();
        allInvoiceEntries.addAll(debtAccount.getActiveInvoiceEntries().collect(Collectors.toList()));
        if (debtAccount.getCustomer().isActive() && debtAccount.getCustomer().isPersonCustomer()) {
            for (PersonCustomer inactivePersonCustomer : ((PersonCustomer)debtAccount.getCustomer()).getPerson().getInactivePersonCustomersSet()) {
                if (inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution()) == null) continue;
                allInvoiceEntries.addAll(inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution()).getActiveInvoiceEntries().collect(Collectors.toList()));
            }
        }
        paymentEntries = SettlementNote.findByDebtAccount((DebtAccount)debtAccount).filter(x -> x.isClosed() || x.isPreparing()).filter(x -> !x.getPaymentEntriesSet().isEmpty() || !x.getReimbursementEntriesSet().isEmpty()).collect(Collectors.toList());
        if (debtAccount.getCustomer().isActive() && debtAccount.getCustomer().isPersonCustomer()) {
            for (PersonCustomer inactivePersonCustomer : ((PersonCustomer)debtAccount.getCustomer()).getPerson().getInactivePersonCustomersSet()) {
                if (inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution()) == null) continue;
                paymentEntries.addAll(SettlementNote.findByDebtAccount((DebtAccount)inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution())).filter(x -> x.isClosed() || x.isPreparing()).filter(x -> !x.getPaymentEntriesSet().isEmpty() || !x.getReimbursementEntriesSet().isEmpty()).collect(Collectors.toList()));
            }
        }
        exemptionEntries.addAll(TreasuryExemption.findByDebtAccount((DebtAccount)debtAccount).collect(Collectors.toList()));
        if (debtAccount.getCustomer().isActive() && debtAccount.getCustomer().isPersonCustomer()) {
            for (PersonCustomer inactivePersonCustomer : ((PersonCustomer)debtAccount.getCustomer()).getPerson().getInactivePersonCustomersSet()) {
                if (inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution()) == null) continue;
                exemptionEntries.addAll(TreasuryExemption.findByDebtAccount((DebtAccount)inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution())).collect(Collectors.toList()));
            }
        }
        for (InvoiceEntry entry : debtAccount.getPendingInvoiceEntriesSet()) {
            if (entry.getFinantialDocument() == null) {
                pendingInvoiceEntries.add(entry);
                continue;
            }
            if (pendingInvoiceEntries.stream().anyMatch(x -> x.getFinantialDocument() != null && x.getFinantialDocument().equals((Object)entry.getFinantialDocument()))) continue;
            pendingInvoiceEntries.add(entry);
        }
        if (debtAccount.getCustomer().isActive() && debtAccount.getCustomer().isPersonCustomer()) {
            for (PersonCustomer inactivePersonCustomer : ((PersonCustomer)debtAccount.getCustomer()).getPerson().getInactivePersonCustomersSet()) {
                if (inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution()) == null) continue;
                for (InvoiceEntry entry : inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution()).getPendingInvoiceEntriesSet()) {
                    if (entry.getFinantialDocument() == null) {
                        pendingInvoiceEntries.add(entry);
                        continue;
                    }
                    if (pendingInvoiceEntries.stream().anyMatch(x -> x.getFinantialDocument() != null && x.getFinantialDocument().equals((Object)entry.getFinantialDocument()))) continue;
                    pendingInvoiceEntries.add(entry);
                }
            }
        }
        model.addAttribute("pendingDocumentsDataSet", pendingInvoiceEntries);
        model.addAttribute("allDocumentsDataSet", allInvoiceEntries);
        model.addAttribute("paymentsDataSet", paymentEntries);
        model.addAttribute("exemptionDataSet", exemptionEntries);
        HashSet usedPaymentCodeTargets = Sets.newHashSet();
        for (InvoiceEntry invoiceEntry : debtAccount.getPendingInvoiceEntriesSet()) {
            if (!invoiceEntry.isDebitNoteEntry()) continue;
            usedPaymentCodeTargets.addAll(MultipleEntriesPaymentCode.findUsedByDebitEntry((DebitEntry)((DebitEntry)invoiceEntry)).collect(Collectors.toSet()));
            if (invoiceEntry.getFinantialDocument() == null) continue;
            usedPaymentCodeTargets.addAll(FinantialDocumentPaymentCode.findUsedByFinantialDocument((FinantialDocument)invoiceEntry.getFinantialDocument()).collect(Collectors.toSet()));
        }
        for (PersonCustomer inactivePersonCustomer : ((PersonCustomer)debtAccount.getCustomer()).getPerson().getInactivePersonCustomersSet()) {
            if (inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution()) == null || !inactivePersonCustomer.getUiFiscalNumber().equals(((PersonCustomer)debtAccount.getCustomer()).getUiFiscalNumber())) continue;
            for (InvoiceEntry invoiceEntry : inactivePersonCustomer.getDebtAccountFor(debtAccount.getFinantialInstitution()).getPendingInvoiceEntriesSet()) {
                if (!invoiceEntry.isDebitNoteEntry()) continue;
                usedPaymentCodeTargets.addAll(MultipleEntriesPaymentCode.findUsedByDebitEntry((DebitEntry)((DebitEntry)invoiceEntry)).collect(Collectors.toSet()));
                if (invoiceEntry.getFinantialDocument() == null) continue;
                usedPaymentCodeTargets.addAll(FinantialDocumentPaymentCode.findUsedByFinantialDocument((FinantialDocument)invoiceEntry.getFinantialDocument()).collect(Collectors.toSet()));
            }
        }
        model.addAttribute("usedPaymentCodeTargets", (Object)usedPaymentCodeTargets);
        return this.jspPage("readDebtAccount");
    }

    @RequestMapping(value={"/read/{oid}/forwardpayment"})
    public String processReadToForwardPayment(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/academictreasury/customer/forwardpayments/forwardpayment/chooseInvoiceEntries/" + debtAccount.getExternalId(), model, redirectAttributes);
    }

    protected String getCustomerNotCreatedUrl() {
        return CUSTOMER_NOT_CREATED_URL;
    }

    @RequestMapping(value={"/customernotcreated"})
    public String customernotcreated(Model model) {
        return this.jspPage("customernotcreated");
    }

    @RequestMapping(value={"/printsettlementnote/{settlementNoteId}"}, produces={"application/pdf"})
    @ResponseBody
    public Object printsettlementnote(@PathVariable(value="settlementNoteId") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            byte[] report = DocumentPrinter.printFinantialDocument((FinantialDocument)settlementNote, (String)"application/pdf");
            return new ResponseEntity((Object)report, HttpStatus.OK);
        }
        catch (ReportGenerationException rex) {
            this.addErrorMessage(rex.getLocalizedMessage(), model);
            this.addErrorMessage(rex.getCause().getLocalizedMessage(), model);
            return this.redirect(this.getReadAccountUrl() + settlementNote.getDebtAccount().getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(this.getReadAccountUrl() + settlementNote.getDebtAccount().getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/printpaymentreferences/{oid}"}, produces={"application/pdf"})
    @ResponseBody
    public Object printpaymentreferences(@PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            response.addHeader("Content-Disposition", "attachment; filename=referencias_" + new DateTime().toString("yyyyMMddHHmmss") + ".pdf");
            byte[] tuitionPlanbytes = org.fenixedu.academictreasury.services.reports.DocumentPrinter.printRegistrationTuititionPaymentPlan(debtAccount, "application/pdf");
            return new ResponseEntity((Object)tuitionPlanbytes, HttpStatus.OK);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(this.getReadAccountUrl() + debtAccount.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/downloadcertifieddocumentprint/{oid}"}, method={RequestMethod.GET})
    public String downloadcertifieddocumentprint(@PathVariable(value="oid") FinantialDocument finantialDocument, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            byte[] contents = ERPExporterManager.downloadCertifiedDocumentPrint((FinantialDocument)finantialDocument);
            response.setContentType("application/pdf");
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)(finantialDocument.getDebtAccount().getFinantialInstitution().getFiscalNumber() + "_" + finantialDocument.getUiDocumentNumber() + ".pdf").replaceAll("/", "_").replaceAll("\\s", "_").replaceAll(" ", "_")), "Windows-1252");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(contents);
            return null;
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.readAccount(finantialDocument.getDebtAccount(), model);
        }
    }

    public String jspPage(String page) {
        return JSP_PATH + page;
    }
}

