/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.academicservicerequestdebtcreation;

import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.dto.academicservicerequest.AcademicServiceRequestDebtCreationBean;
import org.fenixedu.academictreasury.services.EmolumentServices;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/academictreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean"})
public class AcademicServiceRequestDebtCreationBeanController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean";
    private static final String JSP_PATH = "academicTreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean/create";
    private static final String _BACKTOCREATE_URI = "/backtocreate";
    public static final String BACKTOCREATE_URL = "/academictreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean/backtocreate";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean/createpostback";
    private static final String _CONFIRMACADEMICSERVICEREQUESTDEBTCREATION_URI = "/confirmacademicservicerequestdebtcreation";
    public static final String CONFIRMACADEMICSERVICEREQUESTDEBTCREATION_URL = "/academictreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean/confirmacademicservicerequestdebtcreation";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean/create/";
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        AcademicServiceRequestDebtCreationBean bean = new AcademicServiceRequestDebtCreationBean(debtAccount);
        return this._createFirstPage(debtAccount, bean, model);
    }

    @RequestMapping(value={"/backtocreate/{debtAccountId}"}, method={RequestMethod.POST})
    public String backTocreate(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) AcademicServiceRequestDebtCreationBean bean, Model model) {
        return this._createFirstPage(debtAccount, bean, model);
    }

    public String _createFirstPage(DebtAccount debtAccount, AcademicServiceRequestDebtCreationBean bean, Model model) {
        model.addAttribute("AcademicServiceRequestDebtCreationBean_registration_options", (Object)((PersonCustomer)debtAccount.getCustomer()).getPerson().getStudent().getRegistrationsSet());
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("academicServiceRequestDebtCreationBeanJson", (Object)this.getBeanJson(bean));
        return this.jspPage("create");
    }

    @RequestMapping(value={"/createpostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) AcademicServiceRequestDebtCreationBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) AcademicServiceRequestDebtCreationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            boolean dataMissing = false;
            if (bean.getRegistration() == null) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.AcademicServiceRequestDebtCreation.registration.required", (String[])new String[0]), model);
                dataMissing = true;
            }
            if (bean.getDebtDate() == null) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.AcademicServiceRequestDebtCreation.debtDate.required", (String[])new String[0]), model);
                dataMissing = true;
            }
            if (bean.getAcademicServiceRequest() == null) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.AcademicServiceRequestDebtCreation.academicServiceRequest.required", (String[])new String[0]), model);
                dataMissing = true;
            }
            if (dataMissing) {
                return this._createFirstPage(debtAccount, bean, model);
            }
            ITreasuryServiceRequest iTreasuryServiceRequest = (ITreasuryServiceRequest)bean.getAcademicServiceRequest();
            if (EmolumentServices.findTariffForAcademicServiceRequest(iTreasuryServiceRequest, bean.getDebtDate()) == null) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.AcademicServiceRequestDebtCreation.tariff.not.found", (String[])new String[0]), model);
                return this._createFirstPage(debtAccount, bean, model);
            }
            AcademicTreasuryEvent event = EmolumentServices.findAcademicTreasuryEvent(iTreasuryServiceRequest);
            if (event != null && event.isChargedWithDebitEntry()) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"error.AcademicServiceRequestDebtCreation.event.is.charged", (String[])new String[0]), model);
                return this._createFirstPage(debtAccount, bean, model);
            }
            model.addAttribute("debtAccount", (Object)debtAccount);
            model.addAttribute("bean", (Object)bean);
            model.addAttribute("academicServiceRequestDebtCreationBeanJson", (Object)this.getBeanJson(bean));
            model.addAttribute("debt", (Object)EmolumentServices.calculateForAcademicServiceRequest(iTreasuryServiceRequest, bean.getDebtDate()));
            return this.jspPage("confirmacademicservicerequestdebtcreation");
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createFirstPage(debtAccount, bean, model);
        }
    }

    @RequestMapping(value={"/confirmacademicservicerequestdebtcreation/{debtAccountId}"}, method={RequestMethod.POST})
    public String confirmacademicservicerequestdebtcreation(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=false) AcademicServiceRequestDebtCreationBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            EmolumentServices.createAcademicServiceRequestEmolument((ITreasuryServiceRequest)bean.getAcademicServiceRequest(), bean.getDebtDate());
            this.addInfoMessage(BundleUtil.getString((String)"resources.AcademicTreasuryResources", (String)"label.AcademicServiceRequest.debit.entries.created.success", (String[])new String[0]), model);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read//" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this.create(debtAccount, bean, model, redirectAttributes);
        }
    }

    private String jspPage(String page) {
        return "academicTreasury/academicservicerequestdebtcreation/academicservicerequestdebtcreationbean/" + page;
    }
}

