/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.services.RegistrationServices$callable$createPersonCustomer;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class RegistrationServices {
    public static final Advice advice$createPersonCustomer = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static PersonCustomer createPersonCustomer(Person person) {
        return (PersonCustomer)((Object)advice$createPersonCustomer.perform((Callable)new RegistrationServices$callable$createPersonCustomer(person)));
    }

    static /* synthetic */ PersonCustomer advised$createPersonCustomer(Person p) {
        String fiscalCountryCode = PersonCustomer.countryCode(p);
        String fiscalNumber = PersonCustomer.fiscalNumber(p);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        Optional<? extends PersonCustomer> findUnique = PersonCustomer.findUnique(p, fiscalCountryCode, fiscalNumber);
        if (findUnique.isPresent()) {
            return findUnique.get();
        }
        return PersonCustomer.create(p, fiscalCountryCode, fiscalNumber);
    }

    @Subscribe
    public void newRegistrationEvent(DomainObjectEvent<Registration> event) {
        Registration reg = (Registration)event.getInstance();
        if (reg.getStudent() != null) {
            RegistrationServices.createPersonCustomer(reg.getStudent().getPerson());
        }
    }
}

