/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.springframework.util.StringUtils;

public class SettlementReportEntryBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_HEADERS = new String[]{Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identification", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.creationDate", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.responsible", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteNumber", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteDocumentDate", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.paymentDate", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementNoteAnnuled", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.documentExportationPending", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementEntryOrder", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.amount", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.productCode", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.settlementEntryDescription", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryIdentification", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryType", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceEntryAmountToPay", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.invoiceDocumentNumber", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.customerId", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.debtAccountId", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.name", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identificationType", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.identificationNumber", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.vatNumber", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.email", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.address", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.studentNumber", new String[0]), Constants.academicTreasuryBundle("label.SettlementReportEntryBean.header.closeDate", new String[0])};
    private SettlementEntry settlementEntry;
    private boolean completed;
    private String identification;
    private DateTime creationDate;
    private String responsible;
    private String invoiceEntryIdentification;
    private String invoiceEntryType;
    private String invoiceEntryAmountToPay;
    private String invoiceDocumentNumber;
    private String settlementNoteNumber;
    private DateTime settlementNoteDocumentDate;
    private DateTime paymentDate;
    private boolean settlementNoteAnnuled;
    private boolean documentExportationPending;
    private Integer settlementEntryOrder;
    private String amount;
    private String productCode;
    private String settlementEntryDescription;
    private String customerId;
    private String debtAccountId;
    private String name;
    private LocalizedString identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String email;
    private String address;
    private Integer studentNumber;
    private DateTime closeDate;

    public SettlementReportEntryBean(SettlementEntry entry, DebtReportRequest request, ErrorsLog errorsLog) {
        String decimalSeparator = request.getDecimalSeparator();
        this.settlementEntry = entry;
        try {
            SettlementNote settlementNote = (SettlementNote)entry.getFinantialDocument();
            Currency currency = settlementNote.getDebtAccount().getFinantialInstitution().getCurrency();
            this.identification = entry.getExternalId();
            this.creationDate = entry.getVersioningCreationDate();
            this.responsible = entry.getVersioningCreator();
            this.invoiceEntryIdentification = entry.getInvoiceEntry().getExternalId();
            this.settlementNoteNumber = settlementNote.getUiDocumentNumber();
            this.settlementNoteDocumentDate = settlementNote.getDocumentDate();
            this.paymentDate = settlementNote.getPaymentDate();
            this.settlementNoteAnnuled = settlementNote.isAnnulled();
            this.documentExportationPending = settlementNote.isDocumentToExport();
            this.invoiceEntryType = this.entryType(entry.getInvoiceEntry());
            this.invoiceEntryAmountToPay = currency.getValueWithScale(entry.getInvoiceEntry().getAmountWithVat()).toString();
            this.invoiceDocumentNumber = entry.getInvoiceEntry().getFinantialDocument().getUiDocumentNumber();
            this.settlementEntryOrder = entry.getEntryOrder();
            this.amount = settlementNote.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(entry.getTotalAmount()).toString();
            if (",".equals(decimalSeparator)) {
                this.invoiceEntryAmountToPay = this.invoiceEntryAmountToPay.replace(".", ",");
                this.amount = this.amount.replace(".", ",");
            }
            this.productCode = entry.getInvoiceEntry().getProduct().getCode();
            this.settlementEntryDescription = entry.getDescription();
            this.fillStudentInformation(entry);
            this.closeDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getCloseDate() : null;
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(entry, e);
        }
    }

    private void fillStudentInformation(SettlementEntry entry) {
        Customer customer = entry.getFinantialDocument().getDebtAccount().getCustomer();
        this.customerId = customer.getExternalId();
        this.debtAccountId = entry.getFinantialDocument().getDebtAccount().getExternalId();
        this.name = customer.getName();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null && ((PersonCustomer)customer).getPerson().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getPerson().getIdDocumentType().getLocalizedNameI18N();
        } else if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getIdDocumentType().getLocalizedNameI18N();
        }
        this.identificationNumber = customer.getIdentificationNumber();
        this.vatNumber = customer.getUiFiscalNumber();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null) {
            this.email = ((PersonCustomer)customer).getPerson().getInstitutionalOrDefaultEmailAddressValue();
        } else if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPersonForInactivePersonCustomer() != null) {
            this.email = ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getInstitutionalOrDefaultEmailAddressValue();
        }
        this.address = customer.getAddress();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null && ((PersonCustomer)customer).getPerson().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getPerson().getStudent().getNumber();
        } else if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getStudent().getNumber();
        }
    }

    private String entryType(InvoiceEntry entry) {
        if (entry.isDebitNoteEntry()) {
            return Constants.academicTreasuryBundle("label.DebtReportEntryBean.debitNoteEntry", new String[0]);
        }
        if (entry.isCreditNoteEntry()) {
            return Constants.academicTreasuryBundle("label.DebtReportEntryBean.creditNoteEntry", new String[0]);
        }
        return null;
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(Constants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.responsible));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteDocumentDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.paymentDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementNoteAnnuled));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentExportationPending));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementEntryOrder));
            row.createCell(i++).setCellValue(this.amount.toString());
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.productCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.settlementEntryDescription));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.invoiceEntryIdentification));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.invoiceEntryType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.invoiceEntryAmountToPay));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.invoiceDocumentNumber));
            row.createCell(i++).setCellValue(this.customerId);
            row.createCell(i++).setCellValue(this.debtAccountId);
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.name));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.email));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.closeDate));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.settlementEntry, e);
        }
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return Constants.academicTreasuryBundle(value != false ? "label.true" : "label.false", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (StringUtils.isEmpty((Object)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!StringUtils.isEmpty((Object)value)) {
            return value;
        }
        return "";
    }
}

