/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.dto.reports.AbstractReportEntryBean;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.joda.time.DateTime;

public class PaymentReferenceCodeEntryBean
extends AbstractReportEntryBean {
    private static final String TARGET_TYPE_FINANTIAL_DOCUMENT = "F";
    private static final String TARGET_TYPE_MULTIPLE_ENTRIES = "M";
    private static final String TARGET_TYPE_NOT_DEFINED = "N";
    public static String[] SPREADSHEET_HEADERS = new String[]{Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.identification", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.versioningCreator", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.creationDate", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.customerId", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.debtAccountId", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.name", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.identificationType", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.identificationNumber", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.vatNumber", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.email", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.address", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.addressCountryCode", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.studentNumber", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.entityCode", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.referenceCode", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.finantialDocumentNumber", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.payableAmount", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.description", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.target.type", new String[0]), Constants.academicTreasuryBundle("label.PaymentReferenceCodeEntryBean.header.state", new String[0])};
    private String identification;
    private String versioningCreator;
    private DateTime creationDate;
    private String customerId;
    private String debtAccountId;
    private String name;
    private LocalizedString identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String email;
    private String address;
    private String addressCountryCode;
    private Integer studentNumber;
    private String entityCode;
    private String referenceCode;
    private String finantialDocumentNumber;
    private String payableAmount;
    private String description;
    private String targetType;
    private String state;
    private PaymentReferenceCode paymentReferenceCode;
    boolean completed = false;

    public PaymentReferenceCodeEntryBean(PaymentReferenceCode paymentReferenceCode, DebtReportRequest request, ErrorsLog errorsLog) {
        String decimalSeparator = request.getDecimalSeparator();
        try {
            this.paymentReferenceCode = paymentReferenceCode;
            this.identification = paymentReferenceCode.getExternalId();
            this.versioningCreator = paymentReferenceCode.getVersioningCreator();
            this.creationDate = paymentReferenceCode.getVersioningCreationDate();
            if (paymentReferenceCode.getTargetPayment() != null) {
                DebtAccount referenceDebtAccount = paymentReferenceCode.getTargetPayment().getDebtAccount();
                this.customerId = referenceDebtAccount.getCustomer().getExternalId();
                this.debtAccountId = referenceDebtAccount.getExternalId();
                this.name = referenceDebtAccount.getCustomer().getName();
                if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson() != null && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getIdDocumentType() != null) {
                    this.identificationType = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getIdDocumentType().getLocalizedNameI18N();
                } else if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getIdDocumentType() != null) {
                    this.identificationType = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getIdDocumentType().getLocalizedNameI18N();
                }
                this.identificationNumber = referenceDebtAccount.getCustomer().getIdentificationNumber();
                this.vatNumber = referenceDebtAccount.getCustomer().getUiFiscalNumber();
                if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson() != null) {
                    this.email = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getInstitutionalOrDefaultEmailAddressValue();
                } else if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null) {
                    this.email = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getInstitutionalOrDefaultEmailAddressValue();
                }
                this.address = referenceDebtAccount.getCustomer().getAddress();
                this.addressCountryCode = referenceDebtAccount.getCustomer().getAddressCountryCode();
                if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson() != null && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getStudent() != null) {
                    this.studentNumber = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPerson().getStudent().getNumber();
                } else if (referenceDebtAccount.getCustomer().isPersonCustomer() && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getStudent() != null) {
                    this.studentNumber = ((PersonCustomer)referenceDebtAccount.getCustomer()).getPersonForInactivePersonCustomer().getStudent().getNumber();
                }
            }
            this.entityCode = paymentReferenceCode.getPaymentCodePool().getEntityReferenceCode();
            this.referenceCode = paymentReferenceCode.getReferenceCode();
            if (paymentReferenceCode.getTargetPayment() != null && paymentReferenceCode.getTargetPayment().isFinantialDocumentPaymentCode()) {
                this.finantialDocumentNumber = ((FinantialDocumentPaymentCode)paymentReferenceCode.getTargetPayment()).getFinantialDocument().getUiDocumentNumber();
            } else if (paymentReferenceCode.getTargetPayment() != null && paymentReferenceCode.getTargetPayment().isMultipleEntriesPaymentCode()) {
                MultipleEntriesPaymentCode multipleEntriesPaymentCode = (MultipleEntriesPaymentCode)paymentReferenceCode.getTargetPayment();
                this.finantialDocumentNumber = String.join((CharSequence)", ", multipleEntriesPaymentCode.getInvoiceEntriesSet().stream().filter(i -> i.getFinantialDocument() != null).map(i -> i.getFinantialDocument().getUiDocumentNumber()).collect(Collectors.toList()));
            }
            if (paymentReferenceCode.getPayableAmount() != null) {
                Currency currency = paymentReferenceCode.getPaymentCodePool().getFinantialInstitution().getCurrency();
                this.payableAmount = currency.getValueWithScale(paymentReferenceCode.getPayableAmount()).toString();
                if (",".equals(decimalSeparator)) {
                    this.payableAmount = this.payableAmount.replace(".", ",");
                }
            }
            if (paymentReferenceCode.getTargetPayment() != null) {
                this.description = paymentReferenceCode.getTargetPayment().getDescription();
            }
            if (paymentReferenceCode.getTargetPayment() != null && paymentReferenceCode.getTargetPayment().isFinantialDocumentPaymentCode()) {
                this.targetType = TARGET_TYPE_FINANTIAL_DOCUMENT;
            } else if (paymentReferenceCode.getTargetPayment() != null && paymentReferenceCode.getTargetPayment().isMultipleEntriesPaymentCode()) {
                this.targetType = TARGET_TYPE_MULTIPLE_ENTRIES;
            } else if (paymentReferenceCode.getTargetPayment() == null) {
                this.targetType = TARGET_TYPE_NOT_DEFINED;
            }
            if (paymentReferenceCode.getState() != null) {
                this.state = paymentReferenceCode.getState().getDescriptionI18N().getContent();
            }
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(paymentReferenceCode, e);
        }
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(Constants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            int i = 1;
            row.createCell(i++).setCellValue(this.versioningCreator);
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.customerId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.debtAccountId));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.name));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.email));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.addressCountryCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.entityCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.referenceCode));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.finantialDocumentNumber));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.payableAmount));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.description));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.targetType));
            row.createCell(i++).setCellValue(this.valueOrEmpty(this.state));
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.paymentReferenceCode, e);
        }
    }
}

