/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import com.google.common.base.Strings;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.reports.DebtReportRequest;
import org.fenixedu.academictreasury.domain.reports.ErrorsLog;
import org.fenixedu.academictreasury.domain.serviceRequests.ITreasuryServiceRequest;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporterUtils;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.util.StringUtils;

public class DebtReportEntryBean
implements SpreadsheetRow {
    public static String[] SPREADSHEET_DEBIT_HEADERS = new String[]{Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.identification", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.entryType", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.versioningCreator", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.creationDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.entryDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.dueDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.customerId", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.debtAccountId", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.name", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.identificationType", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.identificationNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.vatNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.email", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.address", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.studentNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.registrationNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeType", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeCode", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeName", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.executionYear", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.executionSemester", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.productCode", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.invoiceEntryDescription", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentExportationPending", new String[0]), "", Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.amountToPay", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountToPay", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.payorDebtAcount.vatNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.payorDebtAcount.name", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.agreement", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.ingression", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.firstTimeStudent", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.partialRegime", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.statutes", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfNormalEnrolments", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfStandaloneEnrolments", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfExtracurricularEnrolments", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.tuitionPaymentPlan", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.tuitionPaymentPlanConditions", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentAnnuled", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentAnnuledReason", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.closeDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountAtERPStartDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.exportedInLegacyERP", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.legacyERPCertificateDocumentReference", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificationDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificateDocumentReference", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.originSettlementNoteForAdvancedCredit", new String[0])};
    public static String[] SPREADSHEET_CREDIT_HEADERS = new String[]{Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.identification", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.entryType", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.versioningCreator", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.creationDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.entryDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.dueDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.customerId", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.debtAccountId", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.name", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.identificationType", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.identificationNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.vatNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.email", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.address", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.studentNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.registrationNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeType", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeCode", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.degreeName", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.executionYear", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.executionSemester", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.productCode", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.invoiceEntryDescription", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentExportationPending", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.debitEntry.identification", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.amountToCredit", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountToCredit", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.payorDebtAcount.vatNumber", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.payorDebtAcount.name", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.agreement", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.ingression", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.firstTimeStudent", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.partialRegime", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.statutes", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfNormalEnrolments", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfStandaloneEnrolments", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.numberOfExtracurricularEnrolments", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.tuitionPaymentPlan", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.tuitionPaymentPlanConditions", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentAnnuled", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.documentAnnuledReason", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.closeDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.openAmountAtERPStartDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.exportedInLegacyERP", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.legacyERPCertificateDocumentReference", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificationDate", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.erpCertificateDocumentReference", new String[0]), Constants.academicTreasuryBundle("label.DebtReportEntryBean.header.originSettlementNoteForAdvancedCredit", new String[0])};
    private InvoiceEntry invoiceEntry;
    private boolean completed = false;
    private String identification;
    private String entryType;
    private String versioningCreator;
    private DateTime creationDate;
    private DateTime entryDate;
    private LocalDate dueDate;
    private String customerId;
    private String debtAccountId;
    private String name;
    private LocalizedString identificationType;
    private String identificationNumber;
    private String vatNumber;
    private String email;
    private String address;
    private Integer studentNumber;
    private Integer registrationNumber;
    private String degreeType;
    private String degreeCode;
    private LocalizedString degreeName;
    private String executionYear;
    private String executionSemester;
    private String productCode;
    private String invoiceEntryDescription;
    private String documentNumber;
    private boolean documentExportationPending;
    private boolean annuled;
    private String annuledReason;
    private String debitEntryIdentification;
    private String baseAmount;
    private String creditedAmount;
    private String amountToPay;
    private String openAmountToPay;
    private String payorDebtAccountVatNumber;
    private String payorDebtAccountName;
    private LocalizedString agreement;
    private LocalizedString ingression;
    private Boolean firstTimeStudent;
    private Boolean partialRegime;
    private String statutes;
    private int numberOfNormalEnrolments;
    private int numberOfStandaloneEnrolments;
    private int numberOfExtracurricularEnrolments;
    private String tuitionPaymentPlan;
    private String tuitionPaymentPlanConditions;
    private DateTime closeDate;
    private String openAmountAtERPStartDate;
    private boolean exportedInLegacyERP;
    private String legacyERPCertificateDocumentReference;
    private LocalDate erpCertificationDate;
    private String erpCertificateDocumentReference;
    private String originSettlementNoteForAdvancedCredit;

    public DebtReportEntryBean(InvoiceEntry entry, DebtReportRequest request, ErrorsLog errorsLog) {
        String decimalSeparator = request.getDecimalSeparator();
        this.invoiceEntry = entry;
        try {
            this.identification = entry.getExternalId();
            this.entryType = this.entryType(entry);
            this.creationDate = entry.getVersioningCreationDate();
            this.versioningCreator = entry.getVersioningCreator();
            this.entryDate = entry.getEntryDateTime();
            this.dueDate = entry.getDueDate();
            this.payorDebtAccountVatNumber = "";
            this.payorDebtAccountName = "";
            if (entry.getFinantialDocument() != null && ((Invoice)entry.getFinantialDocument()).getPayorDebtAccount() != null) {
                this.payorDebtAccountVatNumber = ((Invoice)entry.getFinantialDocument()).getPayorDebtAccount().getCustomer().getUiFiscalNumber();
                this.payorDebtAccountName = ((Invoice)entry.getFinantialDocument()).getPayorDebtAccount().getCustomer().getName();
            }
            this.fillStudentInformation(entry);
            this.productCode = entry.getProduct().getCode();
            this.invoiceEntryDescription = entry.getDescription();
            if (entry.getFinantialDocument() != null) {
                this.documentNumber = entry.getFinantialDocument().getUiDocumentNumber();
                this.documentExportationPending = entry.getFinantialDocument().isDocumentToExport();
            }
            this.annuled = entry.isAnnulled();
            if (this.annuled && entry.getFinantialDocument() != null) {
                this.annuledReason = entry.getFinantialDocument().getAnnulledReason();
            }
            if (entry.isCreditNoteEntry() && ((CreditEntry)entry).getDebitEntry() != null) {
                this.debitEntryIdentification = ((CreditEntry)entry).getDebitEntry().getExternalId();
            }
            Currency currency = entry.getDebtAccount().getFinantialInstitution().getCurrency();
            this.baseAmount = currency.getValueWithScale(entry.getAmountWithVat()).toString();
            this.amountToPay = currency.getValueWithScale(entry.getAmountWithVat()).toString();
            this.openAmountToPay = currency.getValueWithScale(entry.getOpenAmount()).toString();
            if (",".equals(decimalSeparator)) {
                this.amountToPay = this.amountToPay.replace(".", ",");
                this.openAmountToPay = this.openAmountToPay.replace(".", ",");
            }
            this.closeDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getCloseDate() : null;
            this.openAmountAtERPStartDate = currency.getValueWithScale(SAPExporterUtils.openAmountAtDate((InvoiceEntry)entry, (DateTime)SAPExporter.ERP_INTEGRATION_START_DATE)).toString();
            this.exportedInLegacyERP = entry.getFinantialDocument() != null ? entry.getFinantialDocument().isExportedInLegacyERP() : false;
            this.legacyERPCertificateDocumentReference = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getLegacyERPCertificateDocumentReference() : null;
            this.erpCertificationDate = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getErpCertificationDate() : null;
            String string = this.erpCertificateDocumentReference = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getErpCertificateDocumentReference() : null;
            if (",".equals(decimalSeparator)) {
                this.openAmountAtERPStartDate = this.openAmountAtERPStartDate.replace(".", ",");
            }
            if (entry.getFinantialDocument() != null && entry.getFinantialDocument().isCreditNote() && ((CreditNote)entry.getFinantialDocument()).isAdvancePayment()) {
                AdvancedPaymentCreditNote advancedCreditNote = (AdvancedPaymentCreditNote)entry.getFinantialDocument();
                this.originSettlementNoteForAdvancedCredit = advancedCreditNote.getAdvancedPaymentSettlementNote() != null ? advancedCreditNote.getAdvancedPaymentSettlementNote().getUiDocumentNumber() : "";
            }
            this.completed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(entry, e);
        }
    }

    private void fillStudentInformation(InvoiceEntry entry) {
        DebitEntry debitEntry;
        Customer customer = entry.getDebtAccount().getCustomer();
        this.customerId = customer.getExternalId();
        this.debtAccountId = entry.getDebtAccount().getExternalId();
        this.name = customer.getName();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null && ((PersonCustomer)customer).getPerson().getIdDocumentType() != null) {
            this.identificationType = ((PersonCustomer)customer).getPerson().getIdDocumentType().getLocalizedNameI18N();
        } else if (!customer.isPersonCustomer() || ((PersonCustomer)customer).getPersonForInactivePersonCustomer() == null || ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getIdDocumentType() != null) {
            // empty if block
        }
        this.identificationNumber = customer.getIdentificationNumber();
        this.vatNumber = customer.getUiFiscalNumber();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null) {
            this.email = ((PersonCustomer)customer).getPerson().getInstitutionalOrDefaultEmailAddressValue();
        } else if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPersonForInactivePersonCustomer() != null) {
            this.email = ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getInstitutionalOrDefaultEmailAddressValue();
        }
        this.address = customer.getAddress();
        if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPerson() != null && ((PersonCustomer)customer).getPerson().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getPerson().getStudent().getNumber();
        } else if (customer.isPersonCustomer() && ((PersonCustomer)customer).getPersonForInactivePersonCustomer() != null && ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getStudent() != null) {
            this.studentNumber = ((PersonCustomer)customer).getPersonForInactivePersonCustomer().getStudent().getNumber();
        }
        DebitEntry debitEntry2 = debitEntry = entry.isDebitNoteEntry() ? (DebitEntry)entry : ((CreditEntry)entry).getDebitEntry();
        if (debitEntry != null) {
            if (debitEntry.getTreasuryEvent() != null && debitEntry.getTreasuryEvent() instanceof AcademicTreasuryEvent) {
                AcademicTreasuryEvent academicTreasuryEvent = (AcademicTreasuryEvent)debitEntry.getTreasuryEvent();
                if (academicTreasuryEvent.isForRegistrationTuition()) {
                    this.registrationNumber = academicTreasuryEvent.getRegistration().getNumber();
                    this.degreeType = academicTreasuryEvent.getRegistration().getDegree().getDegreeType().getName().getContent();
                    this.degreeCode = academicTreasuryEvent.getRegistration().getDegree().getCode();
                    this.degreeName = academicTreasuryEvent.getRegistration().getDegree().getPresentationNameI18N();
                    this.executionYear = academicTreasuryEvent.getExecutionYear().getQualifiedName();
                    this.tuitionPaymentPlan = AcademicTreasuryEvent.AcademicTreasuryEventKeys.valueFor(debitEntry, AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN);
                    this.tuitionPaymentPlanConditions = AcademicTreasuryEvent.AcademicTreasuryEventKeys.valueFor(debitEntry, AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN_CONDITIONS);
                    this.fillStudentConditionsInformation(academicTreasuryEvent.getRegistration(), academicTreasuryEvent.getExecutionYear());
                } else if (academicTreasuryEvent.isForStandaloneTuition() || academicTreasuryEvent.isForExtracurricularTuition()) {
                    if (debitEntry.getCurricularCourse() != null) {
                        this.degreeType = debitEntry.getCurricularCourse().getDegree().getDegreeType().getName().getContent();
                        this.degreeCode = debitEntry.getCurricularCourse().getDegree().getCode();
                        this.degreeName = debitEntry.getCurricularCourse().getDegree().getPresentationNameI18N();
                    }
                    if (debitEntry.getExecutionSemester() != null) {
                        this.executionYear = debitEntry.getExecutionSemester().getExecutionYear().getQualifiedName();
                        this.executionSemester = debitEntry.getExecutionSemester().getQualifiedName();
                    }
                    this.tuitionPaymentPlan = AcademicTreasuryEvent.AcademicTreasuryEventKeys.valueFor(debitEntry, AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN);
                    this.tuitionPaymentPlanConditions = AcademicTreasuryEvent.AcademicTreasuryEventKeys.valueFor(debitEntry, AcademicTreasuryEvent.AcademicTreasuryEventKeys.TUITION_PAYMENT_PLAN_CONDITIONS);
                    if (academicTreasuryEvent.getRegistration() != null && academicTreasuryEvent.getExecutionYear() != null) {
                        this.fillStudentConditionsInformation(academicTreasuryEvent.getRegistration(), academicTreasuryEvent.getExecutionYear());
                    }
                } else if (academicTreasuryEvent.isForImprovementTax()) {
                    if (debitEntry.getCurricularCourse() != null) {
                        this.degreeType = debitEntry.getCurricularCourse().getDegree().getDegreeType().getName().getContent();
                        this.degreeCode = debitEntry.getCurricularCourse().getDegree().getCode();
                        this.degreeName = debitEntry.getCurricularCourse().getDegree().getPresentationNameI18N();
                    }
                    if (debitEntry.getExecutionSemester() != null) {
                        this.executionYear = debitEntry.getExecutionSemester().getExecutionYear().getQualifiedName();
                        this.executionSemester = debitEntry.getExecutionSemester().getQualifiedName();
                    }
                    if (academicTreasuryEvent.getRegistration() != null && academicTreasuryEvent.getExecutionYear() != null) {
                        this.fillStudentConditionsInformation(academicTreasuryEvent.getRegistration(), academicTreasuryEvent.getExecutionYear());
                    }
                } else if (academicTreasuryEvent.isForAcademicTax()) {
                    this.registrationNumber = academicTreasuryEvent.getRegistration().getNumber();
                    this.degreeType = academicTreasuryEvent.getRegistration().getDegree().getDegreeType().getName().getContent();
                    this.degreeCode = academicTreasuryEvent.getRegistration().getDegree().getCode();
                    this.degreeName = academicTreasuryEvent.getRegistration().getDegree().getPresentationNameI18N();
                    this.executionYear = academicTreasuryEvent.getExecutionYear().getQualifiedName();
                    this.fillStudentConditionsInformation(academicTreasuryEvent.getRegistration(), academicTreasuryEvent.getExecutionYear());
                } else if (academicTreasuryEvent.isForAcademicServiceRequest()) {
                    ITreasuryServiceRequest iTreasuryServiceRequest = academicTreasuryEvent.getITreasuryServiceRequest();
                    this.registrationNumber = iTreasuryServiceRequest.getRegistration().getNumber();
                    this.degreeType = iTreasuryServiceRequest.getRegistration().getDegree().getDegreeType().getName().getContent();
                    this.degreeCode = iTreasuryServiceRequest.getRegistration().getDegree().getCode();
                    this.degreeName = iTreasuryServiceRequest.getRegistration().getDegree().getPresentationNameI18N();
                    if (iTreasuryServiceRequest.hasExecutionYear()) {
                        this.executionYear = iTreasuryServiceRequest.getExecutionYear().getQualifiedName();
                        this.fillStudentConditionsInformation(iTreasuryServiceRequest.getRegistration(), iTreasuryServiceRequest.getExecutionYear());
                    }
                }
            } else if (debitEntry.getTreasuryEvent() != null) {
                TreasuryEvent treasuryEvent = debitEntry.getTreasuryEvent();
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getDegreeCode())) {
                    this.degreeCode = treasuryEvent.getDegreeCode();
                }
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getDegreeName())) {
                    this.degreeName = new LocalizedString(I18N.getLocale(), treasuryEvent.getDegreeName());
                }
                if (!Strings.isNullOrEmpty((String)treasuryEvent.getExecutionYearName())) {
                    this.executionYear = treasuryEvent.getExecutionYearName();
                }
            }
            if (Strings.isNullOrEmpty((String)this.degreeCode)) {
                this.degreeCode = debitEntry.getDegreeCode();
            }
            if (Strings.isNullOrEmpty((String)this.executionYear)) {
                this.executionYear = debitEntry.getExecutionYearName();
            }
        }
    }

    private String entryType(InvoiceEntry entry) {
        if (entry.isDebitNoteEntry()) {
            return Constants.academicTreasuryBundle("label.DebtReportEntryBean.debitNoteEntry", new String[0]);
        }
        if (entry.isCreditNoteEntry()) {
            return Constants.academicTreasuryBundle("label.DebtReportEntryBean.creditNoteEntry", new String[0]);
        }
        return null;
    }

    private void fillStudentConditionsInformation(Registration registration, ExecutionYear executionYear) {
        this.firstTimeStudent = registration.isFirstTime(executionYear);
        this.partialRegime = registration.isPartialRegime(executionYear);
        this.statutes = this.statutes(registration, executionYear);
        this.agreement = registration.getRegistrationProtocol().getDescription();
        this.ingression = registration.getIngressionType().getDescription();
        this.numberOfNormalEnrolments = TuitionServices.normalEnrolments(registration, executionYear).size();
        this.numberOfStandaloneEnrolments = TuitionServices.standaloneEnrolments(registration, executionYear).size();
        this.numberOfExtracurricularEnrolments = TuitionServices.extracurricularEnrolments(registration, executionYear).size();
    }

    private String statutes(Registration registration, ExecutionYear executionYear) {
        return registration.getStudent().getStatutesTypesValidOnAnyExecutionSemesterFor(executionYear).stream().map(s -> s != null ? s.getName().getContent() : "").reduce((a, c) -> c + ", " + a).orElse(null);
    }

    public void writeCellValues(Row row, IErrorsLog ierrorsLog) {
        ErrorsLog errorsLog = (ErrorsLog)ierrorsLog;
        try {
            row.createCell(0).setCellValue(this.identification);
            if (!this.completed) {
                row.createCell(1).setCellValue(Constants.academicTreasuryBundle("error.DebtReportEntryBean.report.generation.verify.entry", new String[0]));
                return;
            }
            if (this.invoiceEntry.isDebitNoteEntry()) {
                int i = 1;
                row.createCell(i++).setCellValue(this.entryType);
                row.createCell(i++).setCellValue(this.versioningCreator);
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
                row.createCell(i++).setCellValue(this.entryDate.toString("yyyy/MM/dd HH:mm:ss"));
                row.createCell(i++).setCellValue(this.dueDate.toString("yyyy/MM/dd"));
                row.createCell(i++).setCellValue(this.customerId);
                row.createCell(i++).setCellValue(this.debtAccountId);
                row.createCell(i++).setCellValue(this.name);
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.email));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.registrationNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeType));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeCode));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeName));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.executionYear));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.executionSemester));
                row.createCell(i++).setCellValue(this.productCode);
                row.createCell(i++).setCellValue(this.invoiceEntryDescription);
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentExportationPending));
                int n = ++i;
                row.createCell(n).setCellValue(this.valueOrEmpty(this.amountToPay));
                int n2 = ++i;
                row.createCell(n2).setCellValue(this.valueOrEmpty(this.openAmountToPay));
                int n3 = ++i;
                row.createCell(n3).setCellValue(this.valueOrEmpty(this.payorDebtAccountVatNumber));
                int n4 = ++i;
                row.createCell(n4).setCellValue(this.valueOrEmpty(this.payorDebtAccountName));
                int n5 = ++i;
                row.createCell(n5).setCellValue(this.valueOrEmpty(this.agreement));
                int n6 = ++i;
                row.createCell(n6).setCellValue(this.valueOrEmpty(this.ingression));
                int n7 = ++i;
                row.createCell(n7).setCellValue(this.valueOrEmpty(this.firstTimeStudent));
                int n8 = ++i;
                row.createCell(n8).setCellValue(this.valueOrEmpty(this.partialRegime));
                int n9 = ++i;
                row.createCell(n9).setCellValue(this.valueOrEmpty(this.statutes));
                int n10 = ++i;
                row.createCell(n10).setCellValue(this.valueOrEmpty(this.numberOfNormalEnrolments));
                int n11 = ++i;
                row.createCell(n11).setCellValue(this.valueOrEmpty(this.numberOfStandaloneEnrolments));
                int n12 = ++i;
                row.createCell(n12).setCellValue(this.valueOrEmpty(this.numberOfExtracurricularEnrolments));
                int n13 = ++i;
                row.createCell(n13).setCellValue(this.valueOrEmpty(this.tuitionPaymentPlan));
                int n14 = ++i;
                row.createCell(n14).setCellValue(this.valueOrEmpty(this.tuitionPaymentPlanConditions));
                int n15 = ++i;
                row.createCell(n15).setCellValue(this.valueOrEmpty(this.annuled));
                int n16 = ++i;
                row.createCell(n16).setCellValue(this.valueOrEmpty(this.annuledReason));
                int n17 = ++i;
                row.createCell(n17).setCellValue(this.valueOrEmpty(this.closeDate));
                int n18 = ++i;
                row.createCell(n18).setCellValue(this.valueOrEmpty(this.openAmountAtERPStartDate));
                int n19 = ++i;
                row.createCell(n19).setCellValue(this.valueOrEmpty(this.exportedInLegacyERP));
                int n20 = ++i;
                row.createCell(n20).setCellValue(this.valueOrEmpty(this.legacyERPCertificateDocumentReference));
                int n21 = ++i;
                row.createCell(n21).setCellValue(this.valueOrEmpty(this.erpCertificationDate));
                int n22 = ++i;
                row.createCell(n22).setCellValue(this.valueOrEmpty(this.erpCertificateDocumentReference));
                int n23 = ++i;
                ++i;
                row.createCell(n23).setCellValue(this.valueOrEmpty(this.originSettlementNoteForAdvancedCredit));
            } else if (this.invoiceEntry.isCreditNoteEntry()) {
                int i = 1;
                row.createCell(i++).setCellValue(this.entryType);
                row.createCell(i++).setCellValue(this.versioningCreator);
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.creationDate));
                row.createCell(i++).setCellValue(this.entryDate.toString("yyyy/MM/dd HH:mm:ss"));
                row.createCell(i++).setCellValue(this.dueDate.toString("yyyy/MM/dd"));
                row.createCell(i++).setCellValue(this.customerId);
                row.createCell(i++).setCellValue(this.debtAccountId);
                row.createCell(i++).setCellValue(this.name);
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationType));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.identificationNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.vatNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.email));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.address));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.studentNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.registrationNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeType));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeCode));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.degreeName));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.executionYear));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.executionSemester));
                row.createCell(i++).setCellValue(this.productCode);
                row.createCell(i++).setCellValue(this.invoiceEntryDescription);
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.documentExportationPending));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.debitEntryIdentification));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.amountToPay));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.openAmountToPay));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.payorDebtAccountVatNumber));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.payorDebtAccountName));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.agreement));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.ingression));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.firstTimeStudent));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.partialRegime));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.statutes));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.numberOfNormalEnrolments));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.numberOfStandaloneEnrolments));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.numberOfExtracurricularEnrolments));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.tuitionPaymentPlan));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.tuitionPaymentPlanConditions));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.annuled));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.annuledReason));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.closeDate));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.openAmountAtERPStartDate));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.exportedInLegacyERP));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.legacyERPCertificateDocumentReference));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.erpCertificationDate));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.erpCertificateDocumentReference));
                row.createCell(i++).setCellValue(this.valueOrEmpty(this.originSettlementNoteForAdvancedCredit));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errorsLog.addError(this.invoiceEntry, e);
        }
    }

    private String valueOrEmpty(LocalDate value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd");
    }

    private String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    private String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return Constants.academicTreasuryBundle(value != false ? "label.true" : "label.false", new String[0]);
    }

    private String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (StringUtils.isEmpty((Object)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    private String valueOrEmpty(String value) {
        if (!StringUtils.isEmpty((Object)value)) {
            return value;
        }
        return "";
    }
}

