/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.reports;

import org.fenixedu.academictreasury.util.Constants;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.util.StringUtils;

public abstract class AbstractReportEntryBean
implements SpreadsheetRow {
    protected String valueOrEmpty(LocalDate value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd");
    }

    protected String valueOrEmpty(DateTime value) {
        if (value == null) {
            return "";
        }
        return value.toString("yyyy/MM/dd HH:mm:ss");
    }

    protected String valueOrEmpty(Boolean value) {
        if (value == null) {
            return "";
        }
        return Constants.academicTreasuryBundle(value != false ? "label.true" : "label.false", new String[0]);
    }

    protected String valueOrEmpty(Integer value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected String valueOrEmpty(LocalizedString value) {
        if (value == null) {
            return "";
        }
        if (StringUtils.isEmpty((Object)value.getContent())) {
            return "";
        }
        return value.getContent();
    }

    protected String valueOrEmpty(String value) {
        if (!StringUtils.isEmpty((Object)value)) {
            return value;
        }
        return "";
    }
}

