/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.reports;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;

public class ErrorsLog
implements IErrorsLog {
    final StringBuilder sb = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(InvoiceEntry entry, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = entry.getExternalId();
            String documentNumber = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getUiDocumentNumber() : "";
            String description = entry.getDescription();
            this.sb.append(String.format("[%s/%s] - '%s'\n", oid, documentNumber, description));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(SettlementEntry entry, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = entry.getExternalId();
            String documentNumber = entry.getFinantialDocument() != null ? entry.getFinantialDocument().getUiDocumentNumber() : "";
            String description = entry.getDescription() != null ? entry.getDescription() : "";
            this.sb.append(String.format("[%s/%s] - '%s'\n", oid, documentNumber, description));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(PaymentEntry entry, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = entry.getExternalId();
            String documentNumber = entry.getSettlementNote() != null ? entry.getSettlementNote().getUiDocumentNumber() : "";
            this.sb.append(String.format("[%s/%s]\n", oid, documentNumber));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(ReimbursementEntry entry, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = entry.getExternalId();
            String documentNumber = entry.getSettlementNote() != null ? entry.getSettlementNote().getUiDocumentNumber() : "";
            this.sb.append(String.format("[%s/%s]\n", oid, documentNumber));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(DebtAccount debtAccount, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = debtAccount.getExternalId();
            String identification = debtAccount.getCustomer().getIdentificationNumber();
            String name = debtAccount.getCustomer().getName();
            this.sb.append(String.format("[%s/%s] - %s\n", oid, identification, name));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(AcademicActBlockingSuspension academicActBlockingSuspension, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = academicActBlockingSuspension.getExternalId();
            String name = academicActBlockingSuspension.getPerson().getName();
            this.sb.append(String.format("[%s] - %s\n", oid, name));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(PaymentReferenceCode paymentReferenceCode, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = paymentReferenceCode.getExternalId();
            String referenceCode = paymentReferenceCode.getReferenceCode();
            this.sb.append(String.format("[%s] - %s\n", oid, referenceCode));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(SibsTransactionDetail sibsTransactionDetail, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = sibsTransactionDetail.getExternalId();
            String referenceCode = sibsTransactionDetail.getSibsPaymentReferenceCode();
            this.sb.append(String.format("[%s] - %s\n", oid, referenceCode));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(TreasuryExemption treasuryExemption, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = treasuryExemption.getExternalId();
            this.sb.append(String.format("[%s]\n", oid));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(Product product, Exception e) {
        ErrorsLog errorsLog = this;
        synchronized (errorsLog) {
            String oid = product.getExternalId();
            this.sb.append(String.format("[%s]\n", oid));
            this.sb.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n\n");
        }
    }

    public String getLog() {
        return this.sb.toString();
    }
}

